/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.MetadataField;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class MetadataAuthorityServiceImpl
implements MetadataAuthorityService {
    private static final Logger log = LogManager.getLogger(MetadataAuthorityServiceImpl.class);
    private static final String AUTH_PREFIX = "authority.controlled";
    @Autowired(required=true)
    protected MetadataFieldService metadataFieldService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    protected Map<String, Boolean> controlled = new HashMap<String, Boolean>();
    protected Map<String, Boolean> isAuthorityRequired = null;
    protected Map<String, Integer> minConfidence = new HashMap<String, Integer>();
    protected int defaultMinConfidence = 600;

    protected MetadataAuthorityServiceImpl() {
    }

    public void init() {
        if (this.isAuthorityRequired == null) {
            this.isAuthorityRequired = new HashMap<String, Boolean>();
            List keys = this.configurationService.getPropertyKeys(AUTH_PREFIX);
            Context context = new Context();
            try {
                for (String key : keys) {
                    MetadataField metadataField;
                    String field = key.substring(AUTH_PREFIX.length() + 1);
                    int dot = field.indexOf(46);
                    if (dot < 0) {
                        log.warn("Skipping invalid MetadataAuthority configuration property: {}: does not have schema.element.qualifier", (Object)key);
                        continue;
                    }
                    String schema = field.substring(0, dot);
                    String element = field.substring(dot + 1);
                    String qualifier = null;
                    dot = element.indexOf(46);
                    if (dot >= 0) {
                        qualifier = element.substring(dot + 1);
                        element = element.substring(0, dot);
                    }
                    if ((metadataField = this.metadataFieldService.findByElement(context, schema, element, qualifier)) == null) {
                        throw new IllegalStateException("Error while configuring authority control, metadata field: " + field + " could not be found");
                    }
                    boolean ctl = this.configurationService.getBooleanProperty(key, true);
                    boolean req = this.configurationService.getBooleanProperty("authority.required." + field, false);
                    this.controlled.put(metadataField.toString(), ctl);
                    this.isAuthorityRequired.put(metadataField.toString(), req);
                    int mci = this.readConfidence("authority.minconfidence." + field);
                    if (mci >= -1) {
                        this.minConfidence.put(metadataField.toString(), mci);
                    }
                    log.debug("Authority Control: For schema=" + schema + ", elt=" + element + ", qual=" + qualifier + ", controlled=" + ctl + ", required=" + req);
                }
            }
            catch (SQLException e) {
                log.error("Error reading authority config", (Throwable)e);
            }
            int dmc = this.readConfidence("authority.minconfidence");
            if (dmc >= -1) {
                this.defaultMinConfidence = dmc;
            }
        }
    }

    private int readConfidence(String key) {
        String mc = this.configurationService.getProperty(key);
        if (mc != null) {
            int mci = Choices.getConfidenceValue(mc.trim(), -2);
            if (mci == -2) {
                log.warn("IGNORING bad value in DSpace Configuration, key=" + key + ", value=" + mc + ", must be a valid Authority Confidence keyword.");
            } else {
                return mci;
            }
        }
        return -2;
    }

    @Override
    public boolean isAuthorityControlled(MetadataField metadataField) {
        this.init();
        return this.isAuthorityControlled(this.makeFieldKey(metadataField));
    }

    @Override
    public boolean isAuthorityControlled(String fieldKey) {
        this.init();
        return this.controlled.containsKey(fieldKey) && this.controlled.get(fieldKey) != false;
    }

    @Override
    public boolean isAuthorityRequired(MetadataField metadataField) {
        this.init();
        return this.isAuthorityRequired(this.makeFieldKey(metadataField));
    }

    @Override
    public boolean isAuthorityRequired(String fieldKey) {
        this.init();
        Boolean result = this.isAuthorityRequired.get(fieldKey);
        return result != null && result != false;
    }

    @Override
    public String makeFieldKey(MetadataField metadataField) {
        this.init();
        return metadataField.toString();
    }

    @Override
    public String makeFieldKey(String schema, String element, String qualifier) {
        this.init();
        if (qualifier == null) {
            return schema + "_" + element;
        }
        return schema + "_" + element + "_" + qualifier;
    }

    @Override
    public int getMinConfidence(MetadataField metadataField) {
        this.init();
        Integer result = this.minConfidence.get(this.makeFieldKey(metadataField));
        return result == null ? this.defaultMinConfidence : result;
    }

    @Override
    public List<String> getAuthorityMetadata() {
        this.init();
        ArrayList<String> copy = new ArrayList<String>();
        for (String s : this.controlled.keySet()) {
            copy.add(s.replaceAll("_", "."));
        }
        return copy;
    }

    @Override
    public void clearCache() {
        this.controlled.clear();
        this.minConfidence.clear();
        this.isAuthorityRequired = null;
    }
}

