/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.DecoderException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.CacheableDSpaceObject;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.PasswordHash;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RoleIngester
implements PackageIngester {
    private static final Logger log = LogManager.getLogger();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void ingestDocument(Context context, DSpaceObject parent, PackageParameters params, Document document) throws SQLException, AuthorizeException, PackageException {
        String name;
        Element group;
        int groupx;
        CacheableDSpaceObject collider;
        String myEmail = context.getCurrentUser().getEmail();
        String myNetid = context.getCurrentUser().getNetid();
        NodeList users = document.getElementsByTagName("Person");
        for (int i = 0; i < users.getLength(); ++i) {
            void var12_14;
            String netid;
            String email;
            Element user;
            block40: {
                void var16_46;
                user = (Element)users.item(i);
                NodeList emails = user.getElementsByTagName("Email");
                NodeList netids = user.getElementsByTagName("Netid");
                email = null;
                netid = null;
                if (emails.getLength() > 0) {
                    email = emails.item(0).getTextContent();
                    if (email.equals(myEmail)) continue;
                    String string = email;
                    collider = this.ePersonService.findByEmail(context, string);
                } else {
                    if (netids.getLength() <= 0) {
                        throw new PackageException("EPerson has neither email nor netid.");
                    }
                    netid = netids.item(0).getTextContent();
                    if (netid.equals(myNetid)) continue;
                    String string = netid;
                    collider = this.ePersonService.findByNetid(context, string);
                }
                if (null != collider) {
                    if (params.replaceModeEnabled()) {
                        CacheableDSpaceObject cacheableDSpaceObject = collider;
                        break block40;
                    } else {
                        if (!params.keepExistingModeEnabled()) {
                            throw new PackageException("EPerson " + (String)var16_46 + " already exists.");
                        }
                        log.warn("Existing EPerson {} was not restored from the package.", (Object)var16_46);
                        continue;
                    }
                }
                EPerson ePerson = this.ePersonService.create(context);
                log.info("Created EPerson {}.", (Object)var16_46);
            }
            var12_14.setEmail(email);
            var12_14.setNetid(netid);
            NodeList data = user.getElementsByTagName("FirstName");
            if (data.getLength() > 0) {
                var12_14.setFirstName(context, data.item(0).getTextContent());
            } else {
                var12_14.setFirstName(context, null);
            }
            data = user.getElementsByTagName("LastName");
            if (data.getLength() > 0) {
                var12_14.setLastName(context, data.item(0).getTextContent());
            } else {
                var12_14.setLastName(context, null);
            }
            data = user.getElementsByTagName("Language");
            if (data.getLength() > 0) {
                var12_14.setLanguage(context, data.item(0).getTextContent());
            } else {
                var12_14.setLanguage(context, null);
            }
            data = user.getElementsByTagName("CanLogin");
            var12_14.setCanLogIn(data.getLength() > 0);
            data = user.getElementsByTagName("RequireCertificate");
            var12_14.setRequireCertificate(data.getLength() > 0);
            data = user.getElementsByTagName("SelfRegistered");
            var12_14.setSelfRegistered(data.getLength() > 0);
            data = user.getElementsByTagName("PasswordHash");
            if (data.getLength() > 0) {
                PasswordHash password;
                Node element = data.item(0);
                NamedNodeMap attributes = element.getAttributes();
                Node algorithm = attributes.getNamedItem("digest");
                String algorithmText = null != algorithm ? algorithm.getNodeValue() : null;
                Node salt = attributes.getNamedItem("salt");
                String saltText = null != salt ? salt.getNodeValue() : null;
                try {
                    password = new PasswordHash(algorithmText, saltText, element.getTextContent());
                }
                catch (DecoderException ex) {
                    throw new PackageValidationException("Unable to decode hexadecimal password hash or salt", (Exception)((Object)ex));
                }
                this.ePersonService.setPasswordHash((EPerson)var12_14, password);
            } else {
                this.ePersonService.setPasswordHash((EPerson)var12_14, null);
            }
            this.ePersonService.update(context, var12_14);
        }
        NodeList groups = document.getElementsByTagName("Group");
        for (groupx = 0; groupx < groups.getLength(); ++groupx) {
            void var12_31;
            block41: {
                void var12_30;
                void var12_28;
                block43: {
                    String type;
                    block44: {
                        Collection collection;
                        block47: {
                            block46: {
                                block45: {
                                    group = (Element)groups.item(groupx);
                                    name = group.getAttribute("Name");
                                    log.debug("Processing group {}", (Object)name);
                                    try {
                                        name = PackageUtils.translateGroupNameForImport(context, name);
                                    }
                                    catch (PackageException packageException) {
                                        log.warn("Skipping group named '{}' as it seems to correspond to a Community or Collection that does not exist in the system.  If you are performing an AIP restore, you can ignore this warning as the Community/Collection AIP will likely create this group once it is processed.", (Object)name);
                                        continue;
                                    }
                                    log.debug("Translated group name:  {}", (Object)name);
                                    Object var12_19 = null;
                                    collider = this.groupService.findByName(context, name);
                                    if (null != collider) {
                                        if (params.replaceModeEnabled()) {
                                            ArrayList<Group> groupRemovalList = new ArrayList<Group>(((Group)collider).getMemberGroups());
                                            for (Group group2 : groupRemovalList) {
                                                this.groupService.removeMember(context, (Group)collider, group2);
                                            }
                                            ArrayList<EPerson> arrayList = new ArrayList<EPerson>(((Group)collider).getMembers());
                                            for (EPerson member : arrayList) {
                                                if (((Group)collider).equals(this.groupService.findByName(context, "Administrator")) && member.equals(context.getCurrentUser())) continue;
                                                this.groupService.removeMember(context, (Group)collider, member);
                                            }
                                            log.info("Existing Group {} was cleared. Its members will be replaced.", (Object)name);
                                            CacheableDSpaceObject cacheableDSpaceObject = collider;
                                            break block41;
                                        } else {
                                            if (!params.keepExistingModeEnabled()) {
                                                throw new PackageException("Group " + name + " already exists");
                                            }
                                            log.warn("Existing Group {} was not replaced from the package.", (Object)name);
                                            continue;
                                        }
                                    }
                                    DSpaceObjectService<DSpaceObject> dsoService = ContentServiceFactory.getInstance().getDSpaceObjectService(parent);
                                    log.debug("Creating group for a {}", (Object)dsoService.getTypeText(parent));
                                    type = group.getAttribute("Type");
                                    log.debug("Group type is {}", (Object)type);
                                    if (type == null || type.isEmpty() || parent == null) break block43;
                                    if (parent.getType() != 3) break block44;
                                    collection = (Collection)parent;
                                    if (!type.equals("ADMIN")) break block45;
                                    Group group3 = this.collectionService.createAdministrators(context, collection);
                                    break block43;
                                }
                                if (!type.equals("SUBMIT")) break block46;
                                Group group4 = this.collectionService.createSubmitters(context, collection);
                                break block43;
                            }
                            if (!type.equals("WORKFLOW_STEP_1")) break block47;
                            Group group5 = this.collectionService.createWorkflowGroup(context, collection, 1);
                            break block43;
                        }
                        if (type.equals("WORKFLOW_STEP_2")) {
                            Group group6 = this.collectionService.createWorkflowGroup(context, collection, 2);
                            break block43;
                        } else if (type.equals("WORKFLOW_STEP_3")) {
                            Group group7 = this.collectionService.createWorkflowGroup(context, collection, 3);
                        }
                        break block43;
                    }
                    if (parent.getType() == 4) {
                        Community community = (Community)parent;
                        if (type.equals("ADMIN")) {
                            Group group8 = this.communityService.createAdministrators(context, community);
                        }
                    }
                }
                if (var12_28 == null) {
                    Group group9 = this.groupService.create(context);
                }
                this.groupService.setName((Group)var12_30, name);
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = ((Group)var12_30)::getName;
                log.info("Created Group {}.", supplierArray);
            }
            NodeList members = group.getElementsByTagName("Member");
            for (int memberx = 0; memberx < members.getLength(); ++memberx) {
                Element element = (Element)members.item(memberx);
                String memberName = element.getAttribute("Name");
                EPerson memberEPerson = this.ePersonService.findByEmail(context, memberName);
                if (null == memberEPerson) {
                    throw new PackageValidationException("EPerson " + memberName + " not found, not added to " + name);
                }
                this.groupService.addMember(context, (Group)var12_31, memberEPerson);
            }
            this.groupService.update(context, var12_31);
        }
        groupx = 0;
        while (true) {
            block42: {
                if (groupx >= groups.getLength()) {
                    return;
                }
                group = (Element)groups.item(groupx);
                name = group.getAttribute("Name");
                log.debug("Processing group {}", (Object)name);
                try {
                    name = PackageUtils.translateGroupNameForImport(context, name);
                    log.debug("Translated group name:  {}", (Object)name);
                }
                catch (PackageException packageException) {
                    break block42;
                }
                Group group10 = this.groupService.findByName(context, name);
                log.debug("Looked up the group and found {}", (Object)group10);
                NodeList members = group.getElementsByTagName("MemberGroup");
                for (int memberx = 0; memberx < members.getLength(); ++memberx) {
                    Element member = (Element)members.item(memberx);
                    String string2 = member.getAttribute("Name");
                    string2 = PackageUtils.translateGroupNameForImport(context, string2);
                    Group memberGroup = this.groupService.findByName(context, string2);
                    this.groupService.addMember(context, group10, memberGroup);
                }
                this.groupService.update(context, group10);
            }
            ++groupx;
        }
    }

    public void ingestStream(Context context, DSpaceObject parent, PackageParameters params, InputStream stream) throws PackageException, SQLException, AuthorizeException {
        Document document;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setCoalescing(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(stream);
        }
        catch (ParserConfigurationException e) {
            throw new PackageException(e);
        }
        catch (SAXException e) {
            throw new PackageException(e);
        }
        catch (IOException e) {
            throw new PackageException(e);
        }
        this.ingestDocument(context, parent, params, document);
    }

    @Override
    public DSpaceObject ingest(Context context, DSpaceObject parent, File pkgFile, PackageParameters params, String license) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        Document document;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setCoalescing(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(pkgFile);
        }
        catch (ParserConfigurationException e) {
            throw new PackageException(e);
        }
        catch (SAXException e) {
            throw new PackageException(e);
        }
        this.ingestDocument(context, parent, params, document);
        return null;
    }

    @Override
    public List<String> ingestAll(Context context, DSpaceObject parent, File pkgFile, PackageParameters params, String license) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new PackageException("ingestAll() is not implemented, as ingest() method already handles ingestion of all roles from an external file.");
    }

    @Override
    public DSpaceObject replace(Context context, DSpaceObject dso, File pkgFile, PackageParameters params) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        return this.ingest(context, dso, pkgFile, params, null);
    }

    @Override
    public List<String> replaceAll(Context context, DSpaceObject dso, File pkgFile, PackageParameters params) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new PackageException("replaceAll() is not implemented, as replace() method already handles replacement of all roles from an external file.");
    }

    @Override
    public String getParameterHelp() {
        return "No additional options available.";
    }
}

