/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.service;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Thumbnail;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.DSpaceObjectLegacySupportService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.contentreport.QueryPredicate;
import org.dspace.core.Context;
import org.dspace.discovery.SearchServiceException;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public interface ItemService
extends DSpaceObjectService<Item>,
DSpaceObjectLegacySupportService<Item> {
    public Thumbnail getThumbnail(Context var1, Item var2, boolean var3) throws SQLException;

    public Item create(Context var1, WorkspaceItem var2) throws SQLException, AuthorizeException;

    public Item create(Context var1, WorkspaceItem var2, UUID var3) throws SQLException, AuthorizeException;

    public Item createTemplateItem(Context var1, Collection var2) throws SQLException, AuthorizeException;

    public void populateWithTemplateItemMetadata(Context var1, Collection var2, boolean var3, Item var4) throws SQLException;

    public Iterator<Item> findAll(Context var1) throws SQLException;

    public Iterator<Item> findAll(Context var1, Integer var2, Integer var3) throws SQLException;

    @Deprecated
    public Iterator<Item> findAllUnfiltered(Context var1) throws SQLException;

    public Iterator<Item> findAllRegularItems(Context var1) throws SQLException;

    public Iterator<Item> findBySubmitter(Context var1, EPerson var2) throws SQLException;

    public Iterator<Item> findBySubmitter(Context var1, EPerson var2, boolean var3) throws SQLException;

    public Iterator<Item> findBySubmitterDateSorted(Context var1, EPerson var2, Integer var3) throws SQLException;

    public Iterator<Item> findByCollection(Context var1, Collection var2) throws SQLException;

    public Iterator<Item> findByCollection(Context var1, Collection var2, Integer var3, Integer var4) throws SQLException;

    public Iterator<Item> findByCollectionMapping(Context var1, Collection var2, Integer var3, Integer var4) throws SQLException;

    public int countByCollectionMapping(Context var1, Collection var2) throws SQLException;

    public Iterator<Item> findAllByCollection(Context var1, Collection var2, Integer var3, Integer var4) throws SQLException;

    public Iterator<Item> findInArchiveOrWithdrawnDiscoverableModifiedSince(Context var1, Date var2) throws SQLException;

    public Iterator<Item> findInArchiveOrWithdrawnNonDiscoverableModifiedSince(Context var1, Date var2) throws SQLException;

    public Iterator<Item> findAllByCollection(Context var1, Collection var2) throws SQLException;

    public boolean isIn(Item var1, Collection var2) throws SQLException;

    public List<Community> getCommunities(Context var1, Item var2) throws SQLException;

    public List<Bundle> getBundles(Item var1, String var2) throws SQLException;

    public void addBundle(Context var1, Item var2, Bundle var3) throws SQLException, AuthorizeException;

    public void removeBundle(Context var1, Item var2, Bundle var3) throws SQLException, AuthorizeException, IOException;

    public void removeAllBundles(Context var1, Item var2) throws AuthorizeException, SQLException, IOException;

    public Bitstream createSingleBitstream(Context var1, InputStream var2, Item var3, String var4) throws AuthorizeException, IOException, SQLException;

    public Bitstream createSingleBitstream(Context var1, InputStream var2, Item var3) throws AuthorizeException, IOException, SQLException;

    public List<Bitstream> getNonInternalBitstreams(Context var1, Item var2) throws SQLException;

    public void removeDSpaceLicense(Context var1, Item var2) throws SQLException, AuthorizeException, IOException;

    public void removeLicenses(Context var1, Item var2) throws SQLException, AuthorizeException, IOException;

    public void withdraw(Context var1, Item var2) throws SQLException, AuthorizeException;

    public void reinstate(Context var1, Item var2) throws SQLException, AuthorizeException;

    public boolean isOwningCollection(Item var1, Collection var2);

    public void replaceAllItemPolicies(Context var1, Item var2, List<ResourcePolicy> var3) throws SQLException, AuthorizeException;

    public void replaceAllBitstreamPolicies(Context var1, Item var2, List<ResourcePolicy> var3) throws SQLException, AuthorizeException;

    public void removeGroupPolicies(Context var1, Item var2, Group var3) throws SQLException, AuthorizeException;

    public void inheritCollectionDefaultPolicies(Context var1, Item var2, Collection var3) throws SQLException, AuthorizeException;

    public void inheritCollectionDefaultPolicies(Context var1, Item var2, Collection var3, boolean var4) throws SQLException, AuthorizeException;

    public void adjustBundleBitstreamPolicies(Context var1, Item var2, Collection var3) throws SQLException, AuthorizeException;

    public void adjustBundleBitstreamPolicies(Context var1, Item var2, Collection var3, boolean var4) throws SQLException, AuthorizeException;

    public void adjustBitstreamPolicies(Context var1, Item var2, Collection var3, Bitstream var4) throws SQLException, AuthorizeException;

    public void adjustBitstreamPolicies(Context var1, Item var2, Collection var3, Bitstream var4, boolean var5) throws SQLException, AuthorizeException;

    public void adjustItemPolicies(Context var1, Item var2, Collection var3) throws SQLException, AuthorizeException;

    public void adjustItemPolicies(Context var1, Item var2, Collection var3, boolean var4) throws SQLException, AuthorizeException;

    public void move(Context var1, Item var2, Collection var3, Collection var4) throws SQLException, AuthorizeException, IOException;

    public void move(Context var1, Item var2, Collection var3, Collection var4, boolean var5) throws SQLException, AuthorizeException, IOException;

    public boolean hasUploadedFiles(Item var1) throws SQLException;

    public List<Collection> getCollectionsNotLinked(Context var1, Item var2) throws SQLException;

    public boolean canEdit(Context var1, Item var2) throws SQLException;

    public boolean canCreateNewVersion(Context var1, Item var2) throws SQLException;

    public Iterator<Item> findArchivedByMetadataField(Context var1, String var2, String var3, String var4, String var5) throws SQLException, AuthorizeException;

    public Iterator<Item> findArchivedByMetadataField(Context var1, String var2, String var3) throws SQLException, AuthorizeException;

    public Iterator<Item> findByMetadataField(Context var1, String var2, String var3, String var4, String var5) throws SQLException, AuthorizeException, IOException;

    public List<Item> findByMetadataQuery(Context var1, List<QueryPredicate> var2, List<UUID> var3, long var4, int var6) throws SQLException;

    public long countForMetadataQuery(Context var1, List<QueryPredicate> var2, List<UUID> var3) throws SQLException;

    public Iterator<Item> findByAuthorityValue(Context var1, String var2, String var3, String var4, String var5) throws SQLException, AuthorizeException;

    public Iterator<Item> findByMetadataFieldAuthority(Context var1, String var2, String var3) throws SQLException, AuthorizeException;

    public boolean isItemListedForUser(Context var1, Item var2);

    public int countItems(Context var1, Collection var2) throws SQLException;

    public int countAllItems(Context var1, Collection var2) throws SQLException;

    public Iterator<Item> findByLastModifiedSince(Context var1, Date var2) throws SQLException;

    public int countItems(Context var1, Community var2) throws SQLException;

    public int countAllItems(Context var1, Community var2) throws SQLException;

    public int countTotal(Context var1) throws SQLException;

    public int countNotArchivedItems(Context var1) throws SQLException;

    public int countArchivedItems(Context var1) throws SQLException;

    public int countWithdrawnItems(Context var1) throws SQLException;

    public List<Item> findItemsWithEdit(Context var1, int var2, int var3) throws SQLException, SearchServiceException;

    public int countItemsWithEdit(Context var1) throws SQLException, SearchServiceException;

    public boolean isInProgressSubmission(Context var1, Item var2) throws SQLException;

    public List<MetadataValue> getMetadata(Item var1, String var2, String var3, String var4, String var5, boolean var6);

    public String getEntityTypeLabel(Item var1);

    public EntityType getEntityType(Context var1, Item var2) throws SQLException;
}

