/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SolrServiceSearchPlugin;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceWorkspaceWorkflowRestrictionPlugin
implements SolrServiceSearchPlugin {
    public static final String DISCOVER_WORKSPACE_CONFIGURATION_NAME = "workspace";
    public static final String DISCOVER_WORKFLOW_CONFIGURATION_NAME = "workflow";
    public static final String DISCOVER_WORKFLOW_ADMIN_CONFIGURATION_NAME = "workflowAdmin";
    public static final String DISCOVER_SUPERVISION_CONFIGURATION_NAME = "supervision";
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;

    @Override
    public void additionalSearchParameters(Context context, DiscoverQuery discoveryQuery, SolrQuery solrQuery) throws SearchServiceException {
        boolean isWorkspace = StringUtils.startsWith((CharSequence)discoveryQuery.getDiscoveryConfigurationName(), (CharSequence)DISCOVER_WORKSPACE_CONFIGURATION_NAME);
        boolean isWorkflow = StringUtils.startsWith((CharSequence)discoveryQuery.getDiscoveryConfigurationName(), (CharSequence)DISCOVER_WORKFLOW_CONFIGURATION_NAME);
        boolean isWorkflowAdmin = this.isAdmin(context) && DISCOVER_WORKFLOW_ADMIN_CONFIGURATION_NAME.equals(discoveryQuery.getDiscoveryConfigurationName());
        boolean isSupervision = DISCOVER_SUPERVISION_CONFIGURATION_NAME.equals(discoveryQuery.getDiscoveryConfigurationName());
        EPerson currentUser = context.getCurrentUser();
        if (currentUser == null && (isWorkflow || isWorkspace || isSupervision)) {
            throw new IllegalStateException("An anonymous user cannot perform a workspace or workflow search");
        }
        if (isWorkspace) {
            solrQuery.addFilterQuery(new String[]{"submitter_authority:(" + currentUser.getID() + ")"});
        } else if (isWorkflow && !isWorkflowAdmin || isSupervision && !this.isAdmin(context)) {
            Set<Group> groups;
            try {
                groups = this.groupService.allMemberGroupsSet(context, currentUser);
            }
            catch (SQLException e) {
                throw new SearchServiceException(e.getMessage(), e);
            }
            StringBuilder controllerQuery = new StringBuilder();
            controllerQuery.append("taskfor:(e").append(currentUser.getID());
            for (Group group : groups) {
                controllerQuery.append(" OR g").append(group.getID());
            }
            controllerQuery.append(")");
            solrQuery.addFilterQuery(new String[]{controllerQuery.toString()});
        }
    }

    private boolean isAdmin(Context context) throws SearchServiceException {
        try {
            return this.authorizeService.isAdmin(context);
        }
        catch (SQLException e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
    }
}

