/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.indexobject.IndexFactoryImpl;
import org.dspace.discovery.indexobject.IndexableDSpaceObject;
import org.dspace.discovery.indexobject.factory.DSpaceObjectIndexFactory;

public abstract class DSpaceObjectIndexFactoryImpl<T extends IndexableDSpaceObject, S extends DSpaceObject>
extends IndexFactoryImpl<T, S>
implements DSpaceObjectIndexFactory<T, S> {
    @Override
    public SolrInputDocument buildDocument(Context context, T indexableObject) throws SQLException, IOException {
        SolrInputDocument doc = super.buildDocument(context, indexableObject);
        ReloadableEntity dso = ((IndexableDSpaceObject)indexableObject).getIndexedObject();
        if (((DSpaceObject)dso).getHandle() != null) {
            doc.addField("handle", (Object)((DSpaceObject)dso).getHandle());
        }
        List<String> locations = this.getLocations(context, indexableObject);
        this.storeCommunityCollectionLocations(doc, locations);
        return doc;
    }

    protected void addContainerMetadataField(SolrInputDocument doc, List<String> highlightedMetadataFields, List<String> toIgnoreMetadataFields, String metadataField, String value) {
        if ((toIgnoreMetadataFields == null || !toIgnoreMetadataFields.contains(metadataField)) && StringUtils.isNotBlank((CharSequence)value)) {
            doc.addField(metadataField, (Object)value);
            if (highlightedMetadataFields.contains(metadataField)) {
                doc.addField(metadataField + "_hl", (Object)value);
            }
        }
    }

    @Override
    public void storeCommunityCollectionLocations(SolrInputDocument doc, List<String> locations) {
        if (locations != null) {
            for (String location : locations) {
                doc.addField("location", (Object)location);
                if (location.startsWith("m")) {
                    doc.addField("location.comm", (Object)location.substring(1));
                    continue;
                }
                doc.addField("location.coll", (Object)location.substring(1));
            }
        }
    }
}

