/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.csv.TextAndCSVParser;
import org.apache.tika.sax.BodyContentHandler;
import org.dspace.core.Context;
import org.dspace.discovery.FullTextContentStreams;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SolrSearchCore;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.util.SolrUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class IndexFactoryImpl<T extends IndexableObject, S>
implements IndexFactory<T, S> {
    private static final Logger log = LogManager.getLogger(IndexFactoryImpl.class);
    @Autowired
    protected List<SolrServiceIndexPlugin> solrServiceIndexPlugins;
    @Autowired
    protected SolrSearchCore solrSearchCore;

    @Override
    public SolrInputDocument buildDocument(Context context, T indexableObject) throws SQLException, IOException {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField("SolrIndexer.lastIndexed", (Object)SolrUtils.getDateFormatter().format(new Date()));
        doc.addField("search.uniqueid", (Object)(indexableObject.getType() + "-" + indexableObject.getID()));
        doc.addField("search.resourcetype", (Object)indexableObject.getType());
        doc.addField("search.resourceid", (Object)indexableObject.getID().toString());
        for (SolrServiceIndexPlugin solrServiceIndexPlugin : ListUtils.emptyIfNull(this.solrServiceIndexPlugins)) {
            try {
                solrServiceIndexPlugin.additionalIndex(context, (IndexableObject)indexableObject, doc);
            }
            catch (Exception e) {
                log.error("An error occurred while indexing additional fields. Could not fully index item with UUID: {}. Plugin: {}", (Object)indexableObject.getUniqueIndexID(), (Object)solrServiceIndexPlugin.getClass().getSimpleName());
            }
        }
        return doc;
    }

    @Override
    public SolrInputDocument buildNewDocument(Context context, T indexableObject) throws SQLException, IOException {
        return this.buildDocument(context, indexableObject);
    }

    @Override
    public void writeDocument(Context context, T indexableObject, SolrInputDocument solrInputDocument) throws SQLException, IOException, SolrServerException {
        try {
            this.writeDocument(solrInputDocument, null);
        }
        catch (Exception e) {
            log.error("Error occurred while writing SOLR document for {} object {}", (Object)indexableObject.getType(), indexableObject.getID(), (Object)e);
        }
    }

    protected void writeDocument(SolrInputDocument doc, FullTextContentStreams streams) throws IOException, SolrServerException {
        SolrClient solr = this.solrSearchCore.getSolr();
        if (solr != null) {
            if (streams != null && !streams.isEmpty()) {
                block18: {
                    int charLimit = DSpaceServicesFactory.getInstance().getConfigurationService().getIntProperty("discovery.solr.fulltext.charLimit", 100000);
                    TextAndCSVParser tikaParser = new TextAndCSVParser();
                    BodyContentHandler tikaHandler = new BodyContentHandler(charLimit);
                    Metadata tikaMetadata = new Metadata();
                    ParseContext tikaContext = new ParseContext();
                    try (InputStream fullTextStreams = streams.getStream();){
                        tikaParser.parse(fullTextStreams, (ContentHandler)tikaHandler, tikaMetadata, tikaContext);
                        for (String name : tikaMetadata.names()) {
                            for (String value : tikaMetadata.getValues(name)) {
                                doc.addField("tika_meta_" + name, (Object)value);
                            }
                        }
                        doc.addField("fulltext", (Object)tikaHandler.toString());
                    }
                    catch (SAXException saxe) {
                        if (saxe.getMessage().contains("limit has been reached")) {
                            log.info("Full text is larger than the configured limit (discovery.solr.fulltext.charLimit). Only the first {} characters were indexed.", (Object)charLimit);
                            break block18;
                        }
                        log.error("Tika parsing error. Could not index full text.", (Throwable)saxe);
                        throw new IOException("Tika parsing error. Could not index full text.", saxe);
                    }
                    catch (IOException | TikaException ex) {
                        log.error("Tika parsing error. Could not index full text.", ex);
                        throw new IOException("Tika parsing error. Could not index full text.", ex);
                    }
                    finally {
                        solr.add(doc);
                    }
                }
                return;
            }
            solr.add(doc);
        }
    }

    protected void addFacetIndex(SolrInputDocument document, String field, String authority, String fvalue) {
        this.addFacetIndex(document, field, fvalue, authority, fvalue);
    }

    protected void addFacetIndex(SolrInputDocument document, String field, String sortValue, String authority, String fvalue) {
        String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
        if (separator == null) {
            separator = "\n|||\n";
        }
        String acvalue = sortValue + separator + fvalue + "###" + authority;
        document.addField(field + "_filter", (Object)acvalue);
        document.addField(field + "_keyword", (Object)fvalue);
        document.addField(field + "_ac", (Object)(fvalue.toLowerCase() + separator + fvalue));
        if (StringUtils.isNotBlank((CharSequence)authority)) {
            document.addField(field + "_acid", (Object)(fvalue.toLowerCase() + separator + fvalue + "###" + authority));
            document.addField(field + "_authority", (Object)authority);
        }
    }

    protected void addNamedResourceTypeIndex(SolrInputDocument document, String filterValue) {
        String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
        if (separator == null) {
            separator = "\n|||\n";
        }
        String[] avalues = filterValue.split("###");
        String sortValue = avalues[0];
        String authorityValue = avalues.length == 2 ? avalues[1] : filterValue;
        int idxSeparator = sortValue.indexOf(separator);
        String displayValue = idxSeparator != -1 ? sortValue.substring(idxSeparator + separator.length()) : sortValue;
        this.addFacetIndex(document, "namedresourcetype", sortValue, authorityValue, displayValue);
    }

    @Override
    public void delete(T indexableObject) throws IOException, SolrServerException {
        this.solrSearchCore.getSolr().deleteById(indexableObject.getUniqueIndexID());
    }

    @Override
    public void delete(String indexableObjectIdentifier) throws IOException, SolrServerException {
        this.solrSearchCore.getSolr().deleteById(indexableObjectIdentifier);
    }

    @Override
    public void deleteAll() throws IOException, SolrServerException {
        this.solrSearchCore.getSolr().deleteByQuery("search.resourcetype:" + this.getType());
    }
}

