/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.indexobject.IndexFactoryImpl;
import org.dspace.discovery.indexobject.IndexableLDNNotification;
import org.springframework.beans.factory.annotation.Autowired;

public class LDNMessageEntityIndexFactoryImpl
extends IndexFactoryImpl<IndexableLDNNotification, LDNMessageEntity> {
    @Autowired(required=true)
    private LDNMessageService ldnMessageService;
    @Autowired(required=true)
    private ItemService itemService;

    @Override
    public Iterator<IndexableLDNNotification> findAll(Context context) throws SQLException {
        final Iterator<LDNMessageEntity> ldnNotifications = this.ldnMessageService.findAll(context).iterator();
        return new Iterator<IndexableLDNNotification>(){

            @Override
            public boolean hasNext() {
                return ldnNotifications.hasNext();
            }

            @Override
            public IndexableLDNNotification next() {
                return new IndexableLDNNotification((LDNMessageEntity)ldnNotifications.next());
            }
        };
    }

    @Override
    public String getType() {
        return IndexableLDNNotification.TYPE;
    }

    @Override
    public Optional<IndexableLDNNotification> findIndexableObject(Context context, String id) throws SQLException {
        LDNMessageEntity ldnMessage = this.ldnMessageService.find(context, id);
        return ldnMessage == null ? Optional.empty() : Optional.of(new IndexableLDNNotification(ldnMessage));
    }

    @Override
    public boolean supports(Object object) {
        return object instanceof LDNMessageEntity;
    }

    @Override
    public List<IndexableLDNNotification> getIndexableObjects(Context context, LDNMessageEntity object) throws SQLException {
        return Arrays.asList(new IndexableLDNNotification(object));
    }

    @Override
    public SolrInputDocument buildDocument(Context context, IndexableLDNNotification indexableObject) throws SQLException, IOException {
        NotifyServiceEntity target;
        NotifyServiceEntity origin;
        Item item;
        SolrInputDocument doc = super.buildDocument(context, indexableObject);
        LDNMessageEntity ldnMessage = indexableObject.getIndexedObject();
        doc.addField("notification_id", (Object)ldnMessage.getID());
        doc.addField("queue_status_i", (Object)ldnMessage.getQueueStatus());
        doc.addField("queue_status_s", (Object)LDNMessageEntity.getQueueStatus(ldnMessage));
        this.addFacetIndex(doc, "queue_status", String.valueOf(ldnMessage.getQueueStatus()), LDNMessageEntity.getQueueStatus(ldnMessage));
        if (ldnMessage.getObject() != null && ldnMessage.getObject().getID() != null && (item = (Item)this.itemService.findByIdOrLegacyId(context, ldnMessage.getObject().getID().toString())) != null) {
            this.addFacetIndex(doc, "object", item.getID().toString(), this.itemService.getMetadata(item, "dc.title"));
            this.addFacetIndex(doc, "relateditem", item.getID().toString(), this.itemService.getMetadata(item, "dc.title"));
        }
        if (ldnMessage.getContext() != null && ldnMessage.getContext().getID() != null && (item = (Item)this.itemService.findByIdOrLegacyId(context, ldnMessage.getContext().getID().toString())) != null) {
            this.addFacetIndex(doc, "context", item.getID().toString(), this.itemService.getMetadata(item, "dc.title"));
            this.addFacetIndex(doc, "relateditem", item.getID().toString(), this.itemService.getMetadata(item, "dc.title"));
        }
        if ((origin = ldnMessage.getOrigin()) != null) {
            this.addFacetIndex(doc, "origin", String.valueOf(origin.getID()), LDNMessageEntity.getServiceNameForNotifyServ(origin));
            this.addFacetIndex(doc, "ldn_service", String.valueOf(origin.getID()), LDNMessageEntity.getServiceNameForNotifyServ(origin));
        }
        if ((target = ldnMessage.getTarget()) != null) {
            this.addFacetIndex(doc, "target", String.valueOf(target.getID()), LDNMessageEntity.getServiceNameForNotifyServ(target));
            this.addFacetIndex(doc, "ldn_service", String.valueOf(target.getID()), LDNMessageEntity.getServiceNameForNotifyServ(target));
        }
        if (ldnMessage.getInReplyTo() != null) {
            doc.addField("in_reply_to", (Object)ldnMessage.getInReplyTo().getID());
        }
        doc.addField("message", (Object)ldnMessage.getMessage());
        doc.addField("type", (Object)ldnMessage.getType());
        this.addFacetIndex(doc, "activity_stream_type", ldnMessage.getActivityStreamType(), ldnMessage.getActivityStreamType());
        this.addFacetIndex(doc, "coar_notify_type", ldnMessage.getCoarNotifyType(), ldnMessage.getCoarNotifyType());
        doc.addField("queue_attempts", (Object)ldnMessage.getQueueAttempts());
        doc.addField("queue_attempts_sort", (Object)ldnMessage.getQueueAttempts());
        this.indexDateFieldForFacet(doc, ldnMessage.getQueueLastStartTime());
        doc.addField("queue_timeout", (Object)ldnMessage.getQueueTimeout());
        String notificationType = LDNMessageEntity.getNotificationType(ldnMessage);
        this.addFacetIndex(doc, "notification_type", notificationType, notificationType);
        return doc;
    }

    private void indexDateFieldForFacet(SolrInputDocument doc, Date queueLastStartTime) {
        if (queueLastStartTime != null) {
            String value = DateFormatUtils.format((Date)queueLastStartTime, (String)"yyyy-MM-dd");
            this.addFacetIndex(doc, "queue_last_start_time", value, value);
            doc.addField("queue_last_start_time", (Object)value);
            doc.addField("queue_last_start_time_dt", (Object)queueLastStartTime);
            doc.addField("queue_last_start_time_min", (Object)value);
            doc.addField("queue_last_start_time_min_sort", (Object)value);
            doc.addField("queue_last_start_time_max", (Object)value);
            doc.addField("queue_last_start_time_max_sort", (Object)value);
            doc.addField("queue_last_start_time.year", (Object)Integer.parseInt(DateFormatUtils.format((Date)queueLastStartTime, (String)"yyyy")));
            doc.addField("queue_last_start_time.year_sort", (Object)Integer.parseInt(DateFormatUtils.format((Date)queueLastStartTime, (String)"yyyy")));
        }
    }
}

