/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.kernel.ServiceManager;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.service.ScriptService;
import org.springframework.beans.factory.annotation.Autowired;

public class ScriptServiceImpl
implements ScriptService {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private ServiceManager serviceManager;

    @Override
    public ScriptConfiguration getScriptConfiguration(String name) {
        return (ScriptConfiguration)this.serviceManager.getServiceByName(name, ScriptConfiguration.class);
    }

    @Override
    public List<ScriptConfiguration> getScriptConfigurations(Context context) {
        return this.serviceManager.getServicesByType(ScriptConfiguration.class).stream().filter(scriptConfiguration -> scriptConfiguration.isAllowedToExecute(context, null)).sorted(Comparator.comparing(ScriptConfiguration::getName)).collect(Collectors.toList());
    }

    @Override
    public DSpaceRunnable createDSpaceRunnableForScriptConfiguration(ScriptConfiguration scriptToExecute) throws IllegalAccessException, InstantiationException {
        try {
            return (DSpaceRunnable)scriptToExecute.getDspaceRunnableClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            log.error(e::getMessage, (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

