/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.versioning.AbstractVersionProvider;
import org.dspace.versioning.ItemVersionProvider;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.dspace.workflow.WorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultItemVersionProvider
extends AbstractVersionProvider
implements ItemVersionProvider {
    Logger log = LogManager.getLogger(DefaultItemVersionProvider.class);
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    protected WorkflowItemService workflowItemService;
    @Autowired(required=true)
    protected VersionHistoryService versionHistoryService;
    @Autowired(required=true)
    protected VersioningService versioningService;
    @Autowired(required=true)
    protected IdentifierService identifierService;
    @Autowired(required=true)
    protected RelationshipService relationshipService;

    @Override
    public Item createNewItemAndAddItInWorkspace(Context context, Item nativeItem) {
        try {
            WorkspaceItem workspaceItem = this.workspaceItemService.create(context, nativeItem.getOwningCollection(), false, true);
            Item itemNew = workspaceItem.getItem();
            this.itemService.update(context, itemNew);
            return itemNew;
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteVersionedItem(Context c, Version versionToDelete, VersionHistory history) throws SQLException {
        try {
            Item item;
            if (this.versionHistoryService.isLastVersion(c, history, versionToDelete) && this.versioningService.getVersionsByHistory(c, history).size() > 1 && (!(item = this.versionHistoryService.getPrevious(c, history, versionToDelete).getItem()).isArchived() || this.workspaceItemService.findByItem(c, versionToDelete.getItem()) != null || this.workflowItemService.findByItem(c, versionToDelete.getItem()) != null)) {
                item.setArchived(true);
                this.itemService.update(c, item);
            }
            Item itemToDelete = versionToDelete.getItem();
            this.identifierService.delete(c, itemToDelete);
        }
        catch (SQLException | AuthorizeException | IdentifierException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Item updateItemState(Context c, Item itemNew, Item previousItem) {
        try {
            this.copyMetadata(c, itemNew, previousItem);
            this.copyRelationships(c, itemNew, previousItem);
            this.createBundlesAndAddBitstreams(c, itemNew, previousItem);
            try {
                this.identifierService.reserve(c, itemNew);
            }
            catch (IdentifierException e) {
                throw new RuntimeException("Can't create Identifier!", e);
            }
            List<ResourcePolicy> policies = this.authorizeService.findPoliciesByDSOAndType(c, previousItem, ResourcePolicy.TYPE_CUSTOM);
            this.authorizeService.addPolicies(c, policies, itemNew);
            this.itemService.update(c, itemNew);
            return itemNew;
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void copyRelationships(Context context, Item newItem, Item oldItem) throws SQLException, AuthorizeException {
        List<Relationship> oldRelationships = this.relationshipService.findByItem(context, oldItem, -1, -1, false, true);
        for (Relationship oldRelationship : oldRelationships) {
            if (oldRelationship.getLeftItem().equals(oldItem)) {
                this.relationshipService.create(context, newItem, oldRelationship.getRightItem(), oldRelationship.getRelationshipType(), oldRelationship.getLeftPlace(), oldRelationship.getRightPlace(), oldRelationship.getLeftwardValue(), oldRelationship.getRightwardValue(), Relationship.LatestVersionStatus.RIGHT_ONLY);
                continue;
            }
            if (!oldRelationship.getRightItem().equals(oldItem)) continue;
            this.relationshipService.create(context, oldRelationship.getLeftItem(), newItem, oldRelationship.getRelationshipType(), oldRelationship.getLeftPlace(), oldRelationship.getRightPlace(), oldRelationship.getLeftwardValue(), oldRelationship.getRightwardValue(), Relationship.LatestVersionStatus.LEFT_ONLY);
        }
    }
}

