/*
 * Decompiled with CFR 0.152.
 */
package org.dspace;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractDSpaceIntegrationTest;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.authority.AuthoritySearchService;
import org.dspace.authority.MockAuthoritySolrServiceImpl;
import org.dspace.builder.AbstractBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.discovery.MockSolrSearchCore;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.kernel.ServiceManager;
import org.dspace.qaevent.MockQAEventService;
import org.dspace.qaevent.service.QAEventService;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.MockSolrLoggerServiceImpl;
import org.dspace.statistics.MockSolrStatisticsCore;
import org.dspace.statistics.SolrStatisticsCore;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.jdom2.Document;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public class AbstractIntegrationTestWithDatabase
extends AbstractDSpaceIntegrationTest {
    private static final Logger log = LogManager.getLogger(AbstractIntegrationTestWithDatabase.class);
    protected Context context;
    protected EPerson eperson;
    protected EPerson admin;
    protected String password = "mySuperS3cretP4ssW0rd";
    protected Community parentCommunity = null;

    @BeforeClass
    public static void initDatabase() {
        try {
            DatabaseUtils.updateDatabase();
            DataSource dataSource = (DataSource)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("dataSource", DataSource.class);
            try (Connection c = dataSource.getConnection();
                 Statement stmt = c.createStatement();){
                stmt.execute("CREATE ALIAS IF NOT EXISTS matches FOR 'org.dspace.util.DSpaceH2Dialect.matches'");
            }
        }
        catch (SQLException se) {
            log.error("Error initializing database", (Throwable)se);
            Assert.fail((String)("Error initializing database: " + se.getMessage() + (String)(se.getCause() == null ? "" : ": " + se.getCause().getMessage())));
        }
    }

    @Before
    public void setUp() throws Exception {
        try {
            this.context = new Context(Context.Mode.READ_WRITE);
            this.context.turnOffAuthorisationSystem();
            EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
            this.eperson = ePersonService.findByEmail(this.context, "test@email.com");
            if (this.eperson == null) {
                log.info("Creating Test EPerson (email=test@email.com) for Integration Tests");
                this.eperson = EPersonBuilder.createEPerson(this.context).withNameInMetadata("first", "last").withEmail("test@email.com").withCanLogin(true).withLanguage(I18nUtil.getDefaultLocale().getLanguage()).withPassword(this.password).build();
            }
            this.context.setCurrentUser(this.eperson);
            EPersonServiceFactory.getInstance().getGroupService().initDefaultGroupNames(this.context);
            this.admin = ePersonService.findByEmail(this.context, "admin@email.com");
            if (this.admin == null) {
                log.info("Creating Test Admin EPerson (email=admin@email.com) for Integration Tests");
                this.admin = EPersonBuilder.createEPerson(this.context).withNameInMetadata("first (admin)", "last (admin)").withEmail("admin@email.com").withCanLogin(true).withLanguage(I18nUtil.getDefaultLocale().getLanguage()).withPassword(this.password).build();
                GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
                Group adminGroup = groupService.findByName(this.context, "Administrator");
                groupService.addMember(this.context, adminGroup, this.admin);
            }
            this.context.restoreAuthSystemState();
        }
        catch (SQLException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            Assert.fail((String)"SQL Error on AbstractUnitTest init()");
        }
    }

    @After
    public void destroy() throws Exception {
        try {
            AbstractBuilder.cleanupObjects();
            this.parentCommunity = null;
            this.cleanupContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Error cleaning up builder objects & context object", e);
        }
        ServiceManager serviceManager = DSpaceServicesFactory.getInstance().getServiceManager();
        MockSolrSearchCore searchService = (MockSolrSearchCore)((Object)serviceManager.getServiceByName(null, MockSolrSearchCore.class));
        searchService.reset();
        ((MockSolrStatisticsCore)((Object)serviceManager.getServiceByName(SolrStatisticsCore.class.getName(), MockSolrStatisticsCore.class))).reset();
        MockSolrLoggerServiceImpl loggerService = (MockSolrLoggerServiceImpl)((Object)serviceManager.getServiceByName("solrLoggerService", MockSolrLoggerServiceImpl.class));
        loggerService.reset();
        MockAuthoritySolrServiceImpl authorityService = (MockAuthoritySolrServiceImpl)((Object)serviceManager.getServiceByName(AuthoritySearchService.class.getName(), MockAuthoritySolrServiceImpl.class));
        authorityService.reset();
        MockQAEventService qaEventService = (MockQAEventService)((Object)serviceManager.getServiceByName(QAEventService.class.getName(), MockQAEventService.class));
        qaEventService.reset();
        try {
            DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
            AbstractBuilder.cleanupBuilderCache();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reloading configuration & resetting builders", e);
        }
    }

    protected void cleanupContext() throws SQLException {
        if (this.context != null && this.context.isValid()) {
            this.context.complete();
        }
        if (this.context != null) {
            this.context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runDSpaceScript(String ... args) throws Exception {
        try {
            Document commandConfigs = ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl);
            if (args.length < 1) {
                log.error("You must provide at least one command argument");
            }
            TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
            int status = ScriptLauncher.handleScript((String[])args, (Document)commandConfigs, (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
            if (testDSpaceRunnableHandler.getException() != null) {
                throw testDSpaceRunnableHandler.getException();
            }
            int n = status;
            return n;
        }
        finally {
            if (!this.context.isValid()) {
                this.setUp();
            }
        }
    }
}

