/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import com.google.common.io.Files;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchUtils;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Document;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataExportSearchIT
extends AbstractIntegrationTestWithDatabase {
    private String subject1 = "subject1";
    private String subject2 = "subject2";
    private int numberItemsSubject1 = 30;
    private int numberItemsSubject2 = 2;
    private Item[] itemsSubject1 = new Item[this.numberItemsSubject1];
    private Item[] itemsSubject2 = new Item[this.numberItemsSubject2];
    private String filename;
    private Collection collection;
    private Logger logger = LogManager.getLogger(MetadataExportSearchIT.class);
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private SearchService searchService;

    @Override
    @Before
    public void setUp() throws Exception {
        int i;
        super.setUp();
        this.searchService = SearchUtils.getSearchService();
        DiscoverQuery query = new DiscoverQuery();
        query.setMaxResults(0);
        this.searchService.search(this.context, query);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        this.collection = CollectionBuilder.createCollection(this.context, community).build();
        this.filename = this.configurationService.getProperty("dspace.dir") + testProps.get("test.exportcsv").toString();
        for (i = 0; i < this.numberItemsSubject1; ++i) {
            this.itemsSubject1[i] = ItemBuilder.createItem(this.context, this.collection).withTitle(String.format("%s item %d", this.subject1, i)).withSubject(this.subject1).withIssueDate("2020-09-" + i).build();
        }
        for (i = 0; i < this.numberItemsSubject2; ++i) {
            this.itemsSubject2[i] = ItemBuilder.createItem(this.context, this.collection).withTitle(String.format("%s item %d", this.subject2, i)).withSubject(this.subject2).withIssueDate("2021-09-" + i).build();
        }
        this.context.restoreAuthSystemState();
    }

    private void checkItemsPresentInFile(String filename, Item[] items) throws IOException, CsvException {
        File file = new File(filename);
        BufferedReader reader = Files.newReader((File)file, (Charset)Charset.defaultCharset());
        CSVReader csvReader = new CSVReader((Reader)reader);
        List lines = csvReader.readAll();
        Assert.assertEquals((long)(items.length + 1), (long)lines.size());
        ArrayList<String> ids = new ArrayList<String>();
        this.logger.debug("checking content of lines");
        for (int i = 1; i < lines.size(); ++i) {
            this.logger.debug(String.join((CharSequence)", ", (CharSequence[])lines.get(i)));
            ids.add(((String[])lines.get(i))[0]);
        }
        for (Item item : items) {
            Assert.assertTrue((boolean)ids.contains(item.getID().toString()));
        }
    }

    @Test
    public void metadateExportSearchQueryTest() throws Exception {
        int result = this.runDSpaceScript("metadata-export-search", "-q", "subject:" + this.subject1, "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, this.itemsSubject1);
        result = this.runDSpaceScript("metadata-export-search", "-q", "subject: " + this.subject2, "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, this.itemsSubject2);
    }

    @Test
    public void exportMetadataSearchSpecificContainerTest() throws Exception {
        int i;
        this.context.turnOffAuthorisationSystem();
        Community community2 = CommunityBuilder.createCommunity(this.context).build();
        Collection collection2 = CollectionBuilder.createCollection(this.context, community2).build();
        int numberItemsDifferentCollection = 15;
        Item[] itemsDifferentCollection = new Item[numberItemsDifferentCollection];
        for (i = 0; i < numberItemsDifferentCollection; ++i) {
            itemsDifferentCollection[i] = ItemBuilder.createItem(this.context, collection2).withTitle("item different collection " + i).withSubject(this.subject1).build();
        }
        for (i = 0; i < 5; ++i) {
            ItemBuilder.createItem(this.context, collection2).withTitle("item different collection, different subject " + i).withSubject(this.subject2).build();
        }
        this.context.restoreAuthSystemState();
        int result = this.runDSpaceScript("metadata-export-search", "-q", "subject: " + this.subject1, "-s", collection2.getID().toString(), "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, itemsDifferentCollection);
    }

    @Test
    public void exportMetadataSearchFilter() throws Exception {
        int result = this.runDSpaceScript("metadata-export-search", "-f", "subject,equals=" + this.subject1, "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, this.itemsSubject1);
    }

    @Test
    public void exportMetadataSearchFilterDate() throws Exception {
        int result = this.runDSpaceScript("metadata-export-search", "-f", "dateIssued,equals=[2000 TO 2020]", "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, this.itemsSubject1);
    }

    @Test
    public void exportMetadataSearchMultipleFilters() throws Exception {
        int result = this.runDSpaceScript("metadata-export-search", "-f", "subject,equals=" + this.subject1, "-f", "title,equals=" + String.format("%s item %d", this.subject1, 0), "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        Item[] expectedResult = Arrays.copyOfRange(this.itemsSubject1, 0, 1);
        this.checkItemsPresentInFile(this.filename, expectedResult);
    }

    @Test
    public void exportMetadataSearchEqualsFilterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item wellBeingItem = ItemBuilder.createItem(this.context, this.collection).withTitle("test item well-being").withSubject("well-being").build();
        ItemBuilder.createItem(this.context, this.collection).withTitle("test item financial well-being").withSubject("financial well-being").build();
        this.context.restoreAuthSystemState();
        int result = this.runDSpaceScript("metadata-export-search", "-f", "subject,equals=well-being", "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        Item[] expectedResult = new Item[]{wellBeingItem};
        this.checkItemsPresentInFile(this.filename, expectedResult);
    }

    @Test
    public void exportMetadataSearchInvalidDiscoveryQueryTest() throws Exception {
        int result = this.runDSpaceScript("metadata-export-search", "-q", "blabla", "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        Item[] items = new Item[]{};
        this.checkItemsPresentInFile(this.filename, items);
    }

    @Test
    public void exportMetadataSearchNoResultsTest() throws Exception {
        int result = this.runDSpaceScript("metadata-export-search", "-f", "subject,equals=notExistingSubject", "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        Item[] items = new Item[]{};
        this.checkItemsPresentInFile(this.filename, items);
    }

    @Test
    public void exportMetadataSearchNonExistinFacetsTest() throws Exception {
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        String[] args = new String[]{"metadata-export-search", "-f", "nonExisting,equals=" + this.subject1, "-f", "title,equals=" + String.format("%s item %d", this.subject1, 0), "-n", this.filename};
        int result = ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        Assert.assertEquals((long)0L, (long)result);
        Exception exception = testDSpaceRunnableHandler.getException();
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)"nonExisting is not a valid search filter", (Object)exception.getMessage());
    }
}

