/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.solrdatabaseresync;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.discovery.MockSolrSearchCore;
import org.dspace.kernel.ServiceManager;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Document;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SolrDatabaseResyncIT
extends AbstractIntegrationTestWithDatabase {
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private MockSolrSearchCore searchService;
    private org.dspace.content.Collection col;
    private Item item1;
    private Item item2;
    private Item item3;
    private Item item4;
    private Item item5;
    private Item item6;
    private Item item7;
    private Item item8;
    private Item item9;
    private Item item10;
    private Item item11;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("solr-database-resync.time-until-reindex", (Object)1);
        this.configurationService.setProperty("script.solr-database-resync.batch-size", (Object)5);
        ServiceManager serviceManager = DSpaceServicesFactory.getInstance().getServiceManager();
        this.searchService = (MockSolrSearchCore)((Object)serviceManager.getServiceByName(null, MockSolrSearchCore.class));
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.col = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").build();
        this.item1 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 1").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        this.item2 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 2").withIssueDate("2011-08-13").withAuthor("Smith, Maria").withSubject("TestingForMore").build();
        this.item3 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 3").build();
        this.item4 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 4").build();
        this.item5 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 5").build();
        this.item6 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 6").build();
        this.item7 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 7").build();
        this.item8 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 8").build();
        this.item9 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 9").build();
        this.item10 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 10").build();
        this.item11 = ItemBuilder.createItem(this.context, this.col).withTitle("Public item 11").build();
        this.context.setDispatcher("noindex");
    }

    @Test
    public void solrPreDBStatusExistingItemTest() throws Exception {
        this.assertHasPreDBStatus(this.item1);
        this.assertHasPreDBStatus(this.item2);
        this.assertHasPreDBStatus(this.item3);
        this.assertHasPreDBStatus(this.item4);
        this.assertHasPreDBStatus(this.item5);
        this.assertHasPreDBStatus(this.item6);
        this.assertHasPreDBStatus(this.item7);
        this.assertHasPreDBStatus(this.item8);
        this.assertHasPreDBStatus(this.item9);
        this.assertHasPreDBStatus(this.item10);
        this.assertHasPreDBStatus(this.item11);
        this.performSolrDatabaseResyncScript();
        this.assertHasNoPreDBStatus(this.item1);
        this.assertHasNoPreDBStatus(this.item2);
        this.assertHasNoPreDBStatus(this.item3);
        this.assertHasNoPreDBStatus(this.item4);
        this.assertHasNoPreDBStatus(this.item5);
        this.assertHasNoPreDBStatus(this.item6);
        this.assertHasNoPreDBStatus(this.item7);
        this.assertHasNoPreDBStatus(this.item8);
        this.assertHasNoPreDBStatus(this.item9);
        this.assertHasNoPreDBStatus(this.item10);
        this.assertHasNoPreDBStatus(this.item11);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void solrPreDBStatusRemovedItemTest() throws Exception {
        this.assertHasPreDBStatus(this.item1);
        this.assertHasPreDBStatus(this.item2);
        this.assertHasPreDBStatus(this.item3);
        this.assertHasPreDBStatus(this.item4);
        this.assertHasPreDBStatus(this.item5);
        this.assertHasPreDBStatus(this.item6);
        this.assertHasPreDBStatus(this.item7);
        this.assertHasPreDBStatus(this.item8);
        this.assertHasPreDBStatus(this.item9);
        this.assertHasPreDBStatus(this.item10);
        this.assertHasPreDBStatus(this.item11);
        this.collectionService.delete(this.context, (DSpaceObject)this.col);
        this.assertHasPreDBStatus(this.item1);
        this.assertHasPreDBStatus(this.item2);
        this.assertHasPreDBStatus(this.item3);
        this.assertHasPreDBStatus(this.item4);
        this.assertHasPreDBStatus(this.item5);
        this.assertHasPreDBStatus(this.item6);
        this.assertHasPreDBStatus(this.item7);
        this.assertHasPreDBStatus(this.item8);
        this.assertHasPreDBStatus(this.item9);
        this.assertHasPreDBStatus(this.item10);
        this.assertHasPreDBStatus(this.item11);
        this.performSolrDatabaseResyncScript();
        this.assertNoSolrDocument(this.item1);
        this.assertNoSolrDocument(this.item2);
        this.assertNoSolrDocument(this.item3);
        this.assertNoSolrDocument(this.item4);
        this.assertNoSolrDocument(this.item5);
        this.assertNoSolrDocument(this.item6);
        this.assertNoSolrDocument(this.item7);
        this.assertNoSolrDocument(this.item8);
        this.assertNoSolrDocument(this.item9);
        this.assertNoSolrDocument(this.item10);
        this.assertNoSolrDocument(this.item11);
        this.context.restoreAuthSystemState();
    }

    public void assertHasNoPreDBStatus(Item item) throws Exception {
        Assert.assertNotEquals((Object)"predb", (Object)this.getStatus(item));
    }

    public void assertHasPreDBStatus(Item item) throws Exception {
        Assert.assertEquals((Object)"predb", (Object)this.getStatus(item));
    }

    public void assertNoSolrDocument(Item item) throws Exception {
        SolrDocumentList solrDocumentList = this.getSolrDocumentList(item);
        Assert.assertEquals((long)0L, (long)solrDocumentList.size());
    }

    public String getStatus(Item item) throws Exception {
        SolrDocumentList solrDocumentList = this.getSolrDocumentList(item);
        List fieldValues = (List)((SolrDocument)solrDocumentList.get(0)).getFieldValues("database_status");
        if (CollectionUtils.isNotEmpty((Collection)fieldValues)) {
            return (String)fieldValues.get(0);
        }
        return null;
    }

    public SolrDocumentList getSolrDocumentList(Item item) throws Exception {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery("search.resourceid:" + item.getID());
        QueryResponse queryResponse = this.searchService.getSolr().query((SolrParams)solrQuery);
        return queryResponse.getResults();
    }

    public void performSolrDatabaseResyncScript() throws Exception {
        String[] args = new String[]{"solr-database-resync"};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
    }
}

