/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion;

import java.util.List;
import java.util.Optional;
import org.apache.commons.codec.binary.StringUtils;
import org.dspace.app.suggestion.Suggestion;
import org.dspace.app.suggestion.SuggestionService;
import org.dspace.core.Context;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.AbstractExternalDataProvider;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.utils.DSpace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MockSuggestionExternalDataSource
extends AbstractExternalDataProvider {
    public static final String NAME = "suggestion";
    @Autowired
    private SuggestionService suggestionService;

    public String getSourceIdentifier() {
        return NAME;
    }

    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        RequestService requestService = new DSpace().getRequestService();
        Request currentRequest = requestService.getCurrentRequest();
        Context context = (Context)currentRequest.getAttribute("dspace.context");
        Suggestion suggestion = this.suggestionService.findUnprocessedSuggestion(context, id);
        if (suggestion != null) {
            ExternalDataObject extDataObj = new ExternalDataObject(NAME);
            extDataObj.setDisplayValue(suggestion.getDisplay());
            extDataObj.setId(suggestion.getExternalSourceUri().substring(suggestion.getExternalSourceUri().lastIndexOf("/") + 1));
            extDataObj.setMetadata(suggestion.getMetadata());
            return Optional.of(extDataObj);
        }
        return null;
    }

    public List<ExternalDataObject> searchExternalDataObjects(String query, int start, int limit) {
        return null;
    }

    public boolean supports(String source) {
        return StringUtils.equals((CharSequence)NAME, (CharSequence)source);
    }

    public int getNumberOfResults(String query) {
        return 0;
    }
}

