/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import org.dspace.AbstractDSpaceTest;
import org.dspace.app.util.Configuration;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsArrayContainingInAnyOrder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.Assertion;
import org.junit.contrib.java.lang.system.ExpectedSystemExit;
import org.junit.contrib.java.lang.system.SystemErrRule;
import org.junit.contrib.java.lang.system.SystemOutRule;

public class ConfigurationIT
extends AbstractDSpaceTest {
    private static ConfigurationService cfg;
    private static final String SINGLE_PROPERTY = "test.single";
    private static final String SINGLE_VALUE = "value";
    private static final String ARRAY_PROPERTY = "test.array";
    private static final String[] ARRAY_VALUE;
    private static final String PLACEHOLDER_PROPERTY = "test.substituted";
    private static final String PLACEHOLDER_VALUE = "insert ${test.single} here";
    private static final String SUBSTITUTED_VALUE = "insert value here";
    private static final String MISSING_PROPERTY = "test.missing";
    @Rule
    public final SystemOutRule systemOutRule = new SystemOutRule();
    @Rule
    public final SystemErrRule systemErrRule = new SystemErrRule();
    @Rule
    public final ExpectedSystemExit expectedSystemExit = ExpectedSystemExit.none();

    @BeforeClass
    public static void setupSuite() {
        cfg = kernelImpl.getConfigurationService();
        cfg.setProperty(SINGLE_PROPERTY, (Object)SINGLE_VALUE);
        cfg.setProperty(ARRAY_PROPERTY, (Object)ARRAY_VALUE);
        cfg.setProperty(PLACEHOLDER_PROPERTY, (Object)PLACEHOLDER_VALUE);
        cfg.setProperty(MISSING_PROPERTY, null);
    }

    @AfterClass
    public static void teardownSuite() {
        if (null != cfg) {
            cfg.setProperty(SINGLE_PROPERTY, null);
            cfg.setProperty(ARRAY_PROPERTY, null);
            cfg.setProperty(PLACEHOLDER_PROPERTY, null);
        }
    }

    @Test
    public void testMainAllSingle() {
        String[] argv = new String[]{"--property", SINGLE_PROPERTY};
        this.expectedSystemExit.expectSystemExitWithStatus(0);
        this.expectedSystemExit.checkAssertionAfterwards(new Assertion(){

            public void checkAssertion() {
                String[] output = ConfigurationIT.this.systemOutRule.getLogWithNormalizedLineSeparator().split("\n");
                MatcherAssert.assertThat((Object)output, (Matcher)Matchers.arrayWithSize((int)1));
            }
        });
        this.expectedSystemExit.checkAssertionAfterwards(new Assertion(){

            public void checkAssertion() {
                String[] output = ConfigurationIT.this.systemOutRule.getLogWithNormalizedLineSeparator().split("\n");
                MatcherAssert.assertThat((Object)output[0], (Matcher)Matchers.equalTo((Object)ConfigurationIT.SINGLE_VALUE));
            }
        });
        this.systemOutRule.enableLog();
        Configuration.main((String[])argv);
    }

    @Test
    public void testMainAllArray() {
        String[] argv = new String[]{"--property", ARRAY_PROPERTY};
        this.expectedSystemExit.expectSystemExitWithStatus(0);
        this.expectedSystemExit.checkAssertionAfterwards(new Assertion(){

            public void checkAssertion() {
                String[] output = ConfigurationIT.this.systemOutRule.getLogWithNormalizedLineSeparator().split("\n");
                MatcherAssert.assertThat((Object)output, (Matcher)Matchers.arrayWithSize((int)ARRAY_VALUE.length));
            }
        });
        this.expectedSystemExit.checkAssertionAfterwards(new Assertion(){

            public void checkAssertion() {
                String[] output = ConfigurationIT.this.systemOutRule.getLogWithNormalizedLineSeparator().split("\n");
                MatcherAssert.assertThat((Object)output, (Matcher)IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Object[])ARRAY_VALUE));
            }
        });
        this.systemOutRule.enableLog();
        Configuration.main((String[])argv);
    }

    @Test
    public void testMainAllSubstitution() {
        String[] argv = new String[]{"--property", PLACEHOLDER_PROPERTY};
        this.expectedSystemExit.expectSystemExitWithStatus(0);
        this.expectedSystemExit.checkAssertionAfterwards(new Assertion(){

            public void checkAssertion() {
                String[] output = ConfigurationIT.this.systemOutRule.getLogWithNormalizedLineSeparator().split("\n");
                MatcherAssert.assertThat((Object)output, (Matcher)Matchers.arrayWithSize((int)1));
            }
        });
        this.expectedSystemExit.checkAssertionAfterwards(new Assertion(){

            public void checkAssertion() {
                String[] output = ConfigurationIT.this.systemOutRule.getLogWithNormalizedLineSeparator().split("\n");
                MatcherAssert.assertThat((Object)output[0], (Matcher)Matchers.equalTo((Object)ConfigurationIT.SUBSTITUTED_VALUE));
            }
        });
        this.systemOutRule.enableLog();
        Configuration.main((String[])argv);
    }

    @Test
    public void testMainAllRaw() {
        String[] argv = new String[]{"--property", PLACEHOLDER_PROPERTY, "--raw"};
        this.expectedSystemExit.expectSystemExitWithStatus(0);
        this.expectedSystemExit.checkAssertionAfterwards(new Assertion(){

            public void checkAssertion() {
                String[] output = ConfigurationIT.this.systemOutRule.getLogWithNormalizedLineSeparator().split("\n");
                MatcherAssert.assertThat((Object)output, (Matcher)Matchers.arrayWithSize((int)1));
            }
        });
        this.expectedSystemExit.checkAssertionAfterwards(new Assertion(){

            public void checkAssertion() {
                String[] output = ConfigurationIT.this.systemOutRule.getLogWithNormalizedLineSeparator().split("\n");
                MatcherAssert.assertThat((Object)output[0], (Matcher)Matchers.equalTo((Object)ConfigurationIT.PLACEHOLDER_VALUE));
            }
        });
        this.systemOutRule.enableLog();
        Configuration.main((String[])argv);
    }

    @Test
    public void testMainAllUndefined() {
        String[] argv = new String[]{"--property", MISSING_PROPERTY};
        this.expectedSystemExit.expectSystemExitWithStatus(0);
        this.expectedSystemExit.checkAssertionAfterwards(new Assertion(){

            public void checkAssertion() {
                String outputs = ConfigurationIT.this.systemOutRule.getLogWithNormalizedLineSeparator();
                String[] output = outputs.split("\n");
                MatcherAssert.assertThat((Object)output, (Matcher)Matchers.arrayWithSize((int)0));
            }
        });
        this.systemOutRule.enableLog();
        Configuration.main((String[])argv);
    }

    @Test
    public void testMainFirstArray() {
        String[] argv = new String[]{"--property", ARRAY_PROPERTY, "--first"};
        this.expectedSystemExit.expectSystemExitWithStatus(0);
        this.expectedSystemExit.checkAssertionAfterwards(() -> {
            String outputs = this.systemOutRule.getLogWithNormalizedLineSeparator();
            String[] output = outputs.split("\n");
            MatcherAssert.assertThat((Object)output, (Matcher)Matchers.arrayWithSize((int)1));
            Assert.assertEquals((String)"--first should return first value", (Object)output[0], (Object)ARRAY_VALUE[0]);
        });
        this.systemOutRule.enableLog();
        Configuration.main((String[])argv);
    }

    @Test
    public void testMainFirstSingle() {
        String[] argv = new String[]{"--property", SINGLE_PROPERTY, "--first"};
        this.expectedSystemExit.expectSystemExitWithStatus(0);
        this.expectedSystemExit.checkAssertionAfterwards(() -> {
            String outputs = this.systemOutRule.getLogWithNormalizedLineSeparator();
            String[] output = outputs.split("\n");
            MatcherAssert.assertThat((Object)output, (Matcher)Matchers.arrayWithSize((int)1));
            Assert.assertEquals((String)"--first should return only value", (Object)output[0], (Object)SINGLE_VALUE);
        });
        this.systemOutRule.enableLog();
        Configuration.main((String[])argv);
    }

    static {
        ARRAY_VALUE = new String[]{"one", "two"};
    }
}

