/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Period;
import java.util.Locale;
import java.util.UUID;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractDSpaceObjectBuilder;
import org.dspace.builder.OrcidTokenBuilder;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.LicenseUtils;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.profile.OrcidEntitySyncPreference;
import org.dspace.profile.OrcidProfileSyncPreference;
import org.dspace.profile.OrcidSynchronizationMode;

public class ItemBuilder
extends AbstractDSpaceObjectBuilder<Item> {
    private boolean withdrawn = false;
    private String handle = null;
    private WorkspaceItem workspaceItem;
    private Item item;
    private Group readerGroup = null;

    protected ItemBuilder(Context context) {
        super(context);
    }

    public static ItemBuilder createItem(Context context, Collection col) {
        ItemBuilder builder = new ItemBuilder(context);
        return builder.create(context, col);
    }

    private ItemBuilder create(Context context, Collection col) {
        this.context = context;
        try {
            this.workspaceItem = workspaceItemService.create(context, col, true);
            this.item = this.workspaceItem.getItem();
        }
        catch (Exception e) {
            return (ItemBuilder)this.handleException(e);
        }
        return this;
    }

    public ItemBuilder withTitle(String title) {
        return (ItemBuilder)this.setMetadataSingleValue(this.item, MetadataSchemaEnum.DC.getName(), "title", null, title);
    }

    public ItemBuilder withIssueDate(String issueDate) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "date", "issued", new DCDate(issueDate).toString());
    }

    public ItemBuilder withIdentifierOther(String identifierOther) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "identifier", "other", identifierOther);
    }

    public ItemBuilder withAuthor(String authorName) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "contributor", "author", authorName);
    }

    public ItemBuilder withAuthor(String authorName, String authority, int confidence) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "contributor", "author", null, authorName, authority, confidence);
    }

    public ItemBuilder withEditor(String editorName) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "contributor", "editor", editorName);
    }

    public ItemBuilder withDescriptionAbstract(String description) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "description", "abstract", description);
    }

    public ItemBuilder withLanguage(String language) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "language", "iso", language);
    }

    public ItemBuilder withIsPartOf(String isPartOf) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "relation", "ispartof", isPartOf);
    }

    public ItemBuilder withDoiIdentifier(String doi) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "identifier", "doi", doi);
    }

    public ItemBuilder withScopusIdentifier(String scopus) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "identifier", "scopus", scopus);
    }

    public ItemBuilder withRelationFunding(String funding) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "relation", "funding", funding);
    }

    public ItemBuilder withRelationFunding(String funding, String authority) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "relation", "funding", null, funding, authority, 600);
    }

    public ItemBuilder withRelationGrantno(String grantno) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "relation", "grantno", grantno);
    }

    public ItemBuilder withPersonIdentifierFirstName(String personIdentifierFirstName) {
        return (ItemBuilder)this.addMetadataValue(this.item, "person", "givenName", null, personIdentifierFirstName);
    }

    public ItemBuilder withPersonIdentifierLastName(String personIdentifierLastName) {
        return (ItemBuilder)this.addMetadataValue(this.item, "person", "familyName", null, personIdentifierLastName);
    }

    public ItemBuilder withSubject(String subject) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "subject", null, subject);
    }

    public ItemBuilder withSubject(String subject, String authority, int confidence) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "subject", null, null, subject, authority, confidence);
    }

    public ItemBuilder withType(String type) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "type", null, type);
    }

    public ItemBuilder withPublicationIssueNumber(String issueNumber) {
        return (ItemBuilder)this.addMetadataValue(this.item, "publicationissue", "issueNumber", null, issueNumber);
    }

    public ItemBuilder withPublicationVolumeNumber(String volumeNumber) {
        return (ItemBuilder)this.addMetadataValue(this.item, "publicationvolume", "volumeNumber", null, volumeNumber);
    }

    public ItemBuilder withProvenanceData(String provenanceData) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "description", "provenance", provenanceData);
    }

    public ItemBuilder enableIIIF() {
        return (ItemBuilder)this.addMetadataValue(this.item, "dspace", "iiif", "enabled", "true");
    }

    public ItemBuilder disableIIIF() {
        return (ItemBuilder)this.addMetadataValue(this.item, "dspace", "iiif", "enabled", "false");
    }

    public ItemBuilder enableIIIFSearch() {
        return (ItemBuilder)this.addMetadataValue(this.item, "iiif", "search", "enabled", "true");
    }

    public ItemBuilder withIIIFViewingHint(String hint) {
        return (ItemBuilder)this.addMetadataValue(this.item, "iiif", "viewing", "hint", hint);
    }

    public ItemBuilder withIIIFCanvasNaming(String naming) {
        return (ItemBuilder)this.addMetadataValue(this.item, "iiif", "canvas", "naming", naming);
    }

    public ItemBuilder withIIIFCanvasWidth(int i) {
        return (ItemBuilder)this.addMetadataValue(this.item, "iiif", "image", "width", String.valueOf(i));
    }

    public ItemBuilder withIIIFCanvasHeight(int i) {
        return (ItemBuilder)this.addMetadataValue(this.item, "iiif", "image", "height", String.valueOf(i));
    }

    public ItemBuilder withDSpaceObjectOwner(String name, String authority) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dspace", "object", "owner", null, name, authority, 600);
    }

    public ItemBuilder withMetadata(String schema, String element, String qualifier, String value) {
        return (ItemBuilder)this.addMetadataValue(this.item, schema, element, qualifier, value);
    }

    public ItemBuilder withDspaceObjectOwner(String value, String authority) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dspace", "object", "owner", null, value, authority, 600);
    }

    public ItemBuilder withOrcidIdentifier(String orcid) {
        return (ItemBuilder)this.addMetadataValue(this.item, "person", "identifier", "orcid", orcid);
    }

    public ItemBuilder withOrcidAccessToken(String accessToken, EPerson owner) {
        try {
            OrcidTokenBuilder.create(this.context, owner, accessToken).withProfileItem(this.item).build();
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ItemBuilder withOrcidAuthenticated(String authenticated) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dspace", "orcid", "authenticated", authenticated);
    }

    public ItemBuilder withOrcidSynchronizationPublicationsPreference(OrcidEntitySyncPreference value) {
        return this.withOrcidSynchronizationPublicationsPreference(value.name());
    }

    public ItemBuilder withOrcidSynchronizationPublicationsPreference(String value) {
        return (ItemBuilder)this.setMetadataSingleValue(this.item, "dspace", "orcid", "sync-publications", value);
    }

    public ItemBuilder withOrcidSynchronizationFundingsPreference(OrcidEntitySyncPreference value) {
        return this.withOrcidSynchronizationFundingsPreference(value.name());
    }

    public ItemBuilder withOrcidSynchronizationFundingsPreference(String value) {
        return (ItemBuilder)this.setMetadataSingleValue(this.item, "dspace", "orcid", "sync-fundings", value);
    }

    public ItemBuilder withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference value) {
        return this.withOrcidSynchronizationProfilePreference(value.name());
    }

    public ItemBuilder withOrcidSynchronizationProfilePreference(String value) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dspace", "orcid", "sync-profile", value);
    }

    public ItemBuilder withOrcidSynchronizationMode(OrcidSynchronizationMode mode) {
        return this.withOrcidSynchronizationMode(mode.name());
    }

    private ItemBuilder withOrcidSynchronizationMode(String mode) {
        return (ItemBuilder)this.setMetadataSingleValue(this.item, "dspace", "orcid", "sync-mode", mode);
    }

    public ItemBuilder withPersonCountry(String country) {
        return (ItemBuilder)this.addMetadataValue(this.item, "person", "country", null, country);
    }

    public ItemBuilder withScopusAuthorIdentifier(String id) {
        return (ItemBuilder)this.addMetadataValue(this.item, "person", "identifier", "scopus-author-id", id);
    }

    public ItemBuilder withResearcherIdentifier(String rid) {
        return (ItemBuilder)this.addMetadataValue(this.item, "person", "identifier", "rid", rid);
    }

    public ItemBuilder withVernacularName(String vernacularName) {
        return (ItemBuilder)this.setMetadataSingleValue(this.item, "person", "name", "translated", vernacularName);
    }

    public ItemBuilder withVariantName(String variant) {
        return (ItemBuilder)this.addMetadataValue(this.item, "person", "name", "variant", variant);
    }

    public ItemBuilder makeUnDiscoverable() {
        this.item.setDiscoverable(false);
        return this;
    }

    public ItemBuilder withHandle(String handle) {
        this.handle = handle;
        return this;
    }

    public ItemBuilder withdrawn() {
        this.withdrawn = true;
        return this;
    }

    public ItemBuilder withEmbargoPeriod(Period embargoPeriod) {
        return (ItemBuilder)this.setEmbargo(embargoPeriod, (DSpaceObject)this.item);
    }

    public ItemBuilder withReaderGroup(Group group) {
        this.readerGroup = group;
        return this;
    }

    public ItemBuilder withOrgUnitLegalName(String name) {
        return (ItemBuilder)this.addMetadataValue(this.item, "organization", "legalName", null, name);
    }

    public ItemBuilder withOrgUnitCountry(String addressCountry) {
        return (ItemBuilder)this.addMetadataValue(this.item, "organization", "address", "addressCountry", addressCountry);
    }

    public ItemBuilder withOrgUnitLocality(String addressLocality) {
        return (ItemBuilder)this.addMetadataValue(this.item, "organization", "address", "addressLocality", addressLocality);
    }

    public ItemBuilder withOrgUnitCrossrefIdentifier(String crossrefid) {
        return (ItemBuilder)this.addMetadataValue(this.item, "organization", "identifier", "crossrefid", crossrefid);
    }

    public ItemBuilder withProjectStartDate(String startDate) {
        return (ItemBuilder)this.addMetadataValue(this.item, "project", "startDate", null, startDate);
    }

    public ItemBuilder withProjectEndDate(String endDate) {
        return (ItemBuilder)this.addMetadataValue(this.item, "project", "endDate", null, endDate);
    }

    public ItemBuilder withProjectInvestigator(String investigator) {
        return (ItemBuilder)this.addMetadataValue(this.item, "project", "investigator", null, investigator);
    }

    public ItemBuilder withDescription(String description) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "description", null, description);
    }

    public ItemBuilder withProjectAmount(String amount) {
        return (ItemBuilder)this.addMetadataValue(this.item, "project", "amount", null, amount);
    }

    public ItemBuilder withProjectAmountCurrency(String currency) {
        return (ItemBuilder)this.addMetadataValue(this.item, "project", "amount", "currency", currency);
    }

    public ItemBuilder withUriIdentifier(String uri) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "identifier", "uri", uri);
    }

    public ItemBuilder withIdentifier(String identifier) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "identifier", null, identifier);
    }

    public ItemBuilder withOtherIdentifier(String identifier) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "identifier", "other", identifier);
    }

    public ItemBuilder withAdminUser(EPerson ePerson) throws SQLException, AuthorizeException {
        return (ItemBuilder)this.setAdminPermission((DSpaceObject)this.item, ePerson, null);
    }

    public ItemBuilder withPersonEmail(String email) {
        return (ItemBuilder)this.addMetadataValue(this.item, "person", "email", null, email);
    }

    @Override
    public Item build() {
        try {
            installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItem, this.handle);
            itemService.update(this.context, (DSpaceObject)this.item);
            if (this.readerGroup != null) {
                this.setOnlyReadPermission((DSpaceObject)this.workspaceItem.getItem(), this.readerGroup, null);
            }
            if (this.withdrawn) {
                itemService.withdraw(this.context, this.item);
            }
            this.context.dispatchEvents();
            indexingService.commit();
            return this.item;
        }
        catch (Exception e) {
            return (Item)this.handleException(e);
        }
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.workspaceItem = (WorkspaceItem)c.reloadEntity((ReloadableEntity)this.workspaceItem);
            if (this.workspaceItem != null) {
                workspaceItemService.deleteAll(c, this.workspaceItem);
            }
            this.item = (Item)c.reloadEntity((ReloadableEntity)this.item);
            if (this.item != null) {
                this.delete(c, this.item);
            }
            c.complete();
        }
    }

    @Override
    protected DSpaceObjectService<Item> getService() {
        return itemService;
    }

    public static void deleteItem(UUID uuid) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            Item item = (Item)itemService.find(c, uuid);
            if (item != null) {
                try {
                    itemService.delete(c, (DSpaceObject)item);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e);
                }
            }
            c.complete();
        }
    }

    public ItemBuilder grantLicense() {
        try {
            EPerson submitter = this.workspaceItem.getSubmitter();
            submitter = (EPerson)this.context.reloadEntity((ReloadableEntity)submitter);
            String license = LicenseUtils.getLicenseText((Locale)this.context.getCurrentLocale(), (Collection)this.workspaceItem.getCollection(), (Item)this.item, (EPerson)submitter);
            LicenseUtils.grantLicense((Context)this.context, (Item)this.item, (String)license, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }
}

