/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.util.List;
import java.util.Optional;
import org.dspace.AbstractDSpaceTest;
import org.dspace.external.factory.ExternalServiceFactory;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.ExternalDataProvider;
import org.dspace.external.service.ExternalDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenaireFundingDataProviderTest
extends AbstractDSpaceTest {
    ExternalDataService externalDataService;
    ExternalDataProvider openaireFundingDataProvider;

    @Before
    public void init() {
        this.externalDataService = ExternalServiceFactory.getInstance().getExternalDataService();
        this.openaireFundingDataProvider = this.externalDataService.getExternalDataProvider("openaireFunding");
    }

    @Test
    public void testNumberOfResultsWSingleKeyword() {
        Assert.assertNotNull((String)"openaireFundingDataProvider is not null", (Object)this.openaireFundingDataProvider);
        Assert.assertEquals((String)"openaireFunding.numberOfResults.query:mock", (long)77L, (long)this.openaireFundingDataProvider.getNumberOfResults("mock"));
    }

    @Test
    public void testNumberOfResultsWKeywords() {
        Assert.assertNotNull((String)"openaireFundingDataProvider is not null", (Object)this.openaireFundingDataProvider);
        Assert.assertEquals((String)"openaireFunding.numberOfResults.query:mock+test", (long)77L, (long)this.openaireFundingDataProvider.getNumberOfResults("mock+test"));
    }

    @Test
    public void testQueryResultsWSingleKeyword() {
        Assert.assertNotNull((String)"openaireFundingDataProvider is not null", (Object)this.openaireFundingDataProvider);
        List results = this.openaireFundingDataProvider.searchExternalDataObjects("mock", 0, 10);
        Assert.assertEquals((String)"openaireFunding.searchExternalDataObjects.size", (long)10L, (long)results.size());
    }

    @Test
    public void testQueryResultsWKeywords() {
        String value = "Mushroom Robo-Pic - Development of an autonomous robotic mushroom picking system";
        Assert.assertNotNull((String)"openaireFundingDataProvider is not null", (Object)this.openaireFundingDataProvider);
        List results = this.openaireFundingDataProvider.searchExternalDataObjects("mock+test", 0, 10);
        Assert.assertEquals((String)"openaireFunding.searchExternalDataObjects.size", (long)10L, (long)results.size());
        Assert.assertTrue((String)"openaireFunding.searchExternalDataObjects.first.value", (boolean)value.equals(((ExternalDataObject)results.get(0)).getValue()));
    }

    @Test
    public void testGetDataObject() {
        String id = "aW5mbzpldS1yZXBvL2dyYW50QWdyZWVtZW50L0ZDVC81ODc2LVBQQ0RUSS8xMTAwNjIvUFQ=";
        String value = "Portuguese Wild Mushrooms: Chemical characterization and functional study of antiproliferative and proapoptotic properties in cancer cell lines";
        Assert.assertNotNull((String)"openaireFundingDataProvider is not null", (Object)this.openaireFundingDataProvider);
        Optional result = this.openaireFundingDataProvider.getExternalDataObject(id);
        Assert.assertTrue((String)"openaireFunding.getExternalDataObject.exists", (boolean)result.isPresent());
        Assert.assertTrue((String)"openaireFunding.getExternalDataObject.value", (boolean)value.equals(((ExternalDataObject)result.get()).getValue()));
    }

    @Test
    public void testGetDataObjectWInvalidId() {
        String id = "WRONGID";
        Assert.assertNotNull((String)"openaireFundingDataProvider is not null", (Object)this.openaireFundingDataProvider);
        Optional result = this.openaireFundingDataProvider.getExternalDataObject(id);
        Assert.assertTrue((String)"openaireFunding.getExternalDataObject.notExists:WRONGID", (boolean)result.isEmpty());
    }
}

