/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.script;

import java.sql.SQLException;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.matcher.LambdaMatcher;
import org.dspace.app.matcher.OrcidQueueMatcher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.OrcidQueueBuilder;
import org.dspace.builder.OrcidTokenBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.eperson.EPerson;
import org.dspace.orcid.OrcidHistory;
import org.dspace.orcid.OrcidOperation;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.client.OrcidResponse;
import org.dspace.orcid.exception.OrcidClientException;
import org.dspace.orcid.factory.OrcidServiceFactory;
import org.dspace.orcid.service.OrcidQueueService;
import org.dspace.orcid.service.impl.OrcidHistoryServiceImpl;
import org.dspace.profile.OrcidSynchronizationMode;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jdom2.Document;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class OrcidBulkPushIT
extends AbstractIntegrationTestWithDatabase {
    private Collection profileCollection;
    private Collection publicationCollection;
    private OrcidHistoryServiceImpl orcidHistoryService;
    private OrcidQueueService orcidQueueService;
    private ConfigurationService configurationService;
    private OrcidClient orcidClient;
    private OrcidClient orcidClientMock;

    @Before
    public void setup() {
        this.orcidHistoryService = (OrcidHistoryServiceImpl)OrcidServiceFactory.getInstance().getOrcidHistoryService();
        this.orcidQueueService = OrcidServiceFactory.getInstance().getOrcidQueueService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.context.setCurrentUser(this.admin);
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent community").build();
        this.profileCollection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Profiles").withEntityType("Person").build();
        this.publicationCollection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Publications").withEntityType("Publication").build();
        this.orcidClientMock = (OrcidClient)Mockito.mock(OrcidClient.class);
        this.orcidClient = this.orcidHistoryService.getOrcidClient();
        this.orcidHistoryService.setOrcidClient(this.orcidClientMock);
    }

    @After
    public void after() throws SQLException {
        List records = this.orcidHistoryService.findAll(this.context);
        for (OrcidHistory record : records) {
            this.orcidHistoryService.delete(this.context, record);
        }
        this.orcidHistoryService.setOrcidClient(this.orcidClient);
    }

    @Test
    public void testWithoutOrcidQueueRecords() throws Exception {
        TestDSpaceRunnableHandler handler = this.runBulkSynchronization(false);
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)handler.getInfoMessages().get(0), (Matcher)Matchers.is((Object)"Found 0 queue records to synchronize with ORCID"));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
    }

    @Test
    public void testWithManyOrcidQueueRecords() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson owner = EPersonBuilder.createEPerson(this.context).withEmail("owner@test.it").build();
        this.context.restoreAuthSystemState();
        Item firstProfileItem = this.createProfileItemItem("0000-1111-2222-3333", this.eperson, OrcidSynchronizationMode.BATCH);
        Item secondProfileItem = this.createProfileItemItem("1111-2222-3333-4444", this.admin, OrcidSynchronizationMode.MANUAL);
        Item thirdProfileItem = this.createProfileItemItem("2222-3333-4444-5555", owner, OrcidSynchronizationMode.BATCH);
        Item firstEntity = this.createPublication("First publication");
        Item secondEntity = this.createPublication("Second publication");
        Item thirdEntity = this.createPublication("Third publication");
        Item fourthEntity = this.createPublication("Fourth publication");
        Item fifthEntity = this.createPublication("Fifth publication");
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("12345"));
        Mockito.when((Object)this.orcidClientMock.update((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"98765"))).thenReturn((Object)this.updatedResponse("98765"));
        Mockito.when((Object)this.orcidClientMock.deleteByPutCode((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), (String)ArgumentMatchers.eq((Object)"22222"), (String)ArgumentMatchers.eq((Object)"/work"))).thenReturn((Object)this.deletedResponse());
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"2222-3333-4444-5555"), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("11111"));
        OrcidQueueBuilder.createOrcidQueue(this.context, firstProfileItem, firstEntity);
        OrcidQueueBuilder.createOrcidQueue(this.context, firstProfileItem, secondEntity, "98765");
        OrcidQueueBuilder.createOrcidQueue(this.context, firstProfileItem, "Description", "Publication", "22222");
        OrcidQueueBuilder.createOrcidQueue(this.context, secondProfileItem, thirdEntity);
        OrcidQueueBuilder.createOrcidQueue(this.context, secondProfileItem, fourthEntity);
        OrcidQueueBuilder.createOrcidQueue(this.context, thirdProfileItem, fifthEntity);
        this.context.commit();
        TestDSpaceRunnableHandler handler = this.runBulkSynchronization(false);
        String firstProfileItemId = firstProfileItem.getID().toString();
        String thirdProfileItemId = thirdProfileItem.getID().toString();
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.hasSize((int)9));
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Found 4 queue records to synchronize with ORCID", "Addition of Publication for profile with ID: " + firstProfileItemId, "History record created with status 201. The operation was completed successfully", "Update of Publication for profile with ID: " + firstProfileItemId + " by put code 98765", "History record created with status 200. The operation was completed successfully", "Deletion of Publication for profile with ID: " + firstProfileItemId + " by put code 22222", "History record created with status 204. The operation was completed successfully", "Addition of Publication for profile with ID: " + thirdProfileItemId, "History record created with status 201. The operation was completed successfully"}));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"2222-3333-4444-5555"), ArgumentMatchers.any());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).update((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"98765"));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).deleteByPutCode((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), (String)ArgumentMatchers.eq((Object)"22222"), (String)ArgumentMatchers.eq((Object)"/work"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        List queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(secondProfileItem, thirdEntity, "Publication", OrcidOperation.INSERT, 0)));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(secondProfileItem, fourthEntity, "Publication", OrcidOperation.INSERT, 0)));
        List historyRecords = this.orcidHistoryService.findAll(this.context);
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasSize((int)4));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(firstProfileItem, firstEntity, 201, OrcidOperation.INSERT))));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(firstProfileItem, secondEntity, 200, OrcidOperation.UPDATE))));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(firstProfileItem, 204, OrcidOperation.DELETE))));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(thirdProfileItem, fifthEntity, 201, OrcidOperation.INSERT))));
    }

    @Test
    public void testWithVeryLongTitleQueueRecords() throws Exception {
        Item firstProfileItem = this.createProfileItemItem("0000-1111-2222-3333", this.eperson, OrcidSynchronizationMode.BATCH);
        Item firstEntity = this.createPublication("Publication with a very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very very even extremely long title");
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("12345"));
        Mockito.when((Object)this.orcidClientMock.update((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"98765"))).thenReturn((Object)this.updatedResponse("98765"));
        Mockito.when((Object)this.orcidClientMock.deleteByPutCode((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), (String)ArgumentMatchers.eq((Object)"22222"), (String)ArgumentMatchers.eq((Object)"/work"))).thenReturn((Object)this.deletedResponse());
        OrcidQueueBuilder.createOrcidQueue(this.context, firstProfileItem, firstEntity);
        OrcidQueueBuilder.createOrcidQueue(this.context, firstProfileItem, "Description", "Publication", "22222");
        this.context.commit();
        TestDSpaceRunnableHandler handler = this.runBulkSynchronization(false);
        String firstProfileItemId = firstProfileItem.getID().toString();
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Found 2 queue records to synchronize with ORCID", "Addition of Publication for profile with ID: " + firstProfileItemId, "History record created with status 201. The operation was completed successfully", "Deletion of Publication for profile with ID: " + firstProfileItemId + " by put code 22222", "History record created with status 204. The operation was completed successfully"}));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).deleteByPutCode((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), (String)ArgumentMatchers.eq((Object)"22222"), (String)ArgumentMatchers.eq((Object)"/work"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        List historyRecords = this.orcidHistoryService.findAll(this.context);
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(firstProfileItem, firstEntity, 201, OrcidOperation.INSERT))));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(firstProfileItem, 204, OrcidOperation.DELETE))));
    }

    @Test
    public void testWithOneValidationError() throws Exception {
        Item firstProfileItem = this.createProfileItemItem("0000-1111-2222-3333", this.eperson, OrcidSynchronizationMode.BATCH);
        Item secondProfileItem = this.createProfileItemItem("1111-2222-3333-4444", this.admin, OrcidSynchronizationMode.BATCH);
        Item firstEntity = this.createPublication("First publication");
        Item secondEntity = this.createPublication("");
        Item thirdEntity = this.createPublication("Third publication");
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("12345"));
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"1111-2222-3333-4444"), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("55555"));
        OrcidQueueBuilder.createOrcidQueue(this.context, firstProfileItem, firstEntity);
        OrcidQueueBuilder.createOrcidQueue(this.context, firstProfileItem, secondEntity, "98765");
        OrcidQueueBuilder.createOrcidQueue(this.context, secondProfileItem, thirdEntity);
        this.context.commit();
        TestDSpaceRunnableHandler handler = this.runBulkSynchronization(false);
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.hasSize((int)6));
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Found 3 queue records to synchronize with ORCID", "Addition of Publication for profile with ID: " + firstProfileItem.getID().toString(), "History record created with status 201. The operation was completed successfully", "Update of Publication for profile with ID: " + firstProfileItem.getID().toString() + " by put code 98765", "Addition of Publication for profile with ID: " + secondProfileItem.getID().toString(), "History record created with status 201. The operation was completed successfully"}));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Errors occurs during ORCID object validation. Error codes: title.required"}));
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"1111-2222-3333-4444"), ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        List queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(firstProfileItem, secondEntity, "Publication", OrcidOperation.UPDATE, 1)));
        List historyRecords = this.orcidHistoryService.findAll(this.context);
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(firstProfileItem, firstEntity, 201, OrcidOperation.INSERT))));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(secondProfileItem, thirdEntity, 201, OrcidOperation.INSERT))));
    }

    @Test
    public void testWithUnexpectedErrorForMissingOrcid() throws Exception {
        Item firstProfileItem = this.createProfileItemItem("0000-1111-2222-3333", this.eperson, OrcidSynchronizationMode.BATCH);
        Item secondProfileItem = this.createProfileItemItem("", this.admin, OrcidSynchronizationMode.BATCH);
        Item firstEntity = this.createPublication("First publication");
        Item secondEntity = this.createPublication("Second publication");
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("12345"));
        OrcidQueueBuilder.createOrcidQueue(this.context, secondProfileItem, secondEntity);
        OrcidQueueBuilder.createOrcidQueue(this.context, firstProfileItem, firstEntity);
        this.context.commit();
        TestDSpaceRunnableHandler handler = this.runBulkSynchronization(false);
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.hasSize((int)4));
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Found 2 queue records to synchronize with ORCID", "Addition of Publication for profile with ID: " + secondProfileItem.getID().toString(), "Addition of Publication for profile with ID: " + firstProfileItem.getID().toString(), "History record created with status 201. The operation was completed successfully"}));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"An unexpected error occurs during the synchronization: The related profileItem item (id = " + secondProfileItem.getID() + ") does not have an orcid"}));
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        List queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(secondProfileItem, secondEntity, "Publication", OrcidOperation.INSERT, 1)));
        List historyRecords = this.orcidHistoryService.findAll(this.context);
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(firstProfileItem, firstEntity, 201, OrcidOperation.INSERT))));
    }

    @Test
    public void testWithOrcidClientException() throws Exception {
        Item firstProfileItem = this.createProfileItemItem("0000-1111-2222-3333", this.eperson, OrcidSynchronizationMode.BATCH);
        Item secondProfileItem = this.createProfileItemItem("1111-2222-3333-4444", this.admin, OrcidSynchronizationMode.BATCH);
        Item firstEntity = this.createPublication("First publication");
        Item secondEntity = this.createPublication("Second publication");
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any())).thenThrow(new Throwable[]{new OrcidClientException(400, "Bad request")});
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"1111-2222-3333-4444"), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("55555"));
        OrcidQueueBuilder.createOrcidQueue(this.context, firstProfileItem, firstEntity);
        OrcidQueueBuilder.createOrcidQueue(this.context, secondProfileItem, secondEntity);
        this.context.commit();
        TestDSpaceRunnableHandler handler = this.runBulkSynchronization(false);
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Found 2 queue records to synchronize with ORCID", "Addition of Publication for profile with ID: " + firstProfileItem.getID().toString(), "History record created with status 400. The resource sent to ORCID registry is not valid", "Addition of Publication for profile with ID: " + secondProfileItem.getID().toString(), "History record created with status 201. The operation was completed successfully"}));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"1111-2222-3333-4444"), ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
        List queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(firstProfileItem, firstEntity, "Publication", OrcidOperation.INSERT, 1)));
        List historyRecords = this.orcidHistoryService.findAll(this.context);
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(firstProfileItem, firstEntity, 400, OrcidOperation.INSERT))));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(secondProfileItem, secondEntity, 201, OrcidOperation.INSERT))));
    }

    @Test
    public void testWithTooManyAttempts() throws Exception {
        this.configurationService.setProperty("orcid.bulk-synchronization.max-attempts", (Object)2);
        Item profileItem = this.createProfileItemItem("0000-1111-2222-3333", this.eperson, OrcidSynchronizationMode.BATCH);
        Item entity = this.createPublication("First publication");
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"0000-1111-2222-3333"), ArgumentMatchers.any())).thenThrow(new Throwable[]{new OrcidClientException(400, "Bad request")});
        OrcidQueueBuilder.createOrcidQueue(this.context, profileItem, entity);
        TestDSpaceRunnableHandler handler = this.runBulkSynchronization(false);
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.hasItem((Object)"Found 1 queue records to synchronize with ORCID"));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        List queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profileItem, entity, "Publication", OrcidOperation.INSERT, 1)));
        List historyRecords = this.orcidHistoryService.findAll(this.context);
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasItem(LambdaMatcher.matches(this.history(profileItem, entity, 400, OrcidOperation.INSERT))));
        handler = this.runBulkSynchronization(false);
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.hasItem((Object)"Found 1 queue records to synchronize with ORCID"));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profileItem, entity, "Publication", OrcidOperation.INSERT, 2)));
        historyRecords = this.orcidHistoryService.findAll(this.context);
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.contains((Matcher[])new Matcher[]{LambdaMatcher.matches(this.history(profileItem, entity, 400, OrcidOperation.INSERT)), LambdaMatcher.matches(this.history(profileItem, entity, 400, OrcidOperation.INSERT))}));
        handler = this.runBulkSynchronization(false);
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.hasItem((Object)"Found 0 queue records to synchronize with ORCID"));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profileItem, entity, "Publication", OrcidOperation.INSERT, 2)));
        historyRecords = this.orcidHistoryService.findAll(this.context);
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.contains((Matcher[])new Matcher[]{LambdaMatcher.matches(this.history(profileItem, entity, 400, OrcidOperation.INSERT)), LambdaMatcher.matches(this.history(profileItem, entity, 400, OrcidOperation.INSERT))}));
        handler = this.runBulkSynchronization(true);
        MatcherAssert.assertThat(handler.getInfoMessages(), (Matcher)Matchers.hasItem((Object)"Found 1 queue records to synchronize with ORCID"));
        MatcherAssert.assertThat(handler.getErrorMessages(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(handler.getWarningMessages(), (Matcher)Matchers.empty());
        queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profileItem, entity, "Publication", OrcidOperation.INSERT, 3)));
        historyRecords = this.orcidHistoryService.findAll(this.context);
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)historyRecords, (Matcher)Matchers.contains((Matcher[])new Matcher[]{LambdaMatcher.matches(this.history(profileItem, entity, 400, OrcidOperation.INSERT)), LambdaMatcher.matches(this.history(profileItem, entity, 400, OrcidOperation.INSERT)), LambdaMatcher.matches(this.history(profileItem, entity, 400, OrcidOperation.INSERT))}));
    }

    private Predicate<OrcidHistory> history(Item profileItem, Item entity, int status, OrcidOperation operation) {
        return history -> profileItem.equals((Object)history.getProfileItem()) && entity.equals((Object)history.getEntity()) && history.getStatus().equals(status) && operation == history.getOperation();
    }

    private Predicate<OrcidHistory> history(Item profileItem, int status, OrcidOperation operation) {
        return history -> profileItem.equals((Object)history.getProfileItem()) && history.getStatus().equals(status) && operation == history.getOperation();
    }

    private TestDSpaceRunnableHandler runBulkSynchronization(boolean forceSynchronization) throws Exception {
        Object[] args = new String[]{"orcid-bulk-push"};
        args = forceSynchronization ? (String[])ArrayUtils.add((Object[])args, (Object)"-f") : args;
        TestDSpaceRunnableHandler handler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)handler, (DSpaceKernelImpl)kernelImpl);
        return handler;
    }

    private Item createProfileItemItem(String orcid, EPerson owner, OrcidSynchronizationMode mode) throws Exception {
        Item item = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test user").withOrcidIdentifier(orcid).withOrcidSynchronizationMode(mode).withDspaceObjectOwner(owner.getFullName(), owner.getID().toString()).build();
        OrcidTokenBuilder.create(this.context, owner, "9c913f57-961e-48af-9223-cfad6562c925").withProfileItem(item).build();
        return item;
    }

    private Item createPublication(String title) {
        return ItemBuilder.createItem(this.context, this.publicationCollection).withTitle(title).withType("Controlled Vocabulary for Resource Type Genres::dataset").build();
    }

    private OrcidResponse createdResponse(String putCode) {
        return new OrcidResponse(201, putCode, null);
    }

    private OrcidResponse updatedResponse(String putCode) {
        return new OrcidResponse(200, putCode, null);
    }

    private OrcidResponse deletedResponse() {
        return new OrcidResponse(204, null, null);
    }
}

