/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Community;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.EmbeddedSolrClientFactory;
import org.dspace.statistics.GeoIpService;
import org.dspace.statistics.SolrLoggerServiceImpl;
import org.dspace.statistics.SolrStatisticsCore;
import org.dspace.utils.DSpace;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SolrLoggerServiceImplIT
extends AbstractIntegrationTestWithDatabase {
    private static final ConfigurationService cfg = DSpaceServicesFactory.getInstance().getConfigurationService();
    private static final String NOT_BOT_IP = "192.168.1.1";
    private static final String BOT_IP = "192.168.2.1";
    private static final String NOT_BOT_DNS = "angel.com";
    private static final String BOT_DNS = "demon.com";
    private static final String NOT_BOT_AGENT = "Firefox";
    private static final String BOT_AGENT = "Punchbot";
    private static final String F_AGENT = "userAgent";
    private static final String F_DNS = "dns";
    private static final String F_EPERSON = "epersonid";
    private static final String F_ID = "id";
    private static final String F_IP = "ip";
    private static final String F_IS_BOT = "isBot";
    private static final String F_STATISTICS_TYPE = "statistics_type";
    private static final String F_TIME = "time";
    private static final String F_TYPE = "type";
    private static final String Q_ALL = "*:*";
    private static final String COMMUNITY_NAME = "Top";
    private static Path testAddressesPath;
    private static Path testAgentsPath;

    @BeforeClass
    public static void setUpClass() throws IOException {
        Path spidersPath = Paths.get(cfg.getProperty("dspace.dir"), "config", "spiders");
        testAddressesPath = Files.createTempFile(spidersPath, "test-ips-", ".txt", new FileAttribute[0]);
        BufferedWriter writer = Files.newBufferedWriter(testAddressesPath, StandardCharsets.UTF_8, StandardOpenOption.WRITE);
        writer.append(BOT_IP).append('\n').close();
        testAgentsPath = Files.createTempFile(spidersPath.resolve("agents"), "test-agents-", ".txt", new FileAttribute[0]);
        writer = Files.newBufferedWriter(testAgentsPath, StandardCharsets.UTF_8, StandardOpenOption.WRITE);
        writer.append('^').append(BOT_AGENT).append('\n').close();
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        Files.deleteIfExists(testAddressesPath);
        Files.deleteIfExists(testAgentsPath);
    }

    @Before
    public void setUpTest() {
    }

    @After
    public void tearDownTest() {
    }

    @Test
    public void testMarkRobots() throws SolrServerException, IOException, Exception {
        System.out.println("markRobots");
        EmbeddedSolrClientFactory clientFactory = new EmbeddedSolrClientFactory();
        ContentServiceFactory csf = ContentServiceFactory.getInstance();
        DSpace dspace = new DSpace();
        SolrLoggerServiceImpl instance = new SolrLoggerServiceImpl();
        instance.bitstreamService = csf.getBitstreamService();
        instance.contentServiceFactory = csf;
        instance.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        instance.clientInfoService = CoreServiceFactory.getInstance().getClientInfoService();
        instance.geoIpService = (GeoIpService)dspace.getSingletonService(GeoIpService.class);
        instance.solrStatisticsCore = (SolrStatisticsCore)dspace.getSingletonService(SolrStatisticsCore.class);
        instance.afterPropertiesSet();
        this.context.turnOffAuthorisationSystem();
        Community topCommunity = CommunityBuilder.createCommunity(this.context).withName(COMMUNITY_NAME).build();
        this.context.restoreAuthSystemState();
        SolrClient client = clientFactory.getClient(cfg.getProperty("solr-statistics.server"));
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.setField(F_STATISTICS_TYPE, (Object)SolrLoggerServiceImpl.StatisticsType.VIEW);
        doc.setField(F_TYPE, (Object)String.valueOf(4));
        doc.setField(F_ID, (Object)topCommunity.getID().toString());
        doc.setField(F_EPERSON, (Object)this.eperson.getID().toString());
        doc.setField(F_IP, (Object)NOT_BOT_IP);
        doc.setField(F_DNS, (Object)NOT_BOT_DNS);
        doc.setField(F_AGENT, (Object)NOT_BOT_AGENT);
        doc.setField(F_TIME, (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        client.add(doc);
        doc.setField(F_IP, (Object)BOT_IP);
        doc.setField(F_DNS, (Object)BOT_DNS);
        doc.setField(F_AGENT, (Object)NOT_BOT_AGENT);
        doc.setField(F_TIME, (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        client.add(doc);
        doc.setField(F_IP, (Object)NOT_BOT_IP);
        doc.setField(F_DNS, (Object)NOT_BOT_DNS);
        doc.setField(F_AGENT, (Object)BOT_AGENT);
        doc.setField(F_TIME, (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        client.add(doc);
        doc.setField(F_IP, (Object)BOT_IP);
        doc.setField(F_DNS, (Object)BOT_DNS);
        doc.setField(F_AGENT, (Object)BOT_AGENT);
        doc.setField(F_TIME, (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        client.add(doc);
        client.commit(true, true);
        cfg.setProperty("solr-statistics.query.filter.isBot", (Object)"false");
        instance.markRobots();
        SolrQuery readbackQuery = new SolrQuery().setRows(Integer.valueOf(10)).setQuery(Q_ALL);
        QueryResponse response = client.query((SolrParams)readbackQuery);
        long nDocs = 0L;
        long nGood = 0L;
        for (SolrDocument document : response.getResults()) {
            boolean isBot;
            String ip = (String)document.getFieldValue(F_IP);
            String agent = (String)document.getFieldValue(F_AGENT);
            Object isBotRaw = document.getFieldValue(F_IS_BOT);
            boolean bl = isBot = null == isBotRaw ? false : (Boolean)isBotRaw;
            if (NOT_BOT_IP.equals(ip) && NOT_BOT_AGENT.equals(agent)) {
                Assert.assertFalse((String)String.format("IP %s plus Agent %s is marked as bot --", ip, agent), (boolean)isBot);
            } else {
                Assert.assertTrue((String)String.format("IP %s or Agent %s is not marked as bot --", ip, agent), (boolean)isBot);
            }
            ++nDocs;
            if (isBot) continue;
            ++nGood;
        }
        Assert.assertEquals((String)"Wrong number of documents", (long)4L, (long)nDocs);
        Assert.assertEquals((String)"Wrong number of non-bot views", (long)1L, (long)nGood);
    }

    @Test
    public void testDeleteRobots() throws SolrServerException, IOException, Exception {
        System.out.println("deleteRobots");
        EmbeddedSolrClientFactory clientFactory = new EmbeddedSolrClientFactory();
        ContentServiceFactory csf = ContentServiceFactory.getInstance();
        DSpace dspace = new DSpace();
        SolrLoggerServiceImpl instance = new SolrLoggerServiceImpl();
        instance.bitstreamService = csf.getBitstreamService();
        instance.contentServiceFactory = csf;
        instance.configurationService = cfg;
        instance.clientInfoService = CoreServiceFactory.getInstance().getClientInfoService();
        instance.geoIpService = (GeoIpService)dspace.getSingletonService(GeoIpService.class);
        instance.solrStatisticsCore = (SolrStatisticsCore)dspace.getSingletonService(SolrStatisticsCore.class);
        instance.afterPropertiesSet();
        this.context.turnOffAuthorisationSystem();
        Community topCommunity = CommunityBuilder.createCommunity(this.context).withName(COMMUNITY_NAME).build();
        this.context.restoreAuthSystemState();
        SolrClient client = clientFactory.getClient(cfg.getProperty("solr-statistics.server"));
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.setField(F_STATISTICS_TYPE, (Object)SolrLoggerServiceImpl.StatisticsType.VIEW);
        doc.setField(F_TYPE, (Object)String.valueOf(4));
        doc.setField(F_ID, (Object)topCommunity.getID().toString());
        doc.setField(F_EPERSON, (Object)this.eperson.getID().toString());
        doc.setField(F_IP, (Object)NOT_BOT_IP);
        doc.setField(F_DNS, (Object)NOT_BOT_DNS);
        doc.setField(F_AGENT, (Object)NOT_BOT_AGENT);
        doc.setField(F_TIME, (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        doc.setField(F_IS_BOT, (Object)Boolean.FALSE.toString());
        client.add(doc);
        doc.setField(F_IP, (Object)BOT_IP);
        doc.setField(F_DNS, (Object)BOT_DNS);
        doc.setField(F_AGENT, (Object)NOT_BOT_AGENT);
        doc.setField(F_TIME, (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        doc.setField(F_IS_BOT, (Object)Boolean.TRUE.toString());
        client.add(doc);
        doc.setField(F_IP, (Object)NOT_BOT_IP);
        doc.setField(F_DNS, (Object)NOT_BOT_DNS);
        doc.setField(F_AGENT, (Object)BOT_AGENT);
        doc.setField(F_TIME, (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        doc.setField(F_IS_BOT, (Object)Boolean.TRUE.toString());
        client.add(doc);
        doc.setField(F_IP, (Object)BOT_IP);
        doc.setField(F_DNS, (Object)BOT_DNS);
        doc.setField(F_AGENT, (Object)BOT_AGENT);
        doc.setField(F_TIME, (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        doc.setField(F_IS_BOT, (Object)Boolean.TRUE.toString());
        client.add(doc);
        client.commit(true, true);
        instance.deleteRobots();
        QueryResponse response = instance.query(Q_ALL, null, null, Integer.MAX_VALUE, -1, null, null, null, null, null, true, 0);
        long nDocs = 0L;
        for (SolrDocument document : response.getResults()) {
            ++nDocs;
            Object isBotRaw = document.getFieldValue(F_IS_BOT);
            boolean isBot = null == isBotRaw ? false : (Boolean)isBotRaw;
            Assert.assertEquals((String)"Marked document was not removed --", (Object)false, (Object)isBot);
        }
        Assert.assertEquals((String)"Wrong number of documents remaining --", (long)1L, (long)nDocs);
    }
}

