/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.DSpaceCSVLine;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class DSpaceCSVTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(DSpaceCSVTest.class);

    @Test
    public void testDSpaceCSV() {
        try {
            String[] csv = new String[]{"id,collection,\"dc.title[en]\",dc.contributor.author,dc.description.abstract", "+,56599ad5-c7d2-4ac3-8354-a1f277d5a31f,Easy line,\"Lewis, Stuart\",A nice short abstract", "+,56599ad5-c7d2-4ac3-8354-a1f277d5a31f,Two authors,\"Lewis, Stuart||Bloggs, Joe\",Two people wrote this item", "+,56599ad5-c7d2-4ac3-8354-a1f277d5a31f,Three authors,\"Lewis, Stuart||Bloggs, Joe||Loaf, Meat\",Three people wrote this item", "+,56599ad5-c7d2-4ac3-8354-a1f277d5a31f,\"Two line\n\ntitle\",\"Lewis, Stuart\",abstract", "+,56599ad5-c7d2-4ac3-8354-a1f277d5a31f,\"Empty lines\n\nshould work too (DS-3245).\",\"Lewis, Stuart\",abstract", "+,56599ad5-c7d2-4ac3-8354-a1f277d5a31f,\"\"\"Embedded quotes\"\" here\",\"Lewis, Stuart\",\"Abstract with\ntwo\nnew lines\"", "+,56599ad5-c7d2-4ac3-8354-a1f277d5a31f,\"\"\"Unbalanced embedded\"\" quotes\"\" here\",\"Lewis, Stuart\",\"Abstract with\ntwo\nnew lines\""};
            String filename = "test.csv";
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            for (String csvLine : csv) {
                out.write(csvLine + "\n");
            }
            out.flush();
            out.close();
            out = null;
            DSpaceCSV dcsv = new DSpaceCSV((InputStream)FileUtils.openInputStream((File)new File(filename)), this.context);
            String[] lines = dcsv.getCSVLinesAsStringArray();
            MatcherAssert.assertThat((String)"testDSpaceCSV Good CSV", (Object)lines.length, (Matcher)CoreMatchers.equalTo((Object)8));
            List csvLines = dcsv.getCSVLines();
            DSpaceCSVLine line = (DSpaceCSVLine)csvLines.get(5);
            ArrayList<String> value = new ArrayList<String>();
            value.add("Abstract with\ntwo\nnew lines");
            MatcherAssert.assertThat((String)"testDSpaceCSV New lines", (Object)line.valueToCSV(value, dcsv.valueSeparator), (Matcher)CoreMatchers.equalTo((Object)"\"Abstract with\ntwo\nnew lines\""));
            line = null;
            csv[0] = "id,collection,\"dc.title[en]\",dc.contributor.foobar[en-US],dc.description.abstract";
            filename = "test.csv";
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            for (String csvLine : csv) {
                out.write(csvLine + "\n");
            }
            out.flush();
            out.close();
            out = null;
            try {
                dcsv = new DSpaceCSV((InputStream)FileUtils.openInputStream((File)new File(filename)), this.context);
                lines = dcsv.getCSVLinesAsStringArray();
                Assert.fail((String)"An exception should have been thrown due to bad CSV");
            }
            catch (Exception e) {
                MatcherAssert.assertThat((String)"testDSpaceCSV Bad heading CSV", (Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Unknown metadata element in column 4: dc.contributor.foobar"));
            }
            lines = dcsv.getCSVLinesAsStringArray();
            MatcherAssert.assertThat((String)"testDSpaceCSV Good CSV", (Object)lines.length, (Matcher)CoreMatchers.equalTo((Object)8));
            csv[0] = "id,collection,\"dcdc.title[en]\",dc.contributor[en-US],dc.description.abstract";
            filename = "test.csv";
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            for (String csvLine : csv) {
                out.write(csvLine + "\n");
            }
            out.flush();
            out.close();
            out = null;
            try {
                dcsv = new DSpaceCSV((InputStream)FileUtils.openInputStream((File)new File(filename)), this.context);
                lines = dcsv.getCSVLinesAsStringArray();
                Assert.fail((String)"An exception should have been thrown due to bad CSV");
            }
            catch (Exception e) {
                MatcherAssert.assertThat((String)"testDSpaceCSV Bad heading CSV", (Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Unknown metadata schema in column 3: dcdc.title"));
            }
            File toDelete = new File(filename);
            toDelete.delete();
            toDelete = null;
            dcsv = null;
            lines = null;
        }
        catch (Exception ex) {
            log.error("IO Error while creating test CSV file", (Throwable)ex);
            Assert.fail((String)"IO Error while creating test CSV file");
        }
    }
}

