/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicStatusLine;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.action.LDNActionStatus;
import org.dspace.app.ldn.action.SendLDNMessageAction;
import org.dspace.app.ldn.factory.NotifyServiceFactory;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.NotifyServiceBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SendLDNMessageActionIT
extends AbstractIntegrationTestWithDatabase {
    private org.dspace.content.Collection collection;
    private EPerson submitter;
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private LDNMessageService ldnMessageService = NotifyServiceFactory.getInstance().getLDNMessageService();
    private WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
    private SendLDNMessageAction sendLDNMessageAction;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("ldn.enabled", (Object)"true");
        this.sendLDNMessageAction = new SendLDNMessageAction();
        this.context.turnOffAuthorisationSystem();
        this.submitter = EPersonBuilder.createEPerson(this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection 1").withSubmitterGroup(this.submitter).build();
        this.context.setCurrentUser(this.submitter);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testLDNMessageConsumerRequestReview() throws Exception {
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        StatusLine sl = (StatusLine)Mockito.mock(BasicStatusLine.class);
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)sl);
        Mockito.when((Object)sl.getStatusCode()).thenReturn((Object)202);
        CloseableHttpClient mockedClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        Mockito.when((Object)mockedClient.execute((HttpUriRequest)Mockito.any(HttpPost.class))).thenReturn((Object)response);
        ObjectMapper mapper = new ObjectMapper();
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder(this.context, "service name").withDescription("service description").withUrl("https://www.notify-inbox.info/").withLdnUrl("https://notify-inbox.info/inbox/").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, this.collection).withTitle("Submission Item").withIssueDate("2023-11-20").withCOARNotifyService(notifyService, "request-review").withFulltext("test.txt", "test", InputStream.nullInputStream()).grantLicense().build();
        WorkflowItem workflowItem = this.workflowService.start(this.context, workspaceItem);
        Item item = workflowItem.getItem();
        this.context.dispatchEvents();
        this.context.restoreAuthSystemState();
        LDNMessageEntity ldnMessage = this.ldnMessageService.findAll(this.context).stream().findFirst().orElse(null);
        ldnMessage.getQueueStatus();
        Notification notification = (Notification)mapper.readValue(ldnMessage.getMessage(), Notification.class);
        this.sendLDNMessageAction = new SendLDNMessageAction(mockedClient);
        Assert.assertEquals((Object)this.sendLDNMessageAction.execute(this.context, notification, item), (Object)LDNActionStatus.CONTINUE);
        mockedClient.close();
        response.close();
    }

    @Test
    public void testLDNMessageConsumerRequestReviewGotRedirection() throws Exception {
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        StatusLine sl = (StatusLine)Mockito.mock(BasicStatusLine.class);
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)sl);
        Mockito.when((Object)sl.getStatusCode()).thenReturn((Object)202);
        CloseableHttpClient mockedClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        Mockito.when((Object)mockedClient.execute((HttpUriRequest)Mockito.any(HttpPost.class))).thenReturn((Object)response);
        ObjectMapper mapper = new ObjectMapper();
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder(this.context, "service name").withDescription("service description").withUrl("https://www.notify-inbox.info/").withLdnUrl("https://notify-inbox.info/inbox").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, this.collection).withTitle("Submission Item").withIssueDate("2023-11-20").withCOARNotifyService(notifyService, "request-review").withFulltext("test.txt", "test", InputStream.nullInputStream()).grantLicense().build();
        WorkflowItem workflowItem = this.workflowService.start(this.context, workspaceItem);
        Item item = workflowItem.getItem();
        this.context.dispatchEvents();
        this.context.restoreAuthSystemState();
        LDNMessageEntity ldnMessage = this.ldnMessageService.findAll(this.context).stream().findFirst().orElse(null);
        Notification notification = (Notification)mapper.readValue(ldnMessage.getMessage(), Notification.class);
        this.sendLDNMessageAction = new SendLDNMessageAction(mockedClient);
        Assert.assertEquals((Object)this.sendLDNMessageAction.execute(this.context, notification, item), (Object)LDNActionStatus.CONTINUE);
        mockedClient.close();
        response.close();
    }

    @Test
    public void testLDNMessageConsumerRequestReviewWithInvalidLdnUrl() throws Exception {
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        StatusLine sl = (StatusLine)Mockito.mock(BasicStatusLine.class);
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)sl);
        Mockito.when((Object)sl.getStatusCode()).thenReturn((Object)404);
        CloseableHttpClient mockedClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        Mockito.when((Object)mockedClient.execute((HttpUriRequest)Mockito.any(HttpPost.class))).thenReturn((Object)response);
        ObjectMapper mapper = new ObjectMapper();
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder(this.context, "service name").withDescription("service description").withUrl("https://www.notify-inbox.info/").withLdnUrl("https://notify-inbox.info/invalidLdnUrl/").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, this.collection).withTitle("Submission Item").withIssueDate("2023-11-20").withCOARNotifyService(notifyService, "request-review").withFulltext("test.txt", "test", InputStream.nullInputStream()).grantLicense().build();
        WorkflowItem workflowItem = this.workflowService.start(this.context, workspaceItem);
        Item item = workflowItem.getItem();
        this.context.dispatchEvents();
        this.context.restoreAuthSystemState();
        LDNMessageEntity ldnMessage = this.ldnMessageService.findAll(this.context).stream().findFirst().orElse(null);
        Notification notification = (Notification)mapper.readValue(ldnMessage.getMessage(), Notification.class);
        this.sendLDNMessageAction = new SendLDNMessageAction(mockedClient);
        Assert.assertEquals((Object)this.sendLDNMessageAction.execute(this.context, notification, item), (Object)LDNActionStatus.ABORT);
        mockedClient.close();
        response.close();
    }

    @Override
    @After
    public void destroy() throws Exception {
        List ldnMessageEntities = this.ldnMessageService.findAll(this.context);
        if (CollectionUtils.isNotEmpty((Collection)ldnMessageEntities)) {
            ldnMessageEntities.forEach(ldnMessage -> {
                try {
                    this.ldnMessageService.delete(this.context, ldnMessage);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        super.destroy();
    }
}

