/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.matcher;

import java.util.Date;
import org.dspace.app.matcher.LambdaMatcher;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.util.MultiFormatDateParser;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class ResourcePolicyMatcher
extends TypeSafeMatcher<ResourcePolicy> {
    private final Matcher<Integer> actionId;
    private final Matcher<EPerson> ePerson;
    private final Matcher<Group> group;
    private final Matcher<String> rptype;
    private final Matcher<String> rpName;
    private final Matcher<String> description;
    private final Matcher<Date> startDate;
    private final Matcher<Date> endDate;

    public ResourcePolicyMatcher(Matcher<Integer> actionId, Matcher<EPerson> ePerson, Matcher<Group> group, Matcher<String> rpName, Matcher<String> rptype, Matcher<Date> startDate, Matcher<Date> endDate, Matcher<String> description) {
        this.actionId = actionId;
        this.ePerson = ePerson;
        this.group = group;
        this.rptype = rptype;
        this.rpName = rpName;
        this.description = description;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public void describeTo(Description description) {
        description.appendText("Resource policy with action id ").appendDescriptionOf(this.actionId).appendText(" and EPerson ").appendDescriptionOf(this.ePerson).appendText(" and Group ").appendDescriptionOf(this.group).appendText(" and rpType ").appendDescriptionOf(this.rptype).appendText(" and rpName ").appendDescriptionOf(this.rpName).appendText(" and description ").appendDescriptionOf(this.description).appendText(" and start date ").appendDescriptionOf(this.startDate).appendText(" and end date ").appendDescriptionOf(this.endDate);
    }

    public static ResourcePolicyMatcher matches(int actionId, EPerson ePerson, String rptype) {
        return new ResourcePolicyMatcher((Matcher<Integer>)Matchers.is((Object)actionId), (Matcher<EPerson>)Matchers.is((Object)ePerson), (Matcher<Group>)Matchers.nullValue(Group.class), ResourcePolicyMatcher.any(String.class), (Matcher<String>)Matchers.is((Object)rptype), ResourcePolicyMatcher.any(Date.class), ResourcePolicyMatcher.any(Date.class), ResourcePolicyMatcher.any(String.class));
    }

    public static ResourcePolicyMatcher matches(int actionId, EPerson ePerson, String rpName, String rptype) {
        return new ResourcePolicyMatcher((Matcher<Integer>)Matchers.is((Object)actionId), (Matcher<EPerson>)Matchers.is((Object)ePerson), (Matcher<Group>)Matchers.nullValue(Group.class), (Matcher<String>)Matchers.is((Object)rpName), (Matcher<String>)Matchers.is((Object)rptype), ResourcePolicyMatcher.any(Date.class), ResourcePolicyMatcher.any(Date.class), ResourcePolicyMatcher.any(String.class));
    }

    public static ResourcePolicyMatcher matches(int actionId, Group group, String rptype) {
        return new ResourcePolicyMatcher((Matcher<Integer>)Matchers.is((Object)actionId), (Matcher<EPerson>)Matchers.nullValue(EPerson.class), (Matcher<Group>)Matchers.is((Object)group), ResourcePolicyMatcher.any(String.class), (Matcher<String>)Matchers.is((Object)rptype), ResourcePolicyMatcher.any(Date.class), ResourcePolicyMatcher.any(Date.class), ResourcePolicyMatcher.any(String.class));
    }

    public static ResourcePolicyMatcher matches(int actionId, Group group, String rpName, String rptype) {
        return new ResourcePolicyMatcher((Matcher<Integer>)Matchers.is((Object)actionId), (Matcher<EPerson>)Matchers.nullValue(EPerson.class), (Matcher<Group>)Matchers.is((Object)group), (Matcher<String>)Matchers.is((Object)rpName), (Matcher<String>)Matchers.is((Object)rptype), ResourcePolicyMatcher.any(Date.class), ResourcePolicyMatcher.any(Date.class), ResourcePolicyMatcher.any(String.class));
    }

    public static ResourcePolicyMatcher matches(int actionId, Group group, String rpName, String rptype, String description) {
        return new ResourcePolicyMatcher((Matcher<Integer>)Matchers.is((Object)actionId), (Matcher<EPerson>)Matchers.nullValue(EPerson.class), (Matcher<Group>)Matchers.is((Object)group), (Matcher<String>)Matchers.is((Object)rpName), (Matcher<String>)Matchers.is((Object)rptype), ResourcePolicyMatcher.any(Date.class), ResourcePolicyMatcher.any(Date.class), (Matcher<String>)Matchers.is((Object)description));
    }

    public static ResourcePolicyMatcher matches(int actionId, Group group, String rpName, String rpType, Date startDate, Date endDate, String description) {
        return new ResourcePolicyMatcher((Matcher<Integer>)Matchers.is((Object)actionId), (Matcher<EPerson>)Matchers.nullValue(EPerson.class), (Matcher<Group>)Matchers.is((Object)group), (Matcher<String>)Matchers.is((Object)rpName), (Matcher<String>)Matchers.is((Object)rpType), (Matcher<Date>)Matchers.is((Object)startDate), (Matcher<Date>)Matchers.is((Object)endDate), (Matcher<String>)Matchers.is((Object)description));
    }

    public static ResourcePolicyMatcher matches(int actionId, Group group, String rpName, String rpType, String startDate, String endDate, String description) {
        return ResourcePolicyMatcher.matches(actionId, group, rpName, rpType, startDate != null ? MultiFormatDateParser.parse((String)startDate) : null, endDate != null ? MultiFormatDateParser.parse((String)endDate) : null, description);
    }

    protected boolean matchesSafely(ResourcePolicy resourcePolicy) {
        return this.actionId.matches((Object)resourcePolicy.getAction()) && this.ePerson.matches((Object)resourcePolicy.getEPerson()) && this.group.matches((Object)resourcePolicy.getGroup()) && this.rptype.matches((Object)resourcePolicy.getRpType()) && this.rpName.matches((Object)resourcePolicy.getRpName()) && this.description.matches((Object)resourcePolicy.getRpDescription()) && this.startDate.matches((Object)resourcePolicy.getStartDate()) && this.endDate.matches((Object)resourcePolicy.getEndDate());
    }

    private static <T> Matcher<T> any(Class<T> clazz) {
        return LambdaMatcher.matches(obj -> true, "any value");
    }
}

