/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ReloadableEntity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MediaFilterIT
extends AbstractIntegrationTestWithDatabase {
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected Community topComm1;
    protected Community topComm2;
    protected Community childComm1_1;
    protected Community childComm1_2;
    protected Collection col1_1;
    protected Collection col1_2;
    protected Collection col1_1_1;
    protected Collection col1_1_2;
    protected Collection col1_2_1;
    protected Collection col1_2_2;
    protected Collection col2_1;
    protected Item item1_1_a;
    protected Item item1_1_b;
    protected Item item1_2_a;
    protected Item item1_2_b;
    protected Item item1_1_1_a;
    protected Item item1_1_1_b;
    protected Item item1_1_2_a;
    protected Item item1_1_2_b;
    protected Item item1_2_1_a;
    protected Item item1_2_1_b;
    protected Item item1_2_2_a;
    protected Item item1_2_2_b;
    protected Item item2_1_a;
    protected Item item2_1_b;

    @Before
    public void setup() throws IOException, SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.topComm1 = CommunityBuilder.createCommunity(this.context).withName("Parent Community1").build();
        this.topComm2 = CommunityBuilder.createCommunity(this.context).withName("Parent Community2").build();
        this.childComm1_1 = CommunityBuilder.createCommunity(this.context).withName("Child Community1_1").addParentCommunity(this.context, this.topComm1).build();
        this.childComm1_2 = CommunityBuilder.createCommunity(this.context).withName("Child Community1_2").addParentCommunity(this.context, this.topComm1).build();
        this.col1_1 = CollectionBuilder.createCollection(this.context, this.topComm1).withName("Collection 1_1").build();
        this.col1_2 = CollectionBuilder.createCollection(this.context, this.topComm1).withName("Collection 1_2").build();
        this.col1_1_1 = CollectionBuilder.createCollection(this.context, this.childComm1_1).withName("Collection 1_1_1").build();
        this.col1_1_2 = CollectionBuilder.createCollection(this.context, this.childComm1_1).withName("Collection 1_1_2").build();
        this.col1_2_1 = CollectionBuilder.createCollection(this.context, this.childComm1_2).withName("Collection 1_1_1").build();
        this.col1_2_2 = CollectionBuilder.createCollection(this.context, this.childComm1_2).withName("Collection 1_2").build();
        this.col2_1 = CollectionBuilder.createCollection(this.context, this.topComm2).withName("Collection 2_1").build();
        this.item1_1_a = ItemBuilder.createItem(this.context, this.col1_1).withTitle("Item 1_1_a").withIssueDate("2017-10-17").build();
        this.item1_1_b = ItemBuilder.createItem(this.context, this.col1_1).withTitle("Item 1_1_b").withIssueDate("2017-10-17").build();
        this.item1_1_1_a = ItemBuilder.createItem(this.context, this.col1_1_1).withTitle("Item 1_1_1_a").withIssueDate("2017-10-17").build();
        this.item1_1_1_b = ItemBuilder.createItem(this.context, this.col1_1_1).withTitle("Item 1_1_1_b").withIssueDate("2017-10-17").build();
        this.item1_1_2_a = ItemBuilder.createItem(this.context, this.col1_1_2).withTitle("Item 1_1_2_a").withIssueDate("2017-10-17").build();
        this.item1_1_2_b = ItemBuilder.createItem(this.context, this.col1_1_2).withTitle("Item 1_1_2_b").withIssueDate("2017-10-17").build();
        this.item1_2_a = ItemBuilder.createItem(this.context, this.col1_2).withTitle("Item 1_2_a").withIssueDate("2017-10-17").build();
        this.item1_2_b = ItemBuilder.createItem(this.context, this.col1_2).withTitle("Item 1_2_b").withIssueDate("2017-10-17").build();
        this.item1_2_1_a = ItemBuilder.createItem(this.context, this.col1_2_1).withTitle("Item 1_2_1_a").withIssueDate("2017-10-17").build();
        this.item1_2_1_b = ItemBuilder.createItem(this.context, this.col1_2_1).withTitle("Item 1_2_1_b").withIssueDate("2017-10-17").build();
        this.item1_2_2_a = ItemBuilder.createItem(this.context, this.col1_2_2).withTitle("Item 1_2_2_a").withIssueDate("2017-10-17").build();
        this.item1_2_2_b = ItemBuilder.createItem(this.context, this.col1_2_2).withTitle("Item 1_2_2_b").withIssueDate("2017-10-17").build();
        this.item2_1_a = ItemBuilder.createItem(this.context, this.col2_1).withTitle("Item 2_1_a").withIssueDate("2017-10-17").build();
        this.item2_1_b = ItemBuilder.createItem(this.context, this.col2_1).withTitle("Item 2_1_b").withIssueDate("2017-10-17").build();
        this.addBitstream(this.item1_1_a, "test.csv");
        this.addBitstream(this.item1_1_b, "test.txt");
        this.addBitstream(this.item1_2_a, "test.csv");
        this.addBitstream(this.item1_2_b, "test.txt");
        this.addBitstream(this.item1_1_1_a, "test.csv");
        this.addBitstream(this.item1_1_1_b, "test.txt");
        this.addBitstream(this.item1_1_2_a, "test.csv");
        this.addBitstream(this.item1_1_2_b, "test.txt");
        this.addBitstream(this.item1_2_1_a, "test.csv");
        this.addBitstream(this.item1_2_1_b, "test.txt");
        this.addBitstream(this.item1_2_2_a, "test.csv");
        this.addBitstream(this.item1_2_2_b, "test.txt");
        this.addBitstream(this.item2_1_a, "test.csv");
        this.addBitstream(this.item2_1_b, "test.txt");
        this.context.restoreAuthSystemState();
    }

    private void addBitstream(Item item, String filename) throws SQLException, AuthorizeException, IOException {
        BitstreamBuilder.createBitstream(this.context, item, this.getClass().getResourceAsStream(filename)).withName(filename).guessFormat().build();
    }

    @Test
    public void mediaFilterScriptAllItemsTest() throws Exception {
        this.performMediaFilterScript(null);
        Iterator items = this.itemService.findAll(this.context);
        while (items.hasNext()) {
            Item item = (Item)items.next();
            this.checkItemHasBeenProcessed(item);
        }
    }

    @Test
    public void mediaFilterScriptIdentifiersTest() throws Exception {
        this.performMediaFilterScript((DSpaceObject)this.item1_1_a);
        this.checkItemHasBeenProcessed(this.item1_1_a);
        this.checkItemHasBeenNotProcessed(this.item1_1_b);
        this.performMediaFilterScript((DSpaceObject)this.col1_1_1);
        this.checkItemHasBeenProcessed(this.item1_1_1_a);
        this.checkItemHasBeenProcessed(this.item1_1_1_b);
        this.checkItemHasBeenNotProcessed(this.item1_1_2_a);
        this.checkItemHasBeenNotProcessed(this.item1_1_2_b);
        this.performMediaFilterScript((DSpaceObject)this.topComm2);
        this.checkItemHasBeenProcessed(this.item2_1_a);
        this.checkItemHasBeenProcessed(this.item2_1_b);
        this.checkItemHasBeenNotProcessed(this.item1_1_b);
        this.checkItemHasBeenNotProcessed(this.item1_2_a);
        this.checkItemHasBeenNotProcessed(this.item1_2_b);
        this.checkItemHasBeenNotProcessed(this.item1_1_2_a);
        this.checkItemHasBeenNotProcessed(this.item1_1_2_b);
        this.checkItemHasBeenNotProcessed(this.item1_2_1_a);
        this.checkItemHasBeenNotProcessed(this.item1_2_1_b);
        this.checkItemHasBeenNotProcessed(this.item1_2_2_a);
        this.checkItemHasBeenNotProcessed(this.item1_2_2_b);
        this.performMediaFilterScript((DSpaceObject)this.topComm1);
        this.checkItemHasBeenProcessed(this.item1_1_a);
        this.checkItemHasBeenProcessed(this.item1_1_1_a);
        this.checkItemHasBeenProcessed(this.item1_1_1_b);
        this.checkItemHasBeenProcessed(this.item1_1_b);
        this.checkItemHasBeenProcessed(this.item1_2_a);
        this.checkItemHasBeenProcessed(this.item1_2_b);
        this.checkItemHasBeenProcessed(this.item1_1_2_a);
        this.checkItemHasBeenProcessed(this.item1_1_2_b);
        this.checkItemHasBeenProcessed(this.item1_2_1_a);
        this.checkItemHasBeenProcessed(this.item1_2_1_b);
        this.checkItemHasBeenProcessed(this.item1_2_2_a);
        this.checkItemHasBeenProcessed(this.item1_2_2_b);
    }

    private void checkItemHasBeenNotProcessed(Item item) throws IOException, SQLException, AuthorizeException {
        List textBundles = item.getBundles("TEXT");
        Assert.assertTrue((String)("The item " + item.getName() + " should NOT have the TEXT bundle"), (textBundles.size() == 0 ? 1 : 0) != 0);
    }

    private void checkItemHasBeenProcessed(Item item) throws IOException, SQLException, AuthorizeException {
        String expectedFileName = StringUtils.endsWith((CharSequence)item.getName(), (CharSequence)"_a") ? "test.csv.txt" : "test.txt.txt";
        String expectedContent = StringUtils.endsWith((CharSequence)item.getName(), (CharSequence)"_a") ? "data3,3" : "quick brown fox";
        List textBundles = item.getBundles("TEXT");
        Assert.assertTrue((String)("The item " + item.getName() + " has NOT the TEXT bundle"), (textBundles.size() == 1 ? 1 : 0) != 0);
        List bitstreams = ((Bundle)textBundles.get(0)).getBitstreams();
        Assert.assertTrue((String)("The item " + item.getName() + " has NOT exactly 1 bitstream in the TEXT bundle"), (bitstreams.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("The text bistream in the " + item.getName() + " is NOT named properly [" + expectedFileName + "]"), (boolean)StringUtils.equals((CharSequence)((Bitstream)bitstreams.get(0)).getName(), (CharSequence)expectedFileName));
        Assert.assertTrue((String)("The text bistream in the " + item.getName() + " doesn't contain the proper content [" + expectedContent + "]"), (boolean)StringUtils.contains((CharSequence)this.getContent((Bitstream)bitstreams.get(0)), (CharSequence)expectedContent));
    }

    private CharSequence getContent(Bitstream bitstream) throws IOException, SQLException, AuthorizeException {
        try (InputStream input = this.bitstreamService.retrieve(this.context, bitstream);){
            String string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return string;
        }
    }

    private void performMediaFilterScript(DSpaceObject dso) throws Exception {
        if (dso != null) {
            this.runDSpaceScript("filter-media", "-i", dso.getHandle());
        } else {
            this.runDSpaceScript("filter-media");
        }
        this.item1_1_a = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_1_a);
        this.item1_1_b = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_1_b);
        this.item1_2_a = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_2_a);
        this.item1_2_b = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_2_b);
        this.item1_1_1_a = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_1_1_a);
        this.item1_1_1_b = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_1_1_b);
        this.item1_1_2_a = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_1_2_a);
        this.item1_1_2_b = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_1_2_b);
        this.item1_2_1_a = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_2_1_a);
        this.item1_2_1_b = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_2_1_b);
        this.item1_2_2_a = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_2_2_a);
        this.item1_2_2_b = (Item)this.context.reloadEntity((ReloadableEntity)this.item1_2_2_b);
        this.item2_1_a = (Item)this.context.reloadEntity((ReloadableEntity)this.item2_1_a);
        this.item2_1_b = (Item)this.context.reloadEntity((ReloadableEntity)this.item2_1_b);
    }
}

