/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.util.Date;
import org.dspace.builder.AbstractBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.core.Context;
import org.dspace.qaevent.service.QAEventService;

public class QAEventBuilder
extends AbstractBuilder<QAEvent, QAEventService> {
    private Item item;
    private QAEvent target;
    private String source = "openaire";
    private String title;
    private String topic;
    private String message;
    private String relatedItem;
    private double trust = 0.5;
    private Date lastUpdate = new Date();

    protected QAEventBuilder(Context context) {
        super(context);
    }

    public static QAEventBuilder createTarget(Context context, Collection col, String name) {
        QAEventBuilder builder = new QAEventBuilder(context);
        return builder.create(context, col, name);
    }

    public static QAEventBuilder createTarget(Context context, Item item) {
        QAEventBuilder builder = new QAEventBuilder(context);
        return builder.create(context, item);
    }

    private QAEventBuilder create(Context context, Collection col, String name) {
        this.context = context;
        try {
            ItemBuilder itemBuilder = ItemBuilder.createItem(context, col).withTitle(name);
            this.item = itemBuilder.build();
            this.title = name;
            context.dispatchEvents();
            indexingService.commit();
        }
        catch (Exception e) {
            return (QAEventBuilder)this.handleException(e);
        }
        return this;
    }

    private QAEventBuilder create(Context context, Item item) {
        this.context = context;
        this.item = item;
        return this;
    }

    public QAEventBuilder withTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public QAEventBuilder withSource(String source) {
        this.source = source;
        return this;
    }

    public QAEventBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public QAEventBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    public QAEventBuilder withTrust(double trust) {
        this.trust = trust;
        return this;
    }

    public QAEventBuilder withLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    public QAEventBuilder withRelatedItem(String relatedItem) {
        this.relatedItem = relatedItem;
        return this;
    }

    @Override
    public QAEvent build() {
        this.target = new QAEvent(this.source, "oai:www.dspace.org:" + this.item.getHandle(), this.item.getID().toString(), this.title, this.topic, this.trust, this.message, this.lastUpdate);
        this.target.setRelated(this.relatedItem);
        try {
            qaEventService.store(this.context, this.target);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.target;
    }

    @Override
    public void cleanup() throws Exception {
        qaEventService.deleteEventByEventId(this.target.getEventId());
    }

    @Override
    protected QAEventService getService() {
        return qaEventService;
    }

    @Override
    public void delete(Context c, QAEvent dso) throws Exception {
        qaEventService.deleteEventByEventId(this.target.getEventId());
    }
}

