/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.function.FailableRunnable;
import org.apache.commons.lang3.function.FailableSupplier;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.builder.VersionBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipMetadataValue;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.content.virtual.Collected;
import org.dspace.content.virtual.VirtualMetadataConfiguration;
import org.dspace.content.virtual.VirtualMetadataPopulator;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.MockSolrSearchCore;
import org.dspace.kernel.ServiceManager;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.util.RelationshipVersioningTestUtils;
import org.dspace.versioning.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class VersioningWithRelationshipsIT
extends AbstractIntegrationTestWithDatabase {
    private final RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    private final WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    private final InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    private final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final MockSolrSearchCore solrSearchCore = (MockSolrSearchCore)((Object)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(null, MockSolrSearchCore.class));
    protected Community community;
    protected Collection collection;
    protected EntityType publicationEntityType;
    protected EntityType personEntityType;
    protected EntityType projectEntityType;
    protected EntityType orgUnitEntityType;
    protected EntityType journalIssueEntityType;
    protected EntityType journalVolumeEntityType;
    protected RelationshipType isAuthorOfPublication;
    protected RelationshipType isProjectOfPublication;
    protected RelationshipType isOrgUnitOfPublication;
    protected RelationshipType isMemberOfProject;
    protected RelationshipType isMemberOfOrgUnit;
    protected RelationshipType isIssueOfJournalVolume;
    protected RelationshipType isProjectOfPerson;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.community).withName("collection").build();
        this.publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        this.personEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        this.projectEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Project").build();
        this.orgUnitEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "OrgUnit").build();
        this.journalIssueEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "JournalIssue").build();
        this.journalVolumeEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "JournalVolume").build();
        this.isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, this.publicationEntityType, this.personEntityType, "isAuthorOfPublication", "isPublicationOfAuthor", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
        this.isProjectOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, this.publicationEntityType, this.projectEntityType, "isProjectOfPublication", "isPublicationOfProject", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
        this.isOrgUnitOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, this.publicationEntityType, this.orgUnitEntityType, "isOrgUnitOfPublication", "isPublicationOfOrgUnit", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
        this.isMemberOfProject = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, this.projectEntityType, this.personEntityType, "isMemberOfProject", "isProjectOfMember", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
        this.isMemberOfOrgUnit = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, this.orgUnitEntityType, this.personEntityType, "isMemberOfOrgUnit", "isOrgUnitOfMember", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
        this.isIssueOfJournalVolume = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, this.journalVolumeEntityType, this.journalIssueEntityType, "isIssueOfJournalVolume", "isJournalVolumeOfIssue", null, null, 1, 1).withCopyToLeft(false).withCopyToRight(false).build();
        this.isProjectOfPerson = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, this.personEntityType, this.projectEntityType, "isProjectOfPerson", "isPersonOfProject", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
    }

    protected Relationship getRelationship(Item leftItem, RelationshipType relationshipType, Item rightItem) throws Exception {
        List rels = this.relationshipService.findByRelationshipType(this.context, relationshipType).stream().filter(rel -> leftItem.getID().equals(rel.getLeftItem().getID())).filter(rel -> rightItem.getID().equals(rel.getRightItem().getID())).collect(Collectors.toList());
        if (rels.size() == 0) {
            return null;
        }
        if (rels.size() == 1) {
            return (Relationship)rels.get(0);
        }
        throw new IllegalStateException();
    }

    @Test
    public void test_createNewVersionOfItemOnLeftSideOfRelationships() throws Exception {
        Item person1 = ItemBuilder.createItem(this.context, this.collection).withTitle("person 1").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).build();
        Item project1 = ItemBuilder.createItem(this.context, this.collection).withTitle("project 1").withMetadata("dspace", "entity", "type", this.projectEntityType.getLabel()).build();
        Item orgUnit1 = ItemBuilder.createItem(this.context, this.collection).withTitle("org unit 1").withMetadata("dspace", "entity", "type", this.orgUnitEntityType.getLabel()).build();
        Item originalPublication = ItemBuilder.createItem(this.context, this.collection).withTitle("original publication").withMetadata("dspace", "entity", "type", this.publicationEntityType.getLabel()).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, person1, this.isAuthorOfPublication).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, project1, this.isProjectOfPublication).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, orgUnit1, this.isOrgUnitOfPublication).build();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        Version newVersion = VersionBuilder.createVersion(this.context, originalPublication, "test").build();
        Item newPublication = newVersion.getItem();
        Assert.assertNotSame((Object)originalPublication, (Object)newPublication);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        WorkspaceItem newPublicationWSI = this.workspaceItemService.findByItem(this.context, newPublication);
        this.installItemService.installItem(this.context, (InProgressSubmission)newPublicationWSI);
        this.context.dispatchEvents();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        List relationships = this.relationshipService.findAll(this.context);
        for (Relationship relationship : relationships) {
            this.relationshipService.delete(this.context, (Object)relationship);
        }
    }

    @Test
    public void test_createNewVersionOfItemAndModifyRelationships() throws Exception {
        Item person1 = ItemBuilder.createItem(this.context, this.collection).withTitle("person 1").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).build();
        Item project1 = ItemBuilder.createItem(this.context, this.collection).withTitle("project 1").withMetadata("dspace", "entity", "type", this.projectEntityType.getLabel()).build();
        Item orgUnit1 = ItemBuilder.createItem(this.context, this.collection).withTitle("org unit 1").withMetadata("dspace", "entity", "type", this.orgUnitEntityType.getLabel()).build();
        Item originalPublication = ItemBuilder.createItem(this.context, this.collection).withTitle("original publication").withMetadata("dspace", "entity", "type", this.publicationEntityType.getLabel()).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, person1, this.isAuthorOfPublication).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, project1, this.isProjectOfPublication).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, orgUnit1, this.isOrgUnitOfPublication).build();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        Version newVersion = VersionBuilder.createVersion(this.context, originalPublication, "test").build();
        Item newPublication = newVersion.getItem();
        Assert.assertNotSame((Object)originalPublication, (Object)newPublication);
        Item person2 = ItemBuilder.createItem(this.context, this.collection).withTitle("person 2").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).build();
        Item orgUnit2 = ItemBuilder.createItem(this.context, this.collection).withTitle("org unit 2").withMetadata("dspace", "entity", "type", this.orgUnitEntityType.getLabel()).build();
        List newProjectRels = this.relationshipService.findByItemAndRelationshipType(this.context, newPublication, this.isProjectOfPublication);
        Assert.assertEquals((long)1L, (long)newProjectRels.size());
        this.relationshipService.delete(this.context, (Object)((Relationship)newProjectRels.get(0)));
        List newOrgUnitRels = this.relationshipService.findByItemAndRelationshipType(this.context, newPublication, this.isOrgUnitOfPublication);
        Assert.assertEquals((long)1L, (long)newOrgUnitRels.size());
        this.relationshipService.delete(this.context, (Object)((Relationship)newOrgUnitRels.get(0)));
        RelationshipBuilder.createRelationshipBuilder(this.context, newPublication, person2, this.isAuthorOfPublication).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, newPublication, orgUnit2, this.isOrgUnitOfPublication).build();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person2, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person2, Relationship.LatestVersionStatus.BOTH, 1, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit2, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit2, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person2, Relationship.LatestVersionStatus.BOTH, 1, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit2, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person2, Relationship.LatestVersionStatus.BOTH, 1, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit2, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person2, Relationship.LatestVersionStatus.BOTH, 1, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit2, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        WorkspaceItem newPublicationWSI = this.workspaceItemService.findByItem(this.context, newPublication);
        this.installItemService.installItem(this.context, (InProgressSubmission)newPublicationWSI);
        this.context.dispatchEvents();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person2, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person2, Relationship.LatestVersionStatus.BOTH, 1, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit2, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit2, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person2, Relationship.LatestVersionStatus.BOTH, 1, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit2, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, person2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person2, Relationship.LatestVersionStatus.BOTH, 1, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(originalPublication, this.isOrgUnitOfPublication, orgUnit1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit2, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isAuthorOfPublication, person2, Relationship.LatestVersionStatus.BOTH, 1, 0), RelationshipVersioningTestUtils.isRel(newPublication, this.isOrgUnitOfPublication, orgUnit2, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        List relationships = this.relationshipService.findAll(this.context);
        for (Relationship relationship : relationships) {
            this.relationshipService.delete(this.context, (Object)relationship);
        }
    }

    @Test
    public void test_createNewVersionOfItemOnRightSideOfRelationships() throws Exception {
        Item publication1 = ItemBuilder.createItem(this.context, this.collection).withTitle("publication 1").withMetadata("dspace", "entity", "type", this.publicationEntityType.getLabel()).build();
        Item project1 = ItemBuilder.createItem(this.context, this.collection).withTitle("project 1").withMetadata("dspace", "entity", "type", this.projectEntityType.getLabel()).build();
        Item orgUnit1 = ItemBuilder.createItem(this.context, this.collection).withTitle("org unit 1").withMetadata("dspace", "entity", "type", this.orgUnitEntityType.getLabel()).build();
        Item originalPerson = ItemBuilder.createItem(this.context, this.collection).withTitle("original person").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, publication1, originalPerson, this.isAuthorOfPublication).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, project1, originalPerson, this.isMemberOfProject).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, orgUnit1, originalPerson, this.isMemberOfOrgUnit).build();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPerson, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        Version newVersion = VersionBuilder.createVersion(this.context, originalPerson, "test").build();
        Item newPerson = newVersion.getItem();
        Assert.assertNotSame((Object)originalPerson, (Object)newPerson);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPerson, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPerson, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, newPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, newPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, newPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPerson, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, newPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, newPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, originalPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, newPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPerson, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, newPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, newPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, newPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0))));
        WorkspaceItem newPersonWSI = this.workspaceItemService.findByItem(this.context, newPerson);
        this.installItemService.installItem(this.context, (InProgressSubmission)newPersonWSI);
        this.context.dispatchEvents();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPerson, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, originalPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, originalPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, originalPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPerson, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPerson, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, originalPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, originalPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, originalPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, originalPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, project1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, originalPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, orgUnit1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, originalPerson, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPerson, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1, this.isAuthorOfPublication, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(project1, this.isMemberOfProject, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(orgUnit1, this.isMemberOfOrgUnit, newPerson, Relationship.LatestVersionStatus.BOTH, 0, 0))));
        List relationships = this.relationshipService.findAll(this.context);
        for (Relationship relationship : relationships) {
            this.relationshipService.delete(this.context, (Object)relationship);
        }
    }

    @Test
    public void test_createNewVersionOfItemAndVerifyMetadataOrder() throws Exception {
        Item originalPublication = ItemBuilder.createItem(this.context, this.collection).withTitle("original publication").withMetadata("dspace", "entity", "type", this.publicationEntityType.getLabel()).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)originalPublication, "dc", "contributor", "author", null, "author 1 (plain)");
        Item author2 = ItemBuilder.createItem(this.context, this.collection).withTitle("author 2 (item)").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).withPersonIdentifierFirstName("2 (item)").withPersonIdentifierLastName("author").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, author2, this.isAuthorOfPublication).build();
        Item author3 = ItemBuilder.createItem(this.context, this.collection).withTitle("author 3 (item)").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).withPersonIdentifierFirstName("3 (item)").withPersonIdentifierLastName("author").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, author3, this.isAuthorOfPublication).build();
        Item author4 = ItemBuilder.createItem(this.context, this.collection).withTitle("author 4 (item)").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).withPersonIdentifierFirstName("4 (item)").withPersonIdentifierLastName("author").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, author4, this.isAuthorOfPublication).build();
        Item author5 = ItemBuilder.createItem(this.context, this.collection).withTitle("author 5 (item)").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).withPersonIdentifierFirstName("5 (item)").withPersonIdentifierLastName("author").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, author5, this.isAuthorOfPublication).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)originalPublication, "dc", "contributor", "author", null, "author 6 (plain)");
        Item author7 = ItemBuilder.createItem(this.context, this.collection).withTitle("author 7 (item)").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).withPersonIdentifierFirstName("7 (item)").withPersonIdentifierLastName("author").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, author7, this.isAuthorOfPublication).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)originalPublication, "dc", "contributor", "author", null, "author 8 (plain)");
        Item author9 = ItemBuilder.createItem(this.context, this.collection).withTitle("author 9 (item)").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).withPersonIdentifierFirstName("9 (item)").withPersonIdentifierLastName("author").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, author9, this.isAuthorOfPublication).build();
        List oldMdvs = this.itemService.getMetadata((DSpaceObject)originalPublication, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)9L, (long)oldMdvs.size());
        Assert.assertFalse((boolean)(oldMdvs.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author 1 (plain)", (Object)((MetadataValue)oldMdvs.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)oldMdvs.get(0)).getPlace());
        Assert.assertTrue((boolean)(oldMdvs.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 2 (item)", (Object)((MetadataValue)oldMdvs.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)oldMdvs.get(1)).getPlace());
        Assert.assertTrue((boolean)(oldMdvs.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 3 (item)", (Object)((MetadataValue)oldMdvs.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)oldMdvs.get(2)).getPlace());
        Assert.assertTrue((boolean)(oldMdvs.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 4 (item)", (Object)((MetadataValue)oldMdvs.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)oldMdvs.get(3)).getPlace());
        Assert.assertTrue((boolean)(oldMdvs.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 5 (item)", (Object)((MetadataValue)oldMdvs.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)oldMdvs.get(4)).getPlace());
        Assert.assertFalse((boolean)(oldMdvs.get(5) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author 6 (plain)", (Object)((MetadataValue)oldMdvs.get(5)).getValue());
        Assert.assertEquals((long)5L, (long)((MetadataValue)oldMdvs.get(5)).getPlace());
        Assert.assertTrue((boolean)(oldMdvs.get(6) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 7 (item)", (Object)((MetadataValue)oldMdvs.get(6)).getValue());
        Assert.assertEquals((long)6L, (long)((MetadataValue)oldMdvs.get(6)).getPlace());
        Assert.assertFalse((boolean)(oldMdvs.get(7) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author 8 (plain)", (Object)((MetadataValue)oldMdvs.get(7)).getValue());
        Assert.assertEquals((long)7L, (long)((MetadataValue)oldMdvs.get(7)).getPlace());
        Assert.assertTrue((boolean)(oldMdvs.get(8) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 9 (item)", (Object)((MetadataValue)oldMdvs.get(8)).getValue());
        Assert.assertEquals((long)8L, (long)((MetadataValue)oldMdvs.get(8)).getPlace());
        List oldRelationships = this.relationshipService.findByItem(this.context, originalPublication);
        Assert.assertEquals((long)6L, (long)oldRelationships.size());
        Assert.assertEquals((Object)originalPublication, (Object)((Relationship)oldRelationships.get(0)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)oldRelationships.get(0)).getRelationshipType());
        Assert.assertEquals((Object)author2, (Object)((Relationship)oldRelationships.get(0)).getRightItem());
        Assert.assertEquals((long)1L, (long)((Relationship)oldRelationships.get(0)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)oldRelationships.get(0)).getRightPlace());
        Assert.assertEquals((Object)originalPublication, (Object)((Relationship)oldRelationships.get(1)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)oldRelationships.get(1)).getRelationshipType());
        Assert.assertEquals((Object)author3, (Object)((Relationship)oldRelationships.get(1)).getRightItem());
        Assert.assertEquals((long)2L, (long)((Relationship)oldRelationships.get(1)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)oldRelationships.get(1)).getRightPlace());
        Assert.assertEquals((Object)originalPublication, (Object)((Relationship)oldRelationships.get(2)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)oldRelationships.get(2)).getRelationshipType());
        Assert.assertEquals((Object)author4, (Object)((Relationship)oldRelationships.get(2)).getRightItem());
        Assert.assertEquals((long)3L, (long)((Relationship)oldRelationships.get(2)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)oldRelationships.get(2)).getRightPlace());
        Assert.assertEquals((Object)originalPublication, (Object)((Relationship)oldRelationships.get(3)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)oldRelationships.get(3)).getRelationshipType());
        Assert.assertEquals((Object)author5, (Object)((Relationship)oldRelationships.get(3)).getRightItem());
        Assert.assertEquals((long)4L, (long)((Relationship)oldRelationships.get(3)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)oldRelationships.get(3)).getRightPlace());
        Assert.assertEquals((Object)originalPublication, (Object)((Relationship)oldRelationships.get(4)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)oldRelationships.get(4)).getRelationshipType());
        Assert.assertEquals((Object)author7, (Object)((Relationship)oldRelationships.get(4)).getRightItem());
        Assert.assertEquals((long)6L, (long)((Relationship)oldRelationships.get(4)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)oldRelationships.get(4)).getRightPlace());
        Assert.assertEquals((Object)originalPublication, (Object)((Relationship)oldRelationships.get(5)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)oldRelationships.get(5)).getRelationshipType());
        Assert.assertEquals((Object)author9, (Object)((Relationship)oldRelationships.get(5)).getRightItem());
        Assert.assertEquals((long)8L, (long)((Relationship)oldRelationships.get(5)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)oldRelationships.get(5)).getRightPlace());
        Version newVersion = VersionBuilder.createVersion(this.context, originalPublication, "test").build();
        Item newPublication = newVersion.getItem();
        Assert.assertNotSame((Object)originalPublication, (Object)newPublication);
        List newMdvs = this.itemService.getMetadata((DSpaceObject)newPublication, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)9L, (long)newMdvs.size());
        Assert.assertFalse((boolean)(newMdvs.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author 1 (plain)", (Object)((MetadataValue)newMdvs.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)newMdvs.get(0)).getPlace());
        Assert.assertTrue((boolean)(newMdvs.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 2 (item)", (Object)((MetadataValue)newMdvs.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)newMdvs.get(1)).getPlace());
        Assert.assertTrue((boolean)(newMdvs.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 3 (item)", (Object)((MetadataValue)newMdvs.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)newMdvs.get(2)).getPlace());
        Assert.assertTrue((boolean)(newMdvs.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 4 (item)", (Object)((MetadataValue)newMdvs.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)newMdvs.get(3)).getPlace());
        Assert.assertTrue((boolean)(newMdvs.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 5 (item)", (Object)((MetadataValue)newMdvs.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)newMdvs.get(4)).getPlace());
        Assert.assertFalse((boolean)(newMdvs.get(5) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author 6 (plain)", (Object)((MetadataValue)newMdvs.get(5)).getValue());
        Assert.assertEquals((long)5L, (long)((MetadataValue)newMdvs.get(5)).getPlace());
        Assert.assertTrue((boolean)(newMdvs.get(6) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 7 (item)", (Object)((MetadataValue)newMdvs.get(6)).getValue());
        Assert.assertEquals((long)6L, (long)((MetadataValue)newMdvs.get(6)).getPlace());
        Assert.assertFalse((boolean)(newMdvs.get(7) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author 8 (plain)", (Object)((MetadataValue)newMdvs.get(7)).getValue());
        Assert.assertEquals((long)7L, (long)((MetadataValue)newMdvs.get(7)).getPlace());
        Assert.assertTrue((boolean)(newMdvs.get(8) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"author, 9 (item)", (Object)((MetadataValue)newMdvs.get(8)).getValue());
        Assert.assertEquals((long)8L, (long)((MetadataValue)newMdvs.get(8)).getPlace());
        List newRelationships = this.relationshipService.findByItem(this.context, newPublication);
        Assert.assertEquals((long)6L, (long)newRelationships.size());
        Assert.assertEquals((Object)newPublication, (Object)((Relationship)newRelationships.get(0)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)newRelationships.get(0)).getRelationshipType());
        Assert.assertEquals((Object)author2, (Object)((Relationship)newRelationships.get(0)).getRightItem());
        Assert.assertEquals((long)1L, (long)((Relationship)newRelationships.get(0)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)newRelationships.get(0)).getRightPlace());
        Assert.assertEquals((Object)newPublication, (Object)((Relationship)newRelationships.get(1)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)newRelationships.get(1)).getRelationshipType());
        Assert.assertEquals((Object)author3, (Object)((Relationship)newRelationships.get(1)).getRightItem());
        Assert.assertEquals((long)2L, (long)((Relationship)newRelationships.get(1)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)newRelationships.get(1)).getRightPlace());
        Assert.assertEquals((Object)newPublication, (Object)((Relationship)newRelationships.get(2)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)newRelationships.get(2)).getRelationshipType());
        Assert.assertEquals((Object)author4, (Object)((Relationship)newRelationships.get(2)).getRightItem());
        Assert.assertEquals((long)3L, (long)((Relationship)newRelationships.get(2)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)newRelationships.get(2)).getRightPlace());
        Assert.assertEquals((Object)newPublication, (Object)((Relationship)newRelationships.get(3)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)newRelationships.get(3)).getRelationshipType());
        Assert.assertEquals((Object)author5, (Object)((Relationship)newRelationships.get(3)).getRightItem());
        Assert.assertEquals((long)4L, (long)((Relationship)newRelationships.get(3)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)newRelationships.get(3)).getRightPlace());
        Assert.assertEquals((Object)newPublication, (Object)((Relationship)newRelationships.get(4)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)newRelationships.get(4)).getRelationshipType());
        Assert.assertEquals((Object)author7, (Object)((Relationship)newRelationships.get(4)).getRightItem());
        Assert.assertEquals((long)6L, (long)((Relationship)newRelationships.get(4)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)newRelationships.get(4)).getRightPlace());
        Assert.assertEquals((Object)newPublication, (Object)((Relationship)newRelationships.get(5)).getLeftItem());
        Assert.assertEquals((Object)this.isAuthorOfPublication, (Object)((Relationship)newRelationships.get(5)).getRelationshipType());
        Assert.assertEquals((Object)author9, (Object)((Relationship)newRelationships.get(5)).getRightItem());
        Assert.assertEquals((long)8L, (long)((Relationship)newRelationships.get(5)).getLeftPlace());
        Assert.assertEquals((long)0L, (long)((Relationship)newRelationships.get(5)).getRightPlace());
        List relationships = this.relationshipService.findAll(this.context);
        for (Relationship relationship : relationships) {
            this.relationshipService.delete(this.context, (Object)relationship);
        }
    }

    @Test
    public void test_createNewVersionOfItemWithAddRemoveMove() throws Exception {
        Item originalPublication = ItemBuilder.createItem(this.context, this.collection).withTitle("original publication").withMetadata("dspace", "entity", "type", this.publicationEntityType.getLabel()).build();
        ArrayList<Item> projects = new ArrayList<Item>();
        for (int i = 0; i < 10; ++i) {
            Item project2 = ItemBuilder.createItem(this.context, this.collection).withTitle("project " + i).withMetadata("dspace", "entity", "type", this.projectEntityType.getLabel()).build();
            projects.add(project2);
            RelationshipBuilder.createRelationshipBuilder(this.context, originalPublication, project2, this.isProjectOfPublication).build();
        }
        AtomicInteger counterOriginalPublication = new AtomicInteger();
        List listOriginalPublication = projects.stream().map(project -> RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project, Relationship.LatestVersionStatus.BOTH, counterOriginalPublication.getAndIncrement(), 0)).collect(Collectors.toCollection(ArrayList::new));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder((java.util.Collection)listOriginalPublication));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder((java.util.Collection)listOriginalPublication));
        Version newVersion = VersionBuilder.createVersion(this.context, originalPublication, "test").build();
        Item newPublication = newVersion.getItem();
        Assert.assertNotSame((Object)originalPublication, (Object)newPublication);
        this.verifyProjectsMatch(originalPublication, projects, newPublication, projects, false);
        ArrayList<Item> newProjects = new ArrayList<Item>(projects);
        Assert.assertEquals((long)newProjects.size(), (long)10L);
        this.removeProject(newPublication, 5, newProjects);
        Assert.assertEquals((long)projects.size(), (long)10L);
        Assert.assertEquals((long)newProjects.size(), (long)9L);
        this.verifyProjectsMatch(originalPublication, projects, newPublication, newProjects, false);
        Item project6 = (Item)newProjects.get(6);
        this.moveProject(newPublication, 6, 2, newProjects);
        Assert.assertEquals((long)newProjects.size(), (long)9L);
        Assert.assertEquals(newProjects.get(2), (Object)project6);
        Assert.assertNotEquals(projects.get(2), (Object)project6);
        this.verifyProjectsMatch(originalPublication, projects, newPublication, newProjects, false);
        Item project1 = (Item)newProjects.get(1);
        this.moveProject(newPublication, 1, 5, newProjects);
        Assert.assertEquals((long)newProjects.size(), (long)9L);
        Assert.assertEquals(newProjects.get(5), (Object)project1);
        Assert.assertNotEquals(projects.get(5), (Object)project1);
        this.verifyProjectsMatch(originalPublication, projects, newPublication, newProjects, false);
        Item project3 = ItemBuilder.createItem(this.context, this.collection).withTitle("project 10").withMetadata("dspace", "entity", "type", this.projectEntityType.getLabel()).build();
        newProjects.add(4, project3);
        RelationshipBuilder.createRelationshipBuilder(this.context, newPublication, project3, this.isProjectOfPublication, 4, -1).build();
        this.verifyProjectsMatch(originalPublication, projects, newPublication, newProjects, false);
        WorkspaceItem newPublicationWSI = this.workspaceItemService.findByItem(this.context, newPublication);
        this.installItemService.installItem(this.context, (InProgressSubmission)newPublicationWSI);
        this.context.dispatchEvents();
        this.verifyProjectsMatch(originalPublication, projects, newPublication, newProjects, true);
        List relationships = this.relationshipService.findAll(this.context);
        for (Relationship relationship : relationships) {
            this.relationshipService.delete(this.context, (Object)relationship);
        }
    }

    protected void removeProject(Item newPublication, int place, List<Item> newProjects) throws SQLException, AuthorizeException {
        List projectRels = this.relationshipService.findByItemAndRelationshipType(this.context, newProjects.get(place), this.isProjectOfPublication, -1, -1, false).stream().filter(relationship -> relationship.getLeftItem().equals((Object)newPublication)).collect(Collectors.toCollection(ArrayList::new));
        Assert.assertEquals((long)1L, (long)projectRels.size());
        this.relationshipService.delete(this.context, (Object)((Relationship)projectRels.get(0)));
        newProjects.remove(newProjects.get(place));
    }

    protected void moveProject(Item newPublication, int oldPlace, int newPlace, List<Item> newProjects) throws SQLException, AuthorizeException {
        Item project = newProjects.get(oldPlace);
        List projectRels = this.relationshipService.findByItemAndRelationshipType(this.context, project, this.isProjectOfPublication, -1, -1, false).stream().filter(relationship -> relationship.getLeftItem().equals((Object)newPublication)).collect(Collectors.toCollection(ArrayList::new));
        Assert.assertEquals((long)1L, (long)projectRels.size());
        this.relationshipService.move(this.context, (Relationship)projectRels.get(0), Integer.valueOf(newPlace), null);
        newProjects.remove(project);
        newProjects.add(newPlace, project);
    }

    protected void verifyProjectsMatch(Item originalPublication, List<Item> originalProjects, Item newPublication, List<Item> newProjects, boolean newPublicationArchived) throws SQLException {
        AtomicInteger counterOriginalPublication = new AtomicInteger();
        List listOriginalPublication = originalProjects.stream().map(project -> RelationshipVersioningTestUtils.isRel(originalPublication, this.isProjectOfPublication, project, newPublicationArchived ? Relationship.LatestVersionStatus.RIGHT_ONLY : Relationship.LatestVersionStatus.BOTH, counterOriginalPublication.getAndIncrement(), 0)).collect(Collectors.toCollection(ArrayList::new));
        AtomicInteger counterNewPublication = new AtomicInteger();
        List listNewPublication = newProjects.stream().map(project -> RelationshipVersioningTestUtils.isRel(newPublication, this.isProjectOfPublication, project, newPublicationArchived || !originalProjects.contains(project) ? Relationship.LatestVersionStatus.BOTH : Relationship.LatestVersionStatus.RIGHT_ONLY, counterNewPublication.getAndIncrement(), 0)).collect(Collectors.toCollection(ArrayList::new));
        Assert.assertEquals((long)this.relationshipService.countByItem(this.context, originalPublication, false, true), (long)originalProjects.size());
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder((java.util.Collection)listOriginalPublication));
        Assert.assertEquals((long)this.relationshipService.countByItem(this.context, newPublication, false, true), (long)newProjects.size());
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, true), (Matcher)Matchers.containsInAnyOrder((java.util.Collection)listNewPublication));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, originalPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder((java.util.Collection)listOriginalPublication));
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, newPublication, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder((java.util.Collection)listNewPublication));
    }

    protected <T> T createBean(Class<T> beanClass) throws Exception {
        AutowireCapableBeanFactory factory = DSpaceServicesFactory.getInstance().getServiceManager().getApplicationContext().getAutowireCapableBeanFactory();
        T bean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        factory.autowireBean(bean);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWithVirtualMetadataConfig(FailableSupplier<Map<String, HashMap<String, VirtualMetadataConfiguration>>, Exception> configModifier, FailableRunnable<Exception> callback) throws Exception {
        VirtualMetadataPopulator virtualMetadataPopulator = (VirtualMetadataPopulator)DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(VirtualMetadataPopulator.class).get(0);
        Map oldConfig = virtualMetadataPopulator.getMap();
        try {
            Map newConfig = (Map)configModifier.get();
            virtualMetadataPopulator.setMap(newConfig);
            callback.run();
        }
        finally {
            virtualMetadataPopulator.setMap(oldConfig);
        }
    }

    @Test
    public void test_placeRecalculationAfterDelete() throws Exception {
        ServiceManager serviceManager = DSpaceServicesFactory.getInstance().getServiceManager();
        Collected issueVmd = (Collected)serviceManager.getServiceByName("journalIssue_number", Collected.class);
        Assert.assertNotNull((Object)issueVmd);
        boolean ogIssueVmdUseForPlace = issueVmd.getUseForPlace();
        issueVmd.setUseForPlace(true);
        Item v1_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal volume 1").withMetadata("dspace", "entity", "type", this.journalVolumeEntityType.getLabel()).withMetadata("publicationvolume", "volumeNumber", null, "volume nr 3 (rel)").build();
        Item i1_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal issue 1").withMetadata("dspace", "entity", "type", this.journalIssueEntityType.getLabel()).withMetadata("publicationissue", "issueNumber", null, "issue nr 1 (rel)").build();
        Item i3_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal issue 3").withMetadata("dspace", "entity", "type", this.journalIssueEntityType.getLabel()).withMetadata("publicationissue", "issueNumber", null, "issue nr 3 (rel)").build();
        Item i5_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal issue 5").withMetadata("dspace", "entity", "type", this.journalIssueEntityType.getLabel()).withMetadata("publicationissue", "issueNumber", null, "issue nr 5 (rel)").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, v1_1, i1_1, this.isIssueOfJournalVolume).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)v1_1, "publicationissue", "issueNumber", null, null, "issue nr 2 (plain)");
        RelationshipBuilder.createRelationshipBuilder(this.context, v1_1, i3_1, this.isIssueOfJournalVolume).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)v1_1, "publicationissue", "issueNumber", null, null, "issue nr 4 (plain)");
        RelationshipBuilder.createRelationshipBuilder(this.context, v1_1, i5_1, this.isIssueOfJournalVolume).build();
        this.itemService.addMetadata(this.context, (DSpaceObject)v1_1, "publicationissue", "issueNumber", null, null, "issue nr 6 (plain)");
        List mdvs1 = this.itemService.getMetadata((DSpaceObject)v1_1, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)6L, (long)mdvs1.size());
        Assert.assertTrue((boolean)(mdvs1.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs1.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs1.get(0)).getPlace());
        Assert.assertFalse((boolean)(mdvs1.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (plain)", (Object)((MetadataValue)mdvs1.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs1.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs1.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs1.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs1.get(2)).getPlace());
        Assert.assertFalse((boolean)(mdvs1.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (plain)", (Object)((MetadataValue)mdvs1.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs1.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs1.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs1.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs1.get(4)).getPlace());
        Assert.assertFalse((boolean)(mdvs1.get(5) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 6 (plain)", (Object)((MetadataValue)mdvs1.get(5)).getValue());
        Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs1.get(5)).getPlace());
        Item v1_2 = VersionBuilder.createVersion(this.context, v1_1, "test").build().getItem();
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, v1_2));
        this.context.commit();
        Item i3_2 = VersionBuilder.createVersion(this.context, i3_1, "test").build().getItem();
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, i3_2));
        this.context.commit();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 0))));
        List mdvs4 = this.itemService.getMetadata((DSpaceObject)v1_1, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)6L, (long)mdvs4.size());
        Assert.assertTrue((boolean)(mdvs4.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs4.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs4.get(0)).getPlace());
        Assert.assertFalse((boolean)(mdvs4.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (plain)", (Object)((MetadataValue)mdvs4.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs4.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs4.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs4.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs4.get(2)).getPlace());
        Assert.assertFalse((boolean)(mdvs4.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (plain)", (Object)((MetadataValue)mdvs4.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs4.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs4.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs4.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs4.get(4)).getPlace());
        Assert.assertFalse((boolean)(mdvs4.get(5) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 6 (plain)", (Object)((MetadataValue)mdvs4.get(5)).getValue());
        Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs4.get(5)).getPlace());
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.BOTH, 4, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i3_2, Relationship.LatestVersionStatus.BOTH, 2, 0))));
        List mdvs7 = this.itemService.getMetadata((DSpaceObject)v1_2, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)6L, (long)mdvs7.size());
        Assert.assertTrue((boolean)(mdvs7.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs7.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs7.get(0)).getPlace());
        Assert.assertFalse((boolean)(mdvs7.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (plain)", (Object)((MetadataValue)mdvs7.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs7.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs7.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs7.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs7.get(2)).getPlace());
        Assert.assertFalse((boolean)(mdvs7.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (plain)", (Object)((MetadataValue)mdvs7.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs7.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs7.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs7.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs7.get(4)).getPlace());
        Assert.assertFalse((boolean)(mdvs7.get(5) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 6 (plain)", (Object)((MetadataValue)mdvs7.get(5)).getValue());
        Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs7.get(5)).getPlace());
        Relationship rel1 = this.getRelationship(v1_2, this.isIssueOfJournalVolume, i3_2);
        Assert.assertNotNull((Object)rel1);
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.context.reloadEntity((ReloadableEntity)i3_2)));
        this.context.commit();
        v1_2.setMetadataModified();
        v1_2 = (Item)this.context.reloadEntity((ReloadableEntity)v1_2);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 0))));
        List mdvs9 = this.itemService.getMetadata((DSpaceObject)v1_1, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)6L, (long)mdvs9.size());
        Assert.assertTrue((boolean)(mdvs9.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs9.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs9.get(0)).getPlace());
        Assert.assertFalse((boolean)(mdvs9.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (plain)", (Object)((MetadataValue)mdvs9.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs9.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs9.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs9.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs9.get(2)).getPlace());
        Assert.assertFalse((boolean)(mdvs9.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (plain)", (Object)((MetadataValue)mdvs9.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs9.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs9.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs9.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs9.get(4)).getPlace());
        Assert.assertFalse((boolean)(mdvs9.get(5) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 6 (plain)", (Object)((MetadataValue)mdvs9.get(5)).getValue());
        Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs9.get(5)).getPlace());
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.BOTH, 3, 0))));
        List mdvs12 = this.itemService.getMetadata((DSpaceObject)v1_2, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)5L, (long)mdvs12.size());
        Assert.assertTrue((boolean)(mdvs12.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs12.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs12.get(0)).getPlace());
        Assert.assertFalse((boolean)(mdvs12.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (plain)", (Object)((MetadataValue)mdvs12.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs12.get(1)).getPlace());
        Assert.assertFalse((boolean)(mdvs12.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (plain)", (Object)((MetadataValue)mdvs12.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs12.get(2)).getPlace());
        Assert.assertTrue((boolean)(mdvs12.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs12.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs12.get(3)).getPlace());
        Assert.assertFalse((boolean)(mdvs12.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 6 (plain)", (Object)((MetadataValue)mdvs12.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs12.get(4)).getPlace());
        MetadataValue removeMdv1 = (MetadataValue)mdvs12.get(2);
        Assert.assertFalse((boolean)(removeMdv1 instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (plain)", (Object)removeMdv1.getValue());
        Assert.assertEquals((long)2L, (long)removeMdv1.getPlace());
        Assert.assertEquals((Object)v1_2, (Object)removeMdv1.getDSpaceObject());
        this.itemService.removeMetadataValues(this.context, (DSpaceObject)v1_2, List.of(removeMdv1));
        this.itemService.update(this.context, (DSpaceObject)v1_2);
        this.context.commit();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 0))));
        List mdvs14 = this.itemService.getMetadata((DSpaceObject)v1_1, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)6L, (long)mdvs14.size());
        Assert.assertTrue((boolean)(mdvs14.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs14.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs14.get(0)).getPlace());
        Assert.assertFalse((boolean)(mdvs14.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (plain)", (Object)((MetadataValue)mdvs14.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs14.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs14.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs14.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs14.get(2)).getPlace());
        Assert.assertFalse((boolean)(mdvs14.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (plain)", (Object)((MetadataValue)mdvs14.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs14.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs14.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs14.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs14.get(4)).getPlace());
        Assert.assertFalse((boolean)(mdvs14.get(5) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 6 (plain)", (Object)((MetadataValue)mdvs14.get(5)).getValue());
        Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs14.get(5)).getPlace());
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.BOTH, 2, 0))));
        List mdvs17 = this.itemService.getMetadata((DSpaceObject)v1_2, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)4L, (long)mdvs17.size());
        Assert.assertTrue((boolean)(mdvs17.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs17.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs17.get(0)).getPlace());
        Assert.assertFalse((boolean)(mdvs17.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (plain)", (Object)((MetadataValue)mdvs17.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs17.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs17.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs17.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs17.get(2)).getPlace());
        Assert.assertFalse((boolean)(mdvs17.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 6 (plain)", (Object)((MetadataValue)mdvs17.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs17.get(3)).getPlace());
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.context.reloadEntity((ReloadableEntity)v1_1)));
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.context.reloadEntity((ReloadableEntity)v1_2)));
        issueVmd.setUseForPlace(ogIssueVmdUseForPlace);
    }

    @Test
    public void test_placeRecalculationAfterDelete_complex() throws Exception {
        this.runWithVirtualMetadataConfig((FailableSupplier<Map<String, HashMap<String, VirtualMetadataConfiguration>>, Exception>)((FailableSupplier)() -> {
            Collected dcRelation = this.createBean(Collected.class);
            dcRelation.setFields(List.of("dc.title"));
            dcRelation.setUseForPlace(true);
            Collected dcContributorAuthor = this.createBean(Collected.class);
            dcContributorAuthor.setFields(List.of("dc.title"));
            dcContributorAuthor.setUseForPlace(true);
            return Map.of("isProjectOfPerson", new HashMap<String, Collected>(Map.of("dc.relation", dcRelation)), "isPersonOfProject", new HashMap<String, Collected>(Map.of("dc.contributor.author", dcContributorAuthor)));
        }), (FailableRunnable<Exception>)((FailableRunnable)() -> {
            Item pe1_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("person 1 (item)").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).build();
            Item pe3_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("person 3 (item)").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).build();
            Item pe5_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("person 5 (item)").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).build();
            Item pr1_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("project 1 (item)").withMetadata("dspace", "entity", "type", this.projectEntityType.getLabel()).build();
            Item pr3_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("project 3 (item)").withMetadata("dspace", "entity", "type", this.projectEntityType.getLabel()).build();
            Item pr5_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("project 5 (item)").withMetadata("dspace", "entity", "type", this.projectEntityType.getLabel()).build();
            RelationshipBuilder.createRelationshipBuilder(this.context, pe3_1, pr1_1, this.isProjectOfPerson).build();
            this.itemService.addMetadata(this.context, (DSpaceObject)pe3_1, "dc", "relation", null, null, "project 2 (mdv)");
            RelationshipBuilder.createRelationshipBuilder(this.context, pe1_1, pr3_1, this.isProjectOfPerson).build();
            this.itemService.addMetadata(this.context, (DSpaceObject)pr3_1, "dc", "contributor", "author", null, "person 2 (mdv)");
            RelationshipBuilder.createRelationshipBuilder(this.context, pe3_1, pr3_1, this.isProjectOfPerson).build();
            this.itemService.addMetadata(this.context, (DSpaceObject)pr3_1, "dc", "contributor", "author", null, "person 4 (mdv)");
            RelationshipBuilder.createRelationshipBuilder(this.context, pe5_1, pr3_1, this.isProjectOfPerson).build();
            this.itemService.addMetadata(this.context, (DSpaceObject)pr3_1, "dc", "contributor", "author", null, "person 6 (mdv)");
            this.itemService.addMetadata(this.context, (DSpaceObject)pr5_1, "dc", "contributor", "author", null, "person 7 (mdv)");
            RelationshipBuilder.createRelationshipBuilder(this.context, pe5_1, pr5_1, this.isProjectOfPerson).build();
            this.itemService.addMetadata(this.context, (DSpaceObject)pe3_1, "dc", "relation", null, null, "project 4 (mdv)");
            RelationshipBuilder.createRelationshipBuilder(this.context, pe3_1, pr5_1, this.isProjectOfPerson).build();
            this.itemService.addMetadata(this.context, (DSpaceObject)pe3_1, "dc", "relation", null, null, "project 6 (mdv)");
            List mdvs1 = this.itemService.getMetadata((DSpaceObject)pe3_1, "dc", "relation", null, "*");
            Assert.assertEquals((long)6L, (long)mdvs1.size());
            Assert.assertTrue((boolean)(mdvs1.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 1 (item)", (Object)((MetadataValue)mdvs1.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs1.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs1.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 2 (mdv)", (Object)((MetadataValue)mdvs1.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs1.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs1.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 3 (item)", (Object)((MetadataValue)mdvs1.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs1.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs1.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 4 (mdv)", (Object)((MetadataValue)mdvs1.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs1.get(3)).getPlace());
            Assert.assertTrue((boolean)(mdvs1.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 5 (item)", (Object)((MetadataValue)mdvs1.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs1.get(4)).getPlace());
            Assert.assertFalse((boolean)(mdvs1.get(5) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 6 (mdv)", (Object)((MetadataValue)mdvs1.get(5)).getValue());
            Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs1.get(5)).getPlace());
            List mdvs2 = this.itemService.getMetadata((DSpaceObject)pr3_1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)6L, (long)mdvs2.size());
            Assert.assertTrue((boolean)(mdvs2.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 1 (item)", (Object)((MetadataValue)mdvs2.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs2.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs2.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 2 (mdv)", (Object)((MetadataValue)mdvs2.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs2.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs2.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 3 (item)", (Object)((MetadataValue)mdvs2.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs2.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs2.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 4 (mdv)", (Object)((MetadataValue)mdvs2.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs2.get(3)).getPlace());
            Assert.assertTrue((boolean)(mdvs2.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs2.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs2.get(4)).getPlace());
            Assert.assertFalse((boolean)(mdvs2.get(5) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 6 (mdv)", (Object)((MetadataValue)mdvs2.get(5)).getValue());
            Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs2.get(5)).getPlace());
            List mdvs3 = this.itemService.getMetadata((DSpaceObject)pr5_1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)3L, (long)mdvs3.size());
            Assert.assertFalse((boolean)(mdvs3.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 7 (mdv)", (Object)((MetadataValue)mdvs3.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs3.get(0)).getPlace());
            Assert.assertTrue((boolean)(mdvs3.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs3.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs3.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs3.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 3 (item)", (Object)((MetadataValue)mdvs3.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs3.get(2)).getPlace());
            Item pe3_2 = VersionBuilder.createVersion(this.context, pe3_1, "test").build().getItem();
            this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, pe3_2));
            this.context.commit();
            Item pr3_2 = VersionBuilder.createVersion(this.context, pr3_1, "test").build().getItem();
            this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, pr3_2));
            this.context.commit();
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pe3_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr1_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 2))));
            List mdvs4 = this.itemService.getMetadata((DSpaceObject)pe3_1, "dc", "relation", null, "*");
            Assert.assertEquals((long)6L, (long)mdvs4.size());
            Assert.assertTrue((boolean)(mdvs4.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 1 (item)", (Object)((MetadataValue)mdvs4.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs4.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs4.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 2 (mdv)", (Object)((MetadataValue)mdvs4.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs4.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs4.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 3 (item)", (Object)((MetadataValue)mdvs4.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs4.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs4.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 4 (mdv)", (Object)((MetadataValue)mdvs4.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs4.get(3)).getPlace());
            Assert.assertTrue((boolean)(mdvs4.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 5 (item)", (Object)((MetadataValue)mdvs4.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs4.get(4)).getPlace());
            Assert.assertFalse((boolean)(mdvs4.get(5) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 6 (mdv)", (Object)((MetadataValue)mdvs4.get(5)).getValue());
            Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs4.get(5)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pr3_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe1_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe5_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 4), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 2))));
            List mdvs5 = this.itemService.getMetadata((DSpaceObject)pr3_1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)6L, (long)mdvs5.size());
            Assert.assertTrue((boolean)(mdvs5.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 1 (item)", (Object)((MetadataValue)mdvs5.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs5.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs5.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 2 (mdv)", (Object)((MetadataValue)mdvs5.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs5.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs5.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 3 (item)", (Object)((MetadataValue)mdvs5.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs5.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs5.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 4 (mdv)", (Object)((MetadataValue)mdvs5.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs5.get(3)).getPlace());
            Assert.assertTrue((boolean)(mdvs5.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs5.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs5.get(4)).getPlace());
            Assert.assertFalse((boolean)(mdvs5.get(5) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 6 (mdv)", (Object)((MetadataValue)mdvs5.get(5)).getValue());
            Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs5.get(5)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pr5_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe5_1, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.BOTH, 1, 1), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 2), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.BOTH, 4, 2))));
            List mdvs6 = this.itemService.getMetadata((DSpaceObject)pr5_1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)3L, (long)mdvs6.size());
            Assert.assertFalse((boolean)(mdvs6.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 7 (mdv)", (Object)((MetadataValue)mdvs6.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs6.get(0)).getPlace());
            Assert.assertTrue((boolean)(mdvs6.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs6.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs6.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs6.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 3 (item)", (Object)((MetadataValue)mdvs6.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs6.get(2)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pe3_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr1_1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr3_2, Relationship.LatestVersionStatus.BOTH, 2, 2), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.BOTH, 4, 2))));
            List mdvs7 = this.itemService.getMetadata((DSpaceObject)pe3_2, "dc", "relation", null, "*");
            Assert.assertEquals((long)6L, (long)mdvs7.size());
            Assert.assertTrue((boolean)(mdvs7.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 1 (item)", (Object)((MetadataValue)mdvs7.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs7.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs7.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 2 (mdv)", (Object)((MetadataValue)mdvs7.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs7.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs7.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 3 (item)", (Object)((MetadataValue)mdvs7.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs7.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs7.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 4 (mdv)", (Object)((MetadataValue)mdvs7.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs7.get(3)).getPlace());
            Assert.assertTrue((boolean)(mdvs7.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 5 (item)", (Object)((MetadataValue)mdvs7.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs7.get(4)).getPlace());
            Assert.assertFalse((boolean)(mdvs7.get(5) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 6 (mdv)", (Object)((MetadataValue)mdvs7.get(5)).getValue());
            Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs7.get(5)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pr3_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe1_1, this.isProjectOfPerson, pr3_2, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(pe5_1, this.isProjectOfPerson, pr3_2, Relationship.LatestVersionStatus.BOTH, 0, 4), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr3_2, Relationship.LatestVersionStatus.BOTH, 2, 2))));
            List mdvs8 = this.itemService.getMetadata((DSpaceObject)pr3_2, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)6L, (long)mdvs8.size());
            Assert.assertTrue((boolean)(mdvs8.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 1 (item)", (Object)((MetadataValue)mdvs8.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs8.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs8.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 2 (mdv)", (Object)((MetadataValue)mdvs8.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs8.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs8.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 3 (item)", (Object)((MetadataValue)mdvs8.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs8.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs8.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 4 (mdv)", (Object)((MetadataValue)mdvs8.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs8.get(3)).getPlace());
            Assert.assertTrue((boolean)(mdvs8.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs8.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs8.get(4)).getPlace());
            Assert.assertFalse((boolean)(mdvs8.get(5) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 6 (mdv)", (Object)((MetadataValue)mdvs8.get(5)).getValue());
            Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs8.get(5)).getPlace());
            Relationship rel1 = this.getRelationship(pe3_2, this.isProjectOfPerson, pr3_2);
            Assert.assertNotNull((Object)rel1);
            this.relationshipService.delete(this.context, rel1, false, false);
            this.context.commit();
            pe3_2.setMetadataModified();
            pe3_2 = (Item)this.context.reloadEntity((ReloadableEntity)pe3_2);
            pr3_2.setMetadataModified();
            pr3_2 = (Item)this.context.reloadEntity((ReloadableEntity)pr3_2);
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pe3_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr1_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 2))));
            List mdvs9 = this.itemService.getMetadata((DSpaceObject)pe3_1, "dc", "relation", null, "*");
            Assert.assertEquals((long)6L, (long)mdvs9.size());
            Assert.assertTrue((boolean)(mdvs9.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 1 (item)", (Object)((MetadataValue)mdvs9.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs9.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs9.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 2 (mdv)", (Object)((MetadataValue)mdvs9.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs9.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs9.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 3 (item)", (Object)((MetadataValue)mdvs9.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs9.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs9.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 4 (mdv)", (Object)((MetadataValue)mdvs9.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs9.get(3)).getPlace());
            Assert.assertTrue((boolean)(mdvs9.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 5 (item)", (Object)((MetadataValue)mdvs9.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs9.get(4)).getPlace());
            Assert.assertFalse((boolean)(mdvs9.get(5) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 6 (mdv)", (Object)((MetadataValue)mdvs9.get(5)).getValue());
            Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs9.get(5)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pr3_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe1_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe5_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 4))));
            List mdvs10 = this.itemService.getMetadata((DSpaceObject)pr3_1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)6L, (long)mdvs10.size());
            Assert.assertTrue((boolean)(mdvs10.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 1 (item)", (Object)((MetadataValue)mdvs10.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs10.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs10.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 2 (mdv)", (Object)((MetadataValue)mdvs10.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs10.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs10.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 3 (item)", (Object)((MetadataValue)mdvs10.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs10.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs10.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 4 (mdv)", (Object)((MetadataValue)mdvs10.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs10.get(3)).getPlace());
            Assert.assertTrue((boolean)(mdvs10.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs10.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs10.get(4)).getPlace());
            Assert.assertFalse((boolean)(mdvs10.get(5) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 6 (mdv)", (Object)((MetadataValue)mdvs10.get(5)).getValue());
            Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs10.get(5)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pr5_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe5_1, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.BOTH, 1, 1), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 2), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.BOTH, 3, 2))));
            List mdvs11 = this.itemService.getMetadata((DSpaceObject)pr5_1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)3L, (long)mdvs11.size());
            Assert.assertFalse((boolean)(mdvs11.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 7 (mdv)", (Object)((MetadataValue)mdvs11.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs11.get(0)).getPlace());
            Assert.assertTrue((boolean)(mdvs11.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs11.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs11.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs11.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 3 (item)", (Object)((MetadataValue)mdvs11.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs11.get(2)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pe3_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr1_1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.BOTH, 3, 2))));
            List mdvs12 = this.itemService.getMetadata((DSpaceObject)pe3_2, "dc", "relation", null, "*");
            Assert.assertEquals((long)5L, (long)mdvs12.size());
            Assert.assertTrue((boolean)(mdvs12.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 1 (item)", (Object)((MetadataValue)mdvs12.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs12.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs12.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 2 (mdv)", (Object)((MetadataValue)mdvs12.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs12.get(1)).getPlace());
            Assert.assertFalse((boolean)(mdvs12.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 4 (mdv)", (Object)((MetadataValue)mdvs12.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs12.get(2)).getPlace());
            Assert.assertTrue((boolean)(mdvs12.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 5 (item)", (Object)((MetadataValue)mdvs12.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs12.get(3)).getPlace());
            Assert.assertFalse((boolean)(mdvs12.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 6 (mdv)", (Object)((MetadataValue)mdvs12.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs12.get(4)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pr3_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe1_1, this.isProjectOfPerson, pr3_2, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(pe5_1, this.isProjectOfPerson, pr3_2, Relationship.LatestVersionStatus.BOTH, 0, 3))));
            List mdvs13 = this.itemService.getMetadata((DSpaceObject)pr3_2, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)5L, (long)mdvs13.size());
            Assert.assertTrue((boolean)(mdvs13.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 1 (item)", (Object)((MetadataValue)mdvs13.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs13.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs13.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 2 (mdv)", (Object)((MetadataValue)mdvs13.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs13.get(1)).getPlace());
            Assert.assertFalse((boolean)(mdvs13.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 4 (mdv)", (Object)((MetadataValue)mdvs13.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs13.get(2)).getPlace());
            Assert.assertTrue((boolean)(mdvs13.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs13.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs13.get(3)).getPlace());
            Assert.assertFalse((boolean)(mdvs13.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 6 (mdv)", (Object)((MetadataValue)mdvs13.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs13.get(4)).getPlace());
            MetadataValue removeMdv1 = (MetadataValue)mdvs12.get(2);
            Assert.assertFalse((boolean)(removeMdv1 instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 4 (mdv)", (Object)removeMdv1.getValue());
            Assert.assertEquals((long)2L, (long)removeMdv1.getPlace());
            Assert.assertEquals((Object)pe3_2, (Object)removeMdv1.getDSpaceObject());
            this.itemService.removeMetadataValues(this.context, (DSpaceObject)pe3_2, List.of(removeMdv1));
            this.itemService.update(this.context, (DSpaceObject)pe3_2);
            this.context.commit();
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pe3_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr1_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 2))));
            List mdvs14 = this.itemService.getMetadata((DSpaceObject)pe3_1, "dc", "relation", null, "*");
            Assert.assertEquals((long)6L, (long)mdvs14.size());
            Assert.assertTrue((boolean)(mdvs14.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 1 (item)", (Object)((MetadataValue)mdvs14.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs14.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs14.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 2 (mdv)", (Object)((MetadataValue)mdvs14.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs14.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs14.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 3 (item)", (Object)((MetadataValue)mdvs14.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs14.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs14.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 4 (mdv)", (Object)((MetadataValue)mdvs14.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs14.get(3)).getPlace());
            Assert.assertTrue((boolean)(mdvs14.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 5 (item)", (Object)((MetadataValue)mdvs14.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs14.get(4)).getPlace());
            Assert.assertFalse((boolean)(mdvs14.get(5) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 6 (mdv)", (Object)((MetadataValue)mdvs14.get(5)).getValue());
            Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs14.get(5)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pr3_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe1_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe5_1, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 4))));
            List mdvs15 = this.itemService.getMetadata((DSpaceObject)pr3_1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)6L, (long)mdvs15.size());
            Assert.assertTrue((boolean)(mdvs15.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 1 (item)", (Object)((MetadataValue)mdvs15.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs15.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs15.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 2 (mdv)", (Object)((MetadataValue)mdvs15.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs15.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs15.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 3 (item)", (Object)((MetadataValue)mdvs15.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs15.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs15.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 4 (mdv)", (Object)((MetadataValue)mdvs15.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs15.get(3)).getPlace());
            Assert.assertTrue((boolean)(mdvs15.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs15.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs15.get(4)).getPlace());
            Assert.assertFalse((boolean)(mdvs15.get(5) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 6 (mdv)", (Object)((MetadataValue)mdvs15.get(5)).getValue());
            Assert.assertEquals((long)5L, (long)((MetadataValue)mdvs15.get(5)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pr5_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe5_1, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.BOTH, 1, 1), RelationshipVersioningTestUtils.isRel(pe3_1, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 2), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.BOTH, 2, 2))));
            List mdvs16 = this.itemService.getMetadata((DSpaceObject)pr5_1, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)3L, (long)mdvs16.size());
            Assert.assertFalse((boolean)(mdvs16.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 7 (mdv)", (Object)((MetadataValue)mdvs16.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs16.get(0)).getPlace());
            Assert.assertTrue((boolean)(mdvs16.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs16.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs16.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs16.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 3 (item)", (Object)((MetadataValue)mdvs16.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs16.get(2)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pe3_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr1_1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 2), RelationshipVersioningTestUtils.isRel(pe3_2, this.isProjectOfPerson, pr5_1, Relationship.LatestVersionStatus.BOTH, 2, 2))));
            List mdvs17 = this.itemService.getMetadata((DSpaceObject)pe3_2, "dc", "relation", null, "*");
            Assert.assertEquals((long)4L, (long)mdvs17.size());
            Assert.assertTrue((boolean)(mdvs17.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 1 (item)", (Object)((MetadataValue)mdvs17.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs17.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs17.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 2 (mdv)", (Object)((MetadataValue)mdvs17.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs17.get(1)).getPlace());
            Assert.assertTrue((boolean)(mdvs17.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 5 (item)", (Object)((MetadataValue)mdvs17.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs17.get(2)).getPlace());
            Assert.assertFalse((boolean)(mdvs17.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"project 6 (mdv)", (Object)((MetadataValue)mdvs17.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs17.get(3)).getPlace());
            MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, pr3_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(pe1_1, this.isProjectOfPerson, pr3_2, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(pe5_1, this.isProjectOfPerson, pr3_2, Relationship.LatestVersionStatus.BOTH, 0, 3))));
            List mdvs18 = this.itemService.getMetadata((DSpaceObject)pr3_2, "dc", "contributor", "author", "*");
            Assert.assertEquals((long)5L, (long)mdvs18.size());
            Assert.assertTrue((boolean)(mdvs18.get(0) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 1 (item)", (Object)((MetadataValue)mdvs18.get(0)).getValue());
            Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs18.get(0)).getPlace());
            Assert.assertFalse((boolean)(mdvs18.get(1) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 2 (mdv)", (Object)((MetadataValue)mdvs18.get(1)).getValue());
            Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs18.get(1)).getPlace());
            Assert.assertFalse((boolean)(mdvs18.get(2) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 4 (mdv)", (Object)((MetadataValue)mdvs18.get(2)).getValue());
            Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs18.get(2)).getPlace());
            Assert.assertTrue((boolean)(mdvs18.get(3) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 5 (item)", (Object)((MetadataValue)mdvs18.get(3)).getValue());
            Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs18.get(3)).getPlace());
            Assert.assertFalse((boolean)(mdvs18.get(4) instanceof RelationshipMetadataValue));
            Assert.assertEquals((Object)"person 6 (mdv)", (Object)((MetadataValue)mdvs18.get(4)).getValue());
            Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs18.get(4)).getPlace());
        }));
    }

    @Test
    public void test_placeRecalculationNoUseForPlace() throws Exception {
        Item v1_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal volume 1").withMetadata("dspace", "entity", "type", this.journalVolumeEntityType.getLabel()).withMetadata("publicationvolume", "volumeNumber", null, "volume nr 1 (rel)").build();
        Item i1_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal issue 1").withMetadata("dspace", "entity", "type", this.journalIssueEntityType.getLabel()).withMetadata("publicationissue", "issueNumber", null, "issue nr 1 (rel)").build();
        Item i2_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal issue 2").withMetadata("dspace", "entity", "type", this.journalIssueEntityType.getLabel()).withMetadata("publicationissue", "issueNumber", null, "issue nr 2 (rel)").build();
        Item i3_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal issue 3").withMetadata("dspace", "entity", "type", this.journalIssueEntityType.getLabel()).withMetadata("publicationissue", "issueNumber", null, "issue nr 3 (rel)").build();
        Item i4_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal issue 4").withMetadata("dspace", "entity", "type", this.journalIssueEntityType.getLabel()).withMetadata("publicationissue", "issueNumber", null, "issue nr 4 (rel)").build();
        Item i5_1 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal issue 5").withMetadata("dspace", "entity", "type", this.journalIssueEntityType.getLabel()).withMetadata("publicationissue", "issueNumber", null, "issue nr 5 (rel)").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, v1_1, i1_1, this.isIssueOfJournalVolume).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, v1_1, i2_1, this.isIssueOfJournalVolume).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, v1_1, i3_1, this.isIssueOfJournalVolume).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, v1_1, i4_1, this.isIssueOfJournalVolume).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, v1_1, i5_1, this.isIssueOfJournalVolume).build();
        List mdvs1 = this.itemService.getMetadata((DSpaceObject)v1_1, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)5L, (long)mdvs1.size());
        Assert.assertTrue((boolean)(mdvs1.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs1.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs1.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs1.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (rel)", (Object)((MetadataValue)mdvs1.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs1.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs1.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs1.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs1.get(2)).getPlace());
        Assert.assertTrue((boolean)(mdvs1.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (rel)", (Object)((MetadataValue)mdvs1.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs1.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs1.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs1.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs1.get(4)).getPlace());
        Item v1_2 = VersionBuilder.createVersion(this.context, v1_1, "test").build().getItem();
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, v1_2));
        this.context.commit();
        Item i3_2 = VersionBuilder.createVersion(this.context, i3_1, "test").build().getItem();
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, i3_2));
        this.context.commit();
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i2_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 1, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i4_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 3, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 0))));
        List mdvs4 = this.itemService.getMetadata((DSpaceObject)v1_1, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)5L, (long)mdvs4.size());
        Assert.assertTrue((boolean)(mdvs4.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs4.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs4.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs4.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (rel)", (Object)((MetadataValue)mdvs4.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs4.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs4.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs4.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs4.get(2)).getPlace());
        Assert.assertTrue((boolean)(mdvs4.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (rel)", (Object)((MetadataValue)mdvs4.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs4.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs4.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs4.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs4.get(4)).getPlace());
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i2_1, Relationship.LatestVersionStatus.BOTH, 1, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i3_2, Relationship.LatestVersionStatus.BOTH, 2, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i4_1, Relationship.LatestVersionStatus.BOTH, 3, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.BOTH, 4, 0))));
        List mdvs7 = this.itemService.getMetadata((DSpaceObject)v1_2, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)5L, (long)mdvs7.size());
        Assert.assertTrue((boolean)(mdvs7.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs7.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs7.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs7.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (rel)", (Object)((MetadataValue)mdvs7.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs7.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs7.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs7.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs7.get(2)).getPlace());
        Assert.assertTrue((boolean)(mdvs7.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (rel)", (Object)((MetadataValue)mdvs7.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs7.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs7.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs7.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs7.get(4)).getPlace());
        Relationship rel1 = this.getRelationship(v1_2, this.isIssueOfJournalVolume, i3_2);
        Assert.assertNotNull((Object)rel1);
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.context.reloadEntity((ReloadableEntity)i3_2)));
        this.context.commit();
        v1_2.setMetadataModified();
        v1_2 = (Item)this.context.reloadEntity((ReloadableEntity)v1_2);
        i3_2.setMetadataModified();
        i3_2 = (Item)this.context.reloadEntity((ReloadableEntity)i3_2);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i2_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 1, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i4_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 3, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 0))));
        List mdvs9 = this.itemService.getMetadata((DSpaceObject)v1_1, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)5L, (long)mdvs9.size());
        Assert.assertTrue((boolean)(mdvs9.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs9.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs9.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs9.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (rel)", (Object)((MetadataValue)mdvs9.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs9.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs9.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs9.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs9.get(2)).getPlace());
        Assert.assertTrue((boolean)(mdvs9.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (rel)", (Object)((MetadataValue)mdvs9.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs9.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs9.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs9.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs9.get(4)).getPlace());
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i2_1, Relationship.LatestVersionStatus.BOTH, 1, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i4_1, Relationship.LatestVersionStatus.BOTH, 2, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.BOTH, 3, 0))));
        List mdvs12 = this.itemService.getMetadata((DSpaceObject)v1_2, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)4L, (long)mdvs12.size());
        Assert.assertTrue((boolean)(mdvs12.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs12.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs12.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs12.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (rel)", (Object)((MetadataValue)mdvs12.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs12.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs12.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (rel)", (Object)((MetadataValue)mdvs12.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs12.get(2)).getPlace());
        Assert.assertTrue((boolean)(mdvs12.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs12.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs12.get(3)).getPlace());
        Item i3_3 = ItemBuilder.createItem(this.context, this.collection).withTitle("journal issue 3").withMetadata("dspace", "entity", "type", this.journalIssueEntityType.getLabel()).withMetadata("publicationissue", "issueNumber", null, "issue nr 3 (rel)").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, v1_2, i3_3, this.isIssueOfJournalVolume, 2, -1).build();
        this.context.commit();
        v1_2.setMetadataModified();
        v1_2 = (Item)this.context.reloadEntity((ReloadableEntity)v1_2);
        i3_3.setMetadataModified();
        i3_3 = (Item)this.context.reloadEntity((ReloadableEntity)i3_3);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i2_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 1, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i4_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 3, 0), RelationshipVersioningTestUtils.isRel(v1_1, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.RIGHT_ONLY, 4, 0))));
        List mdvs14 = this.itemService.getMetadata((DSpaceObject)v1_1, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)5L, (long)mdvs14.size());
        Assert.assertTrue((boolean)(mdvs14.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs14.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs14.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs14.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (rel)", (Object)((MetadataValue)mdvs14.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs14.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs14.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs14.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs14.get(2)).getPlace());
        Assert.assertTrue((boolean)(mdvs14.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (rel)", (Object)((MetadataValue)mdvs14.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs14.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs14.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs14.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs14.get(4)).getPlace());
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, v1_2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i1_1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i2_1, Relationship.LatestVersionStatus.BOTH, 1, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i3_1, Relationship.LatestVersionStatus.LEFT_ONLY, 2, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i3_3, Relationship.LatestVersionStatus.BOTH, 2, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i4_1, Relationship.LatestVersionStatus.BOTH, 3, 0), RelationshipVersioningTestUtils.isRel(v1_2, this.isIssueOfJournalVolume, i5_1, Relationship.LatestVersionStatus.BOTH, 4, 0))));
        Assert.assertEquals((long)6L, (long)this.relationshipService.countByItem(this.context, v1_2, false, false));
        List mdvs17 = this.itemService.getMetadata((DSpaceObject)v1_2, "publicationissue", "issueNumber", null, "*");
        Assert.assertEquals((long)5L, (long)mdvs17.size());
        Assert.assertTrue((boolean)(mdvs17.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 1 (rel)", (Object)((MetadataValue)mdvs17.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs17.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs17.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 2 (rel)", (Object)((MetadataValue)mdvs17.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs17.get(1)).getPlace());
        Assert.assertTrue((boolean)(mdvs7.get(2) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 3 (rel)", (Object)((MetadataValue)mdvs7.get(2)).getValue());
        Assert.assertEquals((long)2L, (long)((MetadataValue)mdvs7.get(2)).getPlace());
        Assert.assertTrue((boolean)(mdvs17.get(3) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 4 (rel)", (Object)((MetadataValue)mdvs17.get(3)).getValue());
        Assert.assertEquals((long)3L, (long)((MetadataValue)mdvs17.get(3)).getPlace());
        Assert.assertTrue((boolean)(mdvs17.get(4) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"issue nr 5 (rel)", (Object)((MetadataValue)mdvs17.get(4)).getValue());
        Assert.assertEquals((long)4L, (long)((MetadataValue)mdvs17.get(4)).getPlace());
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.context.reloadEntity((ReloadableEntity)v1_1)));
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.context.reloadEntity((ReloadableEntity)v1_2)));
    }

    protected void verifySolrField(Item item, String fieldName, List<Object> expectedValues) throws Exception {
        QueryResponse result = this.solrSearchCore.getSolr().query((SolrParams)new SolrQuery(String.format("search.resourcetype:\"Item\" AND search.resourceid:\"%s\"", item.getID())));
        SolrDocumentList docs = result.getResults();
        Assert.assertEquals((long)1L, (long)docs.size());
        SolrDocument doc = (SolrDocument)docs.get(0);
        java.util.Collection actualValues = doc.getFieldValues(fieldName);
        if (expectedValues == null) {
            Assert.assertNull((Object)actualValues);
        } else {
            MatcherAssert.assertThat((Object)actualValues, (Matcher)Matchers.containsInAnyOrder((Object[])expectedValues.toArray()));
        }
    }

    @Test
    public void test_virtualMetadataPreserved() throws Exception {
        Item publication1V1 = ItemBuilder.createItem(this.context, this.collection).withTitle("publication 1V1").withMetadata("dspace", "entity", "type", this.publicationEntityType.getLabel()).build();
        Item person1V1 = ItemBuilder.createItem(this.context, this.collection).withTitle("person 1V1").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).withPersonIdentifierFirstName("Donald").withPersonIdentifierLastName("Smith").build();
        Item person2V1 = ItemBuilder.createItem(this.context, this.collection).withTitle("person 2V1").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).withPersonIdentifierFirstName("Jane").withPersonIdentifierLastName("Doe").build();
        RelationshipBuilder.createRelationshipBuilder(this.context, publication1V1, person1V1, this.isAuthorOfPublication).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, publication1V1, person2V1, this.isAuthorOfPublication).withRightwardValue("Doe, J.").build();
        List mdvs1 = this.itemService.getMetadata((DSpaceObject)publication1V1, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)2L, (long)mdvs1.size());
        Assert.assertTrue((boolean)(mdvs1.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Smith, Donald", (Object)((MetadataValue)mdvs1.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs1.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs1.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Doe, J.", (Object)((MetadataValue)mdvs1.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs1.get(1)).getPlace());
        this.verifySolrField(publication1V1, "dc.contributor.author", List.of("Smith, Donald", "Doe, J."));
        List mdvsR1 = this.itemService.getMetadata((DSpaceObject)publication1V1, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertEquals((long)2L, (long)mdvsR1.size());
        Assert.assertTrue((boolean)(mdvsR1.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person1V1.getID().toString(), (Object)((MetadataValue)mdvsR1.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvsR1.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvsR1.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person2V1.getID().toString(), (Object)((MetadataValue)mdvsR1.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvsR1.get(1)).getPlace());
        this.verifySolrField(publication1V1, "relation.isAuthorOfPublication", List.of(person1V1.getID().toString(), person2V1.getID().toString()));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)publication1V1, "relation", "isAuthorOfPublication", "latestForDiscovery", "*"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person1V1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person2V1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::")))}));
        this.verifySolrField(publication1V1, "relation.isAuthorOfPublication.latestForDiscovery", List.of(person1V1.getID().toString(), person2V1.getID().toString()));
        Item publication1V2 = VersionBuilder.createVersion(this.context, publication1V1, "test").build().getItem();
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, publication1V2));
        this.context.dispatchEvents();
        Item person1V2 = VersionBuilder.createVersion(this.context, person1V1, "test").build().getItem();
        this.itemService.replaceMetadata(this.context, (DSpaceObject)person1V2, "person", "givenName", null, null, "D.", null, -1, 0);
        this.itemService.update(this.context, (DSpaceObject)person1V2);
        this.context.dispatchEvents();
        publication1V1.setMetadataModified();
        publication1V1 = (Item)this.context.reloadEntity((ReloadableEntity)publication1V1);
        publication1V2.setMetadataModified();
        publication1V2 = (Item)this.context.reloadEntity((ReloadableEntity)publication1V2);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1V1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1V1, this.isAuthorOfPublication, person1V1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V1, this.isAuthorOfPublication, person2V1, Relationship.LatestVersionStatus.RIGHT_ONLY, null, "Doe, J.", 1, 0))));
        List mdvs2 = this.itemService.getMetadata((DSpaceObject)publication1V1, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)2L, (long)mdvs2.size());
        Assert.assertTrue((boolean)(mdvs2.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Smith, Donald", (Object)((MetadataValue)mdvs2.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs2.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs2.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Doe, J.", (Object)((MetadataValue)mdvs2.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs2.get(1)).getPlace());
        this.verifySolrField(publication1V1, "dc.contributor.author", List.of("Smith, Donald", "Doe, J."));
        List mdvsR2 = this.itemService.getMetadata((DSpaceObject)publication1V1, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertEquals((long)2L, (long)mdvsR2.size());
        Assert.assertTrue((boolean)(mdvsR2.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person1V1.getID().toString(), (Object)((MetadataValue)mdvsR2.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvsR2.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvsR2.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person2V1.getID().toString(), (Object)((MetadataValue)mdvsR2.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvsR2.get(1)).getPlace());
        this.verifySolrField(publication1V1, "relation.isAuthorOfPublication", List.of(person1V1.getID().toString(), person2V1.getID().toString()));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)publication1V1, "relation", "isAuthorOfPublication", "latestForDiscovery", "*"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[0]));
        this.verifySolrField(publication1V1, "relation.isAuthorOfPublication.latestForDiscovery", null);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1V2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person1V1, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person1V2, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person2V1, Relationship.LatestVersionStatus.BOTH, null, "Doe, J.", 1, 0))));
        List mdvs3 = this.itemService.getMetadata((DSpaceObject)publication1V2, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)2L, (long)mdvs3.size());
        Assert.assertTrue((boolean)(mdvs3.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Smith, Donald", (Object)((MetadataValue)mdvs3.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs3.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs3.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Doe, J.", (Object)((MetadataValue)mdvs3.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs3.get(1)).getPlace());
        this.verifySolrField(publication1V2, "dc.contributor.author", List.of("Smith, Donald", "Doe, J."));
        List mdvsR3 = this.itemService.getMetadata((DSpaceObject)publication1V2, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertEquals((long)2L, (long)mdvsR3.size());
        Assert.assertTrue((boolean)(mdvsR3.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person1V1.getID().toString(), (Object)((MetadataValue)mdvsR3.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvsR3.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvsR3.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person2V1.getID().toString(), (Object)((MetadataValue)mdvsR3.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvsR3.get(1)).getPlace());
        this.verifySolrField(publication1V2, "relation.isAuthorOfPublication", List.of(person1V1.getID().toString(), person2V1.getID().toString()));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)publication1V2, "relation", "isAuthorOfPublication", "latestForDiscovery", "*"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person1V1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person1V2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person2V1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::")))}));
        this.verifySolrField(publication1V2, "relation.isAuthorOfPublication.latestForDiscovery", List.of(person1V1.getID().toString(), person1V2.getID().toString(), person2V1.getID().toString()));
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, person1V2));
        this.context.dispatchEvents();
        publication1V1.setMetadataModified();
        publication1V1 = (Item)this.context.reloadEntity((ReloadableEntity)publication1V1);
        publication1V2.setMetadataModified();
        publication1V2 = (Item)this.context.reloadEntity((ReloadableEntity)publication1V2);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1V1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1V1, this.isAuthorOfPublication, person1V1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V1, this.isAuthorOfPublication, person2V1, Relationship.LatestVersionStatus.RIGHT_ONLY, null, "Doe, J.", 1, 0))));
        List mdvs4 = this.itemService.getMetadata((DSpaceObject)publication1V1, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)2L, (long)mdvs4.size());
        Assert.assertTrue((boolean)(mdvs4.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Smith, Donald", (Object)((MetadataValue)mdvs4.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs4.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs4.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Doe, J.", (Object)((MetadataValue)mdvs4.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs4.get(1)).getPlace());
        this.verifySolrField(publication1V1, "dc.contributor.author", List.of("Smith, Donald", "Doe, J."));
        List mdvsR4 = this.itemService.getMetadata((DSpaceObject)publication1V1, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertEquals((long)2L, (long)mdvsR4.size());
        Assert.assertTrue((boolean)(mdvsR4.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person1V1.getID().toString(), (Object)((MetadataValue)mdvsR4.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvsR4.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvsR4.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person2V1.getID().toString(), (Object)((MetadataValue)mdvsR4.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvsR4.get(1)).getPlace());
        this.verifySolrField(publication1V1, "relation.isAuthorOfPublication", List.of(person1V1.getID().toString(), person2V1.getID().toString()));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)publication1V1, "relation", "isAuthorOfPublication", "latestForDiscovery", "*"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[0]));
        this.verifySolrField(publication1V1, "relation.isAuthorOfPublication.latestForDiscovery", null);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1V2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person1V1, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person1V2, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person2V1, Relationship.LatestVersionStatus.BOTH, null, "Doe, J.", 1, 0))));
        List mdvs5 = this.itemService.getMetadata((DSpaceObject)publication1V2, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)2L, (long)mdvs5.size());
        Assert.assertTrue((boolean)(mdvs5.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Smith, D.", (Object)((MetadataValue)mdvs5.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs5.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs5.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Doe, J.", (Object)((MetadataValue)mdvs5.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs5.get(1)).getPlace());
        this.verifySolrField(publication1V2, "dc.contributor.author", List.of("Smith, D.", "Doe, J."));
        List mdvsR5 = this.itemService.getMetadata((DSpaceObject)publication1V2, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertEquals((long)2L, (long)mdvsR5.size());
        Assert.assertTrue((boolean)(mdvsR5.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person1V2.getID().toString(), (Object)((MetadataValue)mdvsR5.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvsR5.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvsR5.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person2V1.getID().toString(), (Object)((MetadataValue)mdvsR5.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvsR5.get(1)).getPlace());
        this.verifySolrField(publication1V2, "relation.isAuthorOfPublication", List.of(person1V2.getID().toString(), person2V1.getID().toString()));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)publication1V2, "relation", "isAuthorOfPublication", "latestForDiscovery", "*"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person1V1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person1V2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person2V1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::")))}));
        this.verifySolrField(publication1V2, "relation.isAuthorOfPublication.latestForDiscovery", List.of(person1V1.getID().toString(), person1V2.getID().toString(), person2V1.getID().toString()));
        Item person2V2 = VersionBuilder.createVersion(this.context, person2V1, "test").build().getItem();
        Relationship rel1 = this.getRelationship(publication1V2, this.isAuthorOfPublication, person2V2);
        Assert.assertNotNull((Object)rel1);
        rel1.setRightwardValue("Doe, Jane Jr");
        this.relationshipService.update(this.context, (Object)rel1);
        this.context.dispatchEvents();
        publication1V1.setMetadataModified();
        publication1V1 = (Item)this.context.reloadEntity((ReloadableEntity)publication1V1);
        publication1V2.setMetadataModified();
        publication1V2 = (Item)this.context.reloadEntity((ReloadableEntity)publication1V2);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1V1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1V1, this.isAuthorOfPublication, person1V1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V1, this.isAuthorOfPublication, person2V1, Relationship.LatestVersionStatus.RIGHT_ONLY, null, "Doe, J.", 1, 0))));
        List mdvs6 = this.itemService.getMetadata((DSpaceObject)publication1V1, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)2L, (long)mdvs6.size());
        Assert.assertTrue((boolean)(mdvs6.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Smith, Donald", (Object)((MetadataValue)mdvs6.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs6.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs6.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Doe, J.", (Object)((MetadataValue)mdvs6.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs6.get(1)).getPlace());
        this.verifySolrField(publication1V1, "dc.contributor.author", List.of("Smith, Donald", "Doe, J."));
        List mdvsR6 = this.itemService.getMetadata((DSpaceObject)publication1V1, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertEquals((long)2L, (long)mdvsR6.size());
        Assert.assertTrue((boolean)(mdvsR6.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person1V1.getID().toString(), (Object)((MetadataValue)mdvsR6.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvsR6.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvsR6.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person2V1.getID().toString(), (Object)((MetadataValue)mdvsR6.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvsR6.get(1)).getPlace());
        this.verifySolrField(publication1V1, "relation.isAuthorOfPublication", List.of(person1V1.getID().toString(), person2V1.getID().toString()));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)publication1V1, "relation", "isAuthorOfPublication", "latestForDiscovery", "*"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[0]));
        this.verifySolrField(publication1V1, "relation.isAuthorOfPublication.latestForDiscovery", null);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1V2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person1V1, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person1V2, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person2V1, Relationship.LatestVersionStatus.BOTH, null, "Doe, J.", 1, 0), RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person2V2, Relationship.LatestVersionStatus.LEFT_ONLY, null, "Doe, Jane Jr", 1, 0))));
        List mdvs7 = this.itemService.getMetadata((DSpaceObject)publication1V2, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)2L, (long)mdvs7.size());
        Assert.assertTrue((boolean)(mdvs7.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Smith, D.", (Object)((MetadataValue)mdvs7.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs7.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs7.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Doe, J.", (Object)((MetadataValue)mdvs7.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs7.get(1)).getPlace());
        this.verifySolrField(publication1V2, "dc.contributor.author", List.of("Smith, D.", "Doe, J."));
        List mdvsR7 = this.itemService.getMetadata((DSpaceObject)publication1V2, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertEquals((long)2L, (long)mdvsR7.size());
        Assert.assertTrue((boolean)(mdvsR7.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person1V2.getID().toString(), (Object)((MetadataValue)mdvsR7.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvsR7.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvsR7.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person2V1.getID().toString(), (Object)((MetadataValue)mdvsR7.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvsR7.get(1)).getPlace());
        this.verifySolrField(publication1V2, "relation.isAuthorOfPublication", List.of(person1V2.getID().toString(), person2V1.getID().toString()));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)publication1V2, "relation", "isAuthorOfPublication", "latestForDiscovery", "*"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person1V1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person1V2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person2V1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person2V2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::")))}));
        this.verifySolrField(publication1V2, "relation.isAuthorOfPublication.latestForDiscovery", List.of(person1V1.getID().toString(), person1V2.getID().toString(), person2V1.getID().toString(), person2V2.getID().toString()));
        this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.findByItem(this.context, person2V2));
        this.context.dispatchEvents();
        publication1V1.setMetadataModified();
        publication1V1 = (Item)this.context.reloadEntity((ReloadableEntity)publication1V1);
        publication1V2.setMetadataModified();
        publication1V2 = (Item)this.context.reloadEntity((ReloadableEntity)publication1V2);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1V1, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1V1, this.isAuthorOfPublication, person1V1, Relationship.LatestVersionStatus.RIGHT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V1, this.isAuthorOfPublication, person2V1, Relationship.LatestVersionStatus.RIGHT_ONLY, null, "Doe, J.", 1, 0))));
        List mdvs8 = this.itemService.getMetadata((DSpaceObject)publication1V1, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)2L, (long)mdvs8.size());
        Assert.assertTrue((boolean)(mdvs8.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Smith, Donald", (Object)((MetadataValue)mdvs8.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs8.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs8.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Doe, J.", (Object)((MetadataValue)mdvs8.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs8.get(1)).getPlace());
        this.verifySolrField(publication1V1, "dc.contributor.author", List.of("Smith, Donald", "Doe, J."));
        List mdvsR8 = this.itemService.getMetadata((DSpaceObject)publication1V1, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertEquals((long)2L, (long)mdvsR8.size());
        Assert.assertTrue((boolean)(mdvsR8.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person1V1.getID().toString(), (Object)((MetadataValue)mdvsR8.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvsR8.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvsR8.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person2V1.getID().toString(), (Object)((MetadataValue)mdvsR8.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvsR8.get(1)).getPlace());
        this.verifySolrField(publication1V1, "relation.isAuthorOfPublication", List.of(person1V1.getID().toString(), person2V1.getID().toString()));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)publication1V1, "relation", "isAuthorOfPublication", "latestForDiscovery", "*"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[0]));
        this.verifySolrField(publication1V1, "relation.isAuthorOfPublication.latestForDiscovery", null);
        MatcherAssert.assertThat((Object)this.relationshipService.findByItem(this.context, publication1V2, Integer.valueOf(-1), Integer.valueOf(-1), false, false), (Matcher)Matchers.containsInAnyOrder(List.of(RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person1V1, Relationship.LatestVersionStatus.LEFT_ONLY, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person1V2, Relationship.LatestVersionStatus.BOTH, 0, 0), RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person2V1, Relationship.LatestVersionStatus.LEFT_ONLY, null, "Doe, J.", 1, 0), RelationshipVersioningTestUtils.isRel(publication1V2, this.isAuthorOfPublication, person2V2, Relationship.LatestVersionStatus.BOTH, null, "Doe, Jane Jr", 1, 0))));
        List mdvs9 = this.itemService.getMetadata((DSpaceObject)publication1V2, "dc", "contributor", "author", "*");
        Assert.assertEquals((long)2L, (long)mdvs9.size());
        Assert.assertTrue((boolean)(mdvs9.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Smith, D.", (Object)((MetadataValue)mdvs9.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvs9.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvs9.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)"Doe, Jane Jr", (Object)((MetadataValue)mdvs9.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvs9.get(1)).getPlace());
        this.verifySolrField(publication1V2, "dc.contributor.author", List.of("Smith, D.", "Doe, Jane Jr"));
        List mdvsR9 = this.itemService.getMetadata((DSpaceObject)publication1V2, "relation", "isAuthorOfPublication", null, "*");
        Assert.assertEquals((long)2L, (long)mdvsR9.size());
        Assert.assertTrue((boolean)(mdvsR9.get(0) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person1V2.getID().toString(), (Object)((MetadataValue)mdvsR9.get(0)).getValue());
        Assert.assertEquals((long)0L, (long)((MetadataValue)mdvsR9.get(0)).getPlace());
        Assert.assertTrue((boolean)(mdvsR9.get(1) instanceof RelationshipMetadataValue));
        Assert.assertEquals((Object)person2V2.getID().toString(), (Object)((MetadataValue)mdvsR9.get(1)).getValue());
        Assert.assertEquals((long)1L, (long)((MetadataValue)mdvsR9.get(1)).getPlace());
        this.verifySolrField(publication1V2, "relation.isAuthorOfPublication", List.of(person1V2.getID().toString(), person2V2.getID().toString()));
        MatcherAssert.assertThat((Object)this.itemService.getMetadata((DSpaceObject)publication1V2, "relation", "isAuthorOfPublication", "latestForDiscovery", "*"), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person1V1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person1V2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person2V1.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::"))), Matchers.allOf((Matcher)Matchers.instanceOf(RelationshipMetadataValue.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)CoreMatchers.is((Object)person2V2.getID().toString())), (Matcher)Matchers.hasProperty((String)"place", (Matcher)CoreMatchers.is((Object)-1)), (Matcher)Matchers.hasProperty((String)"authority", (Matcher)CoreMatchers.startsWith((String)"virtual::")))}));
        this.verifySolrField(publication1V2, "relation.isAuthorOfPublication.latestForDiscovery", List.of(person1V1.getID().toString(), person1V2.getID().toString(), person2V1.getID().toString(), person2V2.getID().toString()));
    }
}

