/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import jakarta.mail.MessagingException;
import java.io.IOException;
import org.dspace.AbstractDSpaceTest;
import org.dspace.core.Email;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class EmailTest
extends AbstractDSpaceTest {
    private ConfigurationService config;

    @Before
    public void init_test() {
        this.config = kernelImpl.getConfigurationService();
    }

    @Test
    public void testNullParameter() throws MessagingException, IOException {
        this.config.setProperty("mail.server.disabled", (Object)"true");
        Email email = new Email();
        email.setContent("null test", "Testing: parameter value is /${params[0]}/.");
        email.addArgument(null);
        email.build();
        String message = email.getMessage();
        MatcherAssert.assertThat((String)"Null message parameter should be transformed to empty", (Object)message, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"(null)")));
    }

    @Test
    public void testNotNullParameter() throws MessagingException, IOException {
        this.config.setProperty("mail.server.disabled", (Object)"true");
        Email email = new Email();
        email.setContent("not-null test", "Testing: parameter value is /${params[0]}/.");
        String testParam = "axolotl";
        email.addArgument((Object)testParam);
        email.build();
        String message = email.getMessage();
        MatcherAssert.assertThat((String)"Null message parameter should be transformed to empty", (Object)message, (Matcher)Matchers.containsString((String)testParam));
    }
}

