/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.sql.SQLException;
import org.dspace.AbstractUnitTest;
import org.dspace.core.HibernateDBConnection;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.utils.DSpace;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HibernateDBConnectionTest
extends AbstractUnitTest {
    private HibernateDBConnection connection;

    @Override
    @Before
    public void init() {
        super.init();
        this.connection = (HibernateDBConnection)new DSpace().getServiceManager().getServiceByName(null, HibernateDBConnection.class);
    }

    @Test
    public void testGetSession() throws SQLException {
        Assert.assertNotNull((String)"DB connection should not be null", (Object)this.connection);
        Assert.assertTrue((String)"A transaction should be open by default", (boolean)this.connection.getTransaction().isActive());
        this.connection.getTransaction().rollback();
        Assert.assertFalse((String)"Transaction should be closed after rollback", (boolean)this.connection.getTransaction().isActive());
        Session currentSession = this.connection.getSession();
        Assert.assertTrue((String)"New transaction should be open after getSession() call", (boolean)this.connection.getTransaction().isActive());
        Assert.assertEquals((String)"Multiple calls to getSession should return same Session", (Object)currentSession, (Object)this.connection.getSession());
    }

    @Test
    public void testIsTransactionAlive() {
        Assert.assertNotNull((String)"DB connection should not be null", (Object)this.connection);
        Assert.assertNotNull((String)"Transaction should not be null", (Object)this.connection.getTransaction());
        Assert.assertTrue((String)"A transaction should be open by default", (boolean)this.connection.isTransActionAlive());
        this.connection.getTransaction().rollback();
        Assert.assertFalse((String)"Transaction should be closed after rollback", (boolean)this.connection.isTransActionAlive());
    }

    @Test
    public void testIsSessionAlive() throws SQLException {
        Assert.assertNotNull((String)"DB connection should not be null", (Object)this.connection);
        Assert.assertNotNull((String)"Session should not be null", (Object)this.connection.getSession());
        Assert.assertTrue((String)"A Session should be alive by default", (boolean)this.connection.isSessionAlive());
        this.connection.getTransaction().rollback();
        Assert.assertTrue((String)"A Session should still be alive if transaction closes", (boolean)this.connection.isSessionAlive());
    }

    @Test
    public void testCloseDBConnection() throws SQLException {
        Session initialSession = this.connection.getSession();
        this.connection.closeDBConnection();
        Session newSession = this.connection.getSession();
        Assert.assertNotEquals((String)"New Session expected", (Object)initialSession, (Object)newSession);
    }

    @Test
    public void testCommit() throws SQLException {
        this.connection.getSession();
        Assert.assertTrue((String)"Transaction should be active", (boolean)this.connection.getTransaction().isActive());
        this.connection.commit();
        Assert.assertFalse((String)"Commit should close transaction", (boolean)this.connection.getTransaction().isActive());
        this.connection.commit();
    }

    @Test
    public void testRollback() throws SQLException {
        this.connection.getSession();
        Assert.assertTrue((String)"Transaction should be active", (boolean)this.connection.getTransaction().isActive());
        this.connection.rollback();
        Assert.assertFalse((String)"Rollback should close transaction", (boolean)this.connection.getTransaction().isActive());
        this.connection.rollback();
    }

    @Test
    public void testReloadEntityAfterRollback() throws SQLException {
        HibernateDBConnection dbConnection = (HibernateDBConnection)this.context.getDBConnection();
        EPerson person = this.context.getCurrentUser();
        Assert.assertTrue((String)"Current user should be cached in session", (boolean)dbConnection.getSession().contains((Object)person));
        dbConnection.rollback();
        Assert.assertFalse((String)"Current user should be gone from cache", (boolean)dbConnection.getSession().contains((Object)person));
        person = (EPerson)dbConnection.reloadEntity((ReloadableEntity)person);
        Assert.assertTrue((String)"Current user should be cached back in session", (boolean)dbConnection.getSession().contains((Object)person));
    }

    @Test
    public void testReloadEntityAfterCommit() throws SQLException {
        HibernateDBConnection dbConnection = (HibernateDBConnection)this.context.getDBConnection();
        EPerson person = this.context.getCurrentUser();
        Assert.assertTrue((String)"Current user should be cached in session", (boolean)dbConnection.getSession().contains((Object)person));
        dbConnection.commit();
        Assert.assertFalse((String)"Current user should be gone from cache", (boolean)dbConnection.getSession().contains((Object)person));
        person = (EPerson)dbConnection.reloadEntity((ReloadableEntity)person);
        Assert.assertTrue((String)"Current user should be cached back in session", (boolean)dbConnection.getSession().contains((Object)person));
    }

    @Test
    public void testUncacheEntities() throws SQLException {
        HibernateDBConnection dbConnection = (HibernateDBConnection)this.context.getDBConnection();
        EPerson person = this.context.getCurrentUser();
        Assert.assertTrue((String)"Current user should be cached in session", (boolean)dbConnection.getSession().contains((Object)person));
        dbConnection.uncacheEntities();
        Assert.assertFalse((String)"Current user should be gone from cache", (boolean)dbConnection.getSession().contains((Object)person));
        person = (EPerson)dbConnection.reloadEntity((ReloadableEntity)person);
        Assert.assertTrue((String)"Current user should be cached back in session", (boolean)dbConnection.getSession().contains((Object)person));
    }

    @Test
    public void testUncacheEntity() throws SQLException {
        HibernateDBConnection dbConnection = (HibernateDBConnection)this.context.getDBConnection();
        EPerson person = this.context.getCurrentUser();
        Assert.assertTrue((String)"Current user should be cached in session", (boolean)dbConnection.getSession().contains((Object)person));
        dbConnection.uncacheEntity((ReloadableEntity)person);
        Assert.assertFalse((String)"Current user should be gone from cache", (boolean)dbConnection.getSession().contains((Object)person));
        person = (EPerson)dbConnection.reloadEntity((ReloadableEntity)person);
        Assert.assertTrue((String)"Current user should be cached back in session", (boolean)dbConnection.getSession().contains((Object)person));
    }
}

