/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.codec.binary.StringUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.matcher.LambdaMatcher;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.OrcidTokenBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.impl.OrcidPublicationDataProvider;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.client.OrcidConfiguration;
import org.dspace.orcid.model.OrcidTokenResponseDTO;
import org.dspace.utils.DSpace;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.orcid.jaxb.model.v3.release.record.Work;
import org.orcid.jaxb.model.v3.release.record.WorkBulk;
import org.orcid.jaxb.model.v3.release.record.summary.Works;

public class OrcidPublicationDataProviderIT
extends AbstractIntegrationTestWithDatabase {
    private static final String BASE_XML_DIR_PATH = "org/dspace/app/orcid-works/";
    private static final String ACCESS_TOKEN = "32c83ccb-c6d5-4981-b6ea-6a34a36de8ab";
    private static final String ORCID = "0000-1111-2222-3333";
    private OrcidPublicationDataProvider dataProvider;
    private OrcidConfiguration orcidConfiguration;
    private OrcidClient orcidClient;
    private OrcidClient orcidClientMock;
    private String originalClientId;
    private Collection persons;

    @Before
    public void setup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.persons = CollectionBuilder.createCollection(this.context, this.parentCommunity).withEntityType("Person").withName("Profiles").build();
        this.context.restoreAuthSystemState();
        this.dataProvider = (OrcidPublicationDataProvider)new DSpace().getServiceManager().getServiceByName("orcidPublicationDataProvider", OrcidPublicationDataProvider.class);
        this.orcidConfiguration = (OrcidConfiguration)new DSpace().getServiceManager().getServiceByName("org.dspace.orcid.client.OrcidConfiguration", OrcidConfiguration.class);
        this.orcidClientMock = (OrcidClient)Mockito.mock(OrcidClient.class);
        this.orcidClient = this.dataProvider.getOrcidClient();
        this.dataProvider.setReadPublicAccessToken(null);
        this.dataProvider.setOrcidClient(this.orcidClientMock);
        this.originalClientId = this.orcidConfiguration.getClientId();
        this.orcidConfiguration.setClientId("DSPACE-CLIENT-ID");
        this.orcidConfiguration.setClientSecret("DSPACE-CLIENT-SECRET");
        Mockito.when((Object)this.orcidClientMock.getReadPublicAccessToken()).thenReturn((Object)this.buildTokenResponse(ACCESS_TOKEN));
        Mockito.when((Object)this.orcidClientMock.getWorks((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)ORCID))).thenReturn((Object)this.unmarshall("works.xml", Works.class));
        Mockito.when((Object)this.orcidClientMock.getWorks((String)ArgumentMatchers.eq((Object)ORCID))).thenReturn((Object)this.unmarshall("works.xml", Works.class));
        Mockito.when((Object)this.orcidClientMock.getObject((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)ORCID), (String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(Work.class))).then(invocation -> Optional.of(this.unmarshall("work-" + invocation.getArgument(2) + ".xml", Work.class)));
        Mockito.when((Object)this.orcidClientMock.getObject((String)ArgumentMatchers.eq((Object)ORCID), (String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(Work.class))).then(invocation -> Optional.of(this.unmarshall("work-" + invocation.getArgument(1) + ".xml", Work.class)));
        Mockito.when((Object)this.orcidClientMock.getWorkBulk((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)ORCID), (List)ArgumentMatchers.any())).then(invocation -> this.unmarshallWorkBulk((List)invocation.getArgument(2)));
        Mockito.when((Object)this.orcidClientMock.getWorkBulk((String)ArgumentMatchers.eq((Object)ORCID), (List)ArgumentMatchers.any())).then(invocation -> this.unmarshallWorkBulk((List)invocation.getArgument(1)));
    }

    @After
    public void after() {
        this.dataProvider.setOrcidClient(this.orcidClient);
        this.orcidConfiguration.setClientId(this.originalClientId);
    }

    @Test
    public void testSearchWithoutPagination() throws Exception {
        List externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 0, -1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)3));
        ExternalDataObject firstObject = (ExternalDataObject)externalObjects.get(0);
        MatcherAssert.assertThat((Object)firstObject.getDisplayValue(), (Matcher)Matchers.is((Object)"The elements of style and the survey of ophthalmology."));
        MatcherAssert.assertThat((Object)firstObject.getValue(), (Matcher)Matchers.is((Object)"The elements of style and the survey of ophthalmology."));
        MatcherAssert.assertThat((Object)firstObject.getId(), (Matcher)Matchers.is((Object)"0000-1111-2222-3333::277904"));
        MatcherAssert.assertThat((Object)firstObject.getSource(), (Matcher)Matchers.is((Object)"orcidWorks"));
        List metadata = firstObject.getMetadata();
        MatcherAssert.assertThat((Object)metadata, (Matcher)Matchers.hasSize((int)7));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.date.issued", "2011")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.source", "Test Journal")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.language.iso", "it")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.type", "Other")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.identifier.doi", "10.11234.12")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.contributor.author", "Walter White")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.title", "The elements of style and the survey of ophthalmology.")));
        ExternalDataObject secondObject = (ExternalDataObject)externalObjects.get(1);
        MatcherAssert.assertThat((Object)secondObject.getDisplayValue(), (Matcher)Matchers.is((Object)"Another cautionary tale."));
        MatcherAssert.assertThat((Object)secondObject.getValue(), (Matcher)Matchers.is((Object)"Another cautionary tale."));
        MatcherAssert.assertThat((Object)secondObject.getId(), (Matcher)Matchers.is((Object)"0000-1111-2222-3333::277902"));
        MatcherAssert.assertThat((Object)secondObject.getSource(), (Matcher)Matchers.is((Object)"orcidWorks"));
        metadata = secondObject.getMetadata();
        MatcherAssert.assertThat((Object)metadata, (Matcher)Matchers.hasSize((int)8));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.date.issued", "2011-05-01")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.description.abstract", "Short description")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.relation.ispartof", "Journal title")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.contributor.author", "Walter White")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.contributor.author", "John White")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.contributor.editor", "Jesse Pinkman")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.title", "Another cautionary tale.")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.type", "Article")));
        ExternalDataObject thirdObject = (ExternalDataObject)externalObjects.get(2);
        MatcherAssert.assertThat((Object)thirdObject.getDisplayValue(), (Matcher)Matchers.is((Object)"Branch artery occlusion in a young woman."));
        MatcherAssert.assertThat((Object)thirdObject.getValue(), (Matcher)Matchers.is((Object)"Branch artery occlusion in a young woman."));
        MatcherAssert.assertThat((Object)thirdObject.getId(), (Matcher)Matchers.is((Object)"0000-1111-2222-3333::277871"));
        MatcherAssert.assertThat((Object)thirdObject.getSource(), (Matcher)Matchers.is((Object)"orcidWorks"));
        metadata = thirdObject.getMetadata();
        MatcherAssert.assertThat((Object)metadata, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.date.issued", "1985-07-01")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.title", "Branch artery occlusion in a young woman.")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.type", "Article")));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getReadPublicAccessToken();
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorks(ACCESS_TOKEN, ORCID);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorkBulk(ACCESS_TOKEN, ORCID, List.of("277904", "277902", "277871"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testSearchWithInvalidOrcidId() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.dataProvider.searchExternalDataObjects("0000-1111-2222", 0, -1));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"The given ORCID ID is not valid: 0000-1111-2222"));
    }

    @Test
    public void testSearchWithStoredAccessToken() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String accessToken = "95cb5ed9-c208-4bbc-bc99-aa0bd76e4452";
        Item profile = ItemBuilder.createItem(this.context, this.persons).withTitle("Profile").withOrcidIdentifier(ORCID).withDspaceObjectOwner(this.eperson.getEmail(), this.eperson.getID().toString()).build();
        OrcidTokenBuilder.create(this.context, this.eperson, accessToken).withProfileItem(profile).build();
        this.context.restoreAuthSystemState();
        List externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 0, -1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)3));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorks(accessToken, ORCID);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorkBulk(accessToken, ORCID, List.of("277904", "277902", "277871"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testSearchWithProfileWithoutAccessToken() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ItemBuilder.createItem(this.context, this.persons).withTitle("Profile").withOrcidIdentifier(ORCID).build();
        this.context.restoreAuthSystemState();
        List externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 0, -1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)3));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getReadPublicAccessToken();
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorks(ACCESS_TOKEN, ORCID);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorkBulk(ACCESS_TOKEN, ORCID, List.of("277904", "277902", "277871"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testSearchWithoutResults() throws Exception {
        String unknownOrcid = "1111-2222-3333-4444";
        Mockito.when((Object)this.orcidClientMock.getWorks(ACCESS_TOKEN, unknownOrcid)).thenReturn((Object)new Works());
        List externalObjects = this.dataProvider.searchExternalDataObjects(unknownOrcid, 0, -1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.empty());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getReadPublicAccessToken();
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorks(ACCESS_TOKEN, unknownOrcid);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testClientCredentialsTokenCache() throws Exception {
        List externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 0, -1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)3));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getReadPublicAccessToken();
        externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 0, -1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)3));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)1))).getReadPublicAccessToken();
        this.dataProvider.setReadPublicAccessToken(null);
        externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 0, -1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)3));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)2))).getReadPublicAccessToken();
    }

    @Test
    public void testSearchPagination() throws Exception {
        List externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 0, -1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)externalObjects, LambdaMatcher.has(externalObject -> externalObject.getId().equals("0000-1111-2222-3333::277904")));
        MatcherAssert.assertThat((Object)externalObjects, LambdaMatcher.has(externalObject -> externalObject.getId().equals("0000-1111-2222-3333::277902")));
        MatcherAssert.assertThat((Object)externalObjects, LambdaMatcher.has(externalObject -> externalObject.getId().equals("0000-1111-2222-3333::277871")));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getReadPublicAccessToken();
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorks(ACCESS_TOKEN, ORCID);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorkBulk(ACCESS_TOKEN, ORCID, List.of("277904", "277902", "277871"));
        externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 0, 5);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)externalObjects, LambdaMatcher.has(externalObject -> externalObject.getId().equals("0000-1111-2222-3333::277904")));
        MatcherAssert.assertThat((Object)externalObjects, LambdaMatcher.has(externalObject -> externalObject.getId().equals("0000-1111-2222-3333::277902")));
        MatcherAssert.assertThat((Object)externalObjects, LambdaMatcher.has(externalObject -> externalObject.getId().equals("0000-1111-2222-3333::277871")));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)2))).getWorks(ACCESS_TOKEN, ORCID);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)2))).getWorkBulk(ACCESS_TOKEN, ORCID, List.of("277904", "277902", "277871"));
        externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 0, 2);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)externalObjects, LambdaMatcher.has(externalObject -> externalObject.getId().equals("0000-1111-2222-3333::277904")));
        MatcherAssert.assertThat((Object)externalObjects, LambdaMatcher.has(externalObject -> externalObject.getId().equals("0000-1111-2222-3333::277902")));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)3))).getWorks(ACCESS_TOKEN, ORCID);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorkBulk(ACCESS_TOKEN, ORCID, List.of("277904", "277902"));
        externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 1, 1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)externalObjects, LambdaMatcher.has(externalObject -> externalObject.getId().equals("0000-1111-2222-3333::277902")));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)4))).getWorks(ACCESS_TOKEN, ORCID);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getObject(ACCESS_TOKEN, ORCID, "277902", Work.class);
        externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 2, 1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)externalObjects, LambdaMatcher.has(externalObject -> externalObject.getId().equals("0000-1111-2222-3333::277871")));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock, (VerificationMode)Mockito.times((int)5))).getWorks(ACCESS_TOKEN, ORCID);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getObject(ACCESS_TOKEN, ORCID, "277871", Work.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testGetExternalDataObject() {
        Optional optional = this.dataProvider.getExternalDataObject("0000-1111-2222-3333::277902");
        MatcherAssert.assertThat((Object)optional.isPresent(), (Matcher)Matchers.is((Object)true));
        ExternalDataObject externalDataObject = (ExternalDataObject)optional.get();
        MatcherAssert.assertThat((Object)externalDataObject.getDisplayValue(), (Matcher)Matchers.is((Object)"Another cautionary tale."));
        MatcherAssert.assertThat((Object)externalDataObject.getValue(), (Matcher)Matchers.is((Object)"Another cautionary tale."));
        MatcherAssert.assertThat((Object)externalDataObject.getId(), (Matcher)Matchers.is((Object)"0000-1111-2222-3333::277902"));
        MatcherAssert.assertThat((Object)externalDataObject.getSource(), (Matcher)Matchers.is((Object)"orcidWorks"));
        List metadata = externalDataObject.getMetadata();
        MatcherAssert.assertThat((Object)metadata, (Matcher)Matchers.hasSize((int)8));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.date.issued", "2011-05-01")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.description.abstract", "Short description")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.relation.ispartof", "Journal title")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.contributor.author", "Walter White")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.contributor.author", "John White")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.contributor.editor", "Jesse Pinkman")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.title", "Another cautionary tale.")));
        MatcherAssert.assertThat((Object)metadata, LambdaMatcher.has(this.metadata("dc.type", "Article")));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getReadPublicAccessToken();
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getObject(ACCESS_TOKEN, ORCID, "277902", Work.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testGetExternalDataObjectWithInvalidOrcidId() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.dataProvider.getExternalDataObject("invalid::277902"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"The given ORCID ID is not valid: invalid"));
    }

    @Test
    public void testGetExternalDataObjectWithInvalidId() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.dataProvider.getExternalDataObject("id"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"Invalid identifier 'id', expected <orcid-id>::<put-code>"));
    }

    @Test
    public void testSearchWithoutApiKeysConfigured() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.orcidConfiguration.setClientSecret(null);
        ItemBuilder.createItem(this.context, this.persons).withTitle("Profile").withOrcidIdentifier(ORCID).build();
        this.context.restoreAuthSystemState();
        List externalObjects = this.dataProvider.searchExternalDataObjects(ORCID, 0, -1);
        MatcherAssert.assertThat((Object)externalObjects, (Matcher)Matchers.hasSize((int)3));
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorks(ORCID);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).getWorkBulk(ORCID, List.of("277904", "277902", "277871"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    private Predicate<MetadataValueDTO> metadata(String metadataField, String value) {
        MetadataFieldName metadataFieldName = new MetadataFieldName(metadataField);
        return this.metadata(metadataFieldName.schema, metadataFieldName.element, metadataFieldName.qualifier, value);
    }

    private Predicate<MetadataValueDTO> metadata(String schema, String element, String qualifier, String value) {
        return dto -> StringUtils.equals((CharSequence)schema, (CharSequence)dto.getSchema()) && StringUtils.equals((CharSequence)element, (CharSequence)dto.getElement()) && StringUtils.equals((CharSequence)qualifier, (CharSequence)dto.getQualifier()) && StringUtils.equals((CharSequence)value, (CharSequence)dto.getValue());
    }

    private OrcidTokenResponseDTO buildTokenResponse(String accessToken) {
        OrcidTokenResponseDTO response = new OrcidTokenResponseDTO();
        response.setAccessToken(accessToken);
        return response;
    }

    private WorkBulk unmarshallWorkBulk(List<String> putCodes) throws Exception {
        return this.unmarshall("workBulk-" + String.join((CharSequence)"-", putCodes) + ".xml", WorkBulk.class);
    }

    private <T> T unmarshall(String fileName, Class<T> clazz) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        URL resource = this.getClass().getClassLoader().getResource(BASE_XML_DIR_PATH + fileName);
        if (resource == null) {
            throw new IllegalStateException("No resource found named org/dspace/app/orcid-works/" + fileName);
        }
        return (T)unmarshaller.unmarshal(new File(resource.getFile()));
    }
}

