/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google.client;

import java.util.List;
import org.dspace.google.GoogleAnalyticsEvent;
import org.dspace.google.client.GoogleAnalytics4ClientRequestBuilder;
import org.dspace.google.client.GoogleAnalyticsClientException;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class GoogleAnalytics4ClientRequestBuilderTest {
    private GoogleAnalytics4ClientRequestBuilder requestBuilder;
    private ConfigurationService configurationService = (ConfigurationService)Mockito.mock(ConfigurationService.class);

    @Before
    public void setup() {
        this.requestBuilder = new GoogleAnalytics4ClientRequestBuilder("https://google-analytics/test");
        this.requestBuilder.setConfigurationService(this.configurationService);
    }

    @Test
    public void testGetEndpointUrl() {
        Mockito.when((Object)this.configurationService.getProperty("google.analytics.api-secret")).thenReturn((Object)"abc123");
        String endpointUrl = this.requestBuilder.getEndpointUrl("G-12345");
        MatcherAssert.assertThat((Object)endpointUrl, (Matcher)Matchers.is((Object)"https://google-analytics/test?api_secret=abc123&measurement_id=G-12345"));
    }

    @Test
    public void testGetEndpointUrlWithNotSupportedKey() {
        Assert.assertThrows((String)"Only keys with G- prefix are supported", IllegalArgumentException.class, () -> this.requestBuilder.getEndpointUrl("UA-12345"));
    }

    @Test
    public void testGetEndpointUrlWithoutApiSecretConfigured() {
        Assert.assertThrows((String)"The API secret must be configured to sent GA4 events", GoogleAnalyticsClientException.class, () -> this.requestBuilder.getEndpointUrl("G-12345"));
    }

    @Test
    public void testComposeRequestBodiesWithoutEvents() {
        List requestsBody = this.requestBuilder.composeRequestsBody("G-12345", List.of());
        MatcherAssert.assertThat((Object)requestsBody, (Matcher)Matchers.empty());
    }

    @Test
    public void testComposeRequestBodiesWithSingleEvent() {
        GoogleAnalyticsEvent event = this.buildEvent("123", "192.168.1.25", "Chrome", "REF", "/api/documents/123", "Test publication");
        List requestsBody = this.requestBuilder.composeRequestsBody("G-12345", List.of(event));
        MatcherAssert.assertThat((Object)requestsBody, (Matcher)Matchers.hasSize((int)1));
        JSONObject requestBody = new JSONObject((String)requestsBody.get(0));
        MatcherAssert.assertThat((Object)requestBody.get("client_id"), (Matcher)Matchers.is((Object)"123"));
        JSONArray eventsArray = requestBody.getJSONArray("events");
        MatcherAssert.assertThat((Object)eventsArray.length(), (Matcher)Matchers.is((Object)1));
        this.assertEventJsonHasAttributes(eventsArray.getJSONObject(0), "item", "download", "bitstream", "192.168.1.25", "Chrome", "REF", "/api/documents/123", "Test publication");
    }

    @Test
    public void testComposeRequestBodiesWithManyEventsWithSameClientId() {
        GoogleAnalyticsEvent event1 = this.buildEvent("123", "192.168.1.25", "Chrome", "REF", "/api/documents/123", "Test publication");
        GoogleAnalyticsEvent event2 = this.buildEvent("123", "192.168.1.25", "Mozilla Firefox", "REF-2", "/api/documents/12345", "Test publication 2");
        List requestsBody = this.requestBuilder.composeRequestsBody("G-12345", List.of(event1, event2));
        MatcherAssert.assertThat((Object)requestsBody, (Matcher)Matchers.hasSize((int)1));
        JSONObject requestBody = new JSONObject((String)requestsBody.get(0));
        MatcherAssert.assertThat((Object)requestBody.get("client_id"), (Matcher)Matchers.is((Object)"123"));
        JSONArray eventsArray = requestBody.getJSONArray("events");
        MatcherAssert.assertThat((Object)eventsArray.length(), (Matcher)Matchers.is((Object)2));
        JSONObject eventJson1 = this.findEventJsonByDocumentTitle(eventsArray, "Test publication");
        JSONObject eventJson2 = this.findEventJsonByDocumentTitle(eventsArray, "Test publication 2");
        MatcherAssert.assertThat((Object)eventJson1, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)eventJson2, (Matcher)Matchers.notNullValue());
        this.assertEventJsonHasAttributes(eventJson1, "item", "download", "bitstream", "192.168.1.25", "Chrome", "REF", "/api/documents/123", "Test publication");
        this.assertEventJsonHasAttributes(eventJson2, "item", "download", "bitstream", "192.168.1.25", "Mozilla Firefox", "REF-2", "/api/documents/12345", "Test publication 2");
    }

    @Test
    public void testComposeRequestBodiesWithManyEventsWithDifferentClientId() {
        GoogleAnalyticsEvent event1 = this.buildEvent("123", "192.168.1.25", "Chrome", "REF", "/api/documents/123", "Test publication");
        GoogleAnalyticsEvent event2 = this.buildEvent("123", "192.168.1.25", "Mozilla Firefox", "REF-2", "/api/documents/12345", "Test publication 2");
        GoogleAnalyticsEvent event3 = this.buildEvent("987", "192.168.1.13", "Postman", null, "/api/documents/654", "Test publication 3");
        List requestsBody = this.requestBuilder.composeRequestsBody("G-12345", List.of(event1, event2, event3));
        MatcherAssert.assertThat((Object)requestsBody, (Matcher)Matchers.hasSize((int)2));
        JSONObject firstRequestBody = this.findRequestBodyByClientId(requestsBody, "123");
        MatcherAssert.assertThat((Object)firstRequestBody.get("client_id"), (Matcher)Matchers.is((Object)"123"));
        JSONArray firstEventsArray = firstRequestBody.getJSONArray("events");
        MatcherAssert.assertThat((Object)firstEventsArray.length(), (Matcher)Matchers.is((Object)2));
        JSONObject eventJson1 = this.findEventJsonByDocumentTitle(firstEventsArray, "Test publication");
        JSONObject eventJson2 = this.findEventJsonByDocumentTitle(firstEventsArray, "Test publication 2");
        MatcherAssert.assertThat((Object)eventJson1, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)eventJson2, (Matcher)Matchers.notNullValue());
        this.assertEventJsonHasAttributes(eventJson1, "item", "download", "bitstream", "192.168.1.25", "Chrome", "REF", "/api/documents/123", "Test publication");
        this.assertEventJsonHasAttributes(eventJson2, "item", "download", "bitstream", "192.168.1.25", "Mozilla Firefox", "REF-2", "/api/documents/12345", "Test publication 2");
        JSONObject secondRequestBody = this.findRequestBodyByClientId(requestsBody, "987");
        MatcherAssert.assertThat((Object)secondRequestBody.get("client_id"), (Matcher)Matchers.is((Object)"987"));
        JSONArray secondEventsArray = secondRequestBody.getJSONArray("events");
        MatcherAssert.assertThat((Object)secondEventsArray.length(), (Matcher)Matchers.is((Object)1));
        this.assertEventJsonHasAttributes(secondEventsArray.getJSONObject(0), "item", "download", "bitstream", "192.168.1.13", "Postman", "", "/api/documents/654", "Test publication 3");
    }

    private void assertEventJsonHasAttributes(JSONObject event, String name, String action, String category, String userIp, String userAgent, String documentReferrer, String documentPath, String documentTitle) {
        MatcherAssert.assertThat((Object)event.get("name"), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)event.getJSONObject("params"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)event.getJSONObject("params").get("action"), (Matcher)Matchers.is((Object)action));
        MatcherAssert.assertThat((Object)event.getJSONObject("params").get("category"), (Matcher)Matchers.is((Object)category));
        MatcherAssert.assertThat((Object)event.getJSONObject("params").get("document_title"), (Matcher)Matchers.is((Object)documentTitle));
        MatcherAssert.assertThat((Object)event.getJSONObject("params").get("user_ip"), (Matcher)Matchers.is((Object)userIp));
        MatcherAssert.assertThat((Object)event.getJSONObject("params").get("user_agent"), (Matcher)Matchers.is((Object)userAgent));
        MatcherAssert.assertThat((Object)event.getJSONObject("params").get("document_referrer"), (Matcher)Matchers.is((Object)documentReferrer));
        MatcherAssert.assertThat((Object)event.getJSONObject("params").get("document_path"), (Matcher)Matchers.is((Object)documentPath));
        MatcherAssert.assertThat((Object)event.getJSONObject("params").get("time"), (Matcher)Matchers.notNullValue());
    }

    private JSONObject findRequestBodyByClientId(List<String> requestsBody, String clientId) {
        for (String requestBody : requestsBody) {
            JSONObject requestBodyJson = new JSONObject(requestBody);
            if (!requestBodyJson.get("client_id").equals(clientId)) continue;
            return requestBodyJson;
        }
        return null;
    }

    private JSONObject findEventJsonByDocumentTitle(JSONArray events, String documentTitle) {
        for (int i = 0; i < events.length(); ++i) {
            JSONObject event = events.getJSONObject(i);
            MatcherAssert.assertThat((Object)event.getJSONObject("params"), (Matcher)Matchers.notNullValue());
            if (!event.getJSONObject("params").get("document_title").equals(documentTitle)) continue;
            return event;
        }
        return null;
    }

    private GoogleAnalyticsEvent buildEvent(String clientId, String userIp, String userAgent, String documentReferrer, String documentPath, String documentTitle) {
        return new GoogleAnalyticsEvent(clientId, userIp, userAgent, documentReferrer, documentPath, documentTitle);
    }
}

