/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.license;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dspace.license.CCLicense;
import org.dspace.license.CCLicenseConnectorServiceImpl;
import org.dspace.license.CCLicenseField;
import org.dspace.license.CCLicenseFieldEnum;
import org.jdom2.Document;

public class MockCCLicenseConnectorServiceImpl
extends CCLicenseConnectorServiceImpl {
    public Map<String, CCLicense> retrieveLicenses(String language) {
        HashMap<String, CCLicense> ccLicenses = new HashMap<String, CCLicense>();
        CCLicense mockLicense1 = this.createMockLicense(1, new int[]{3, 2, 3});
        CCLicense mockLicense2 = this.createMockLicense(2, new int[]{2});
        CCLicense mockLicense3 = this.createMockLicense(3, new int[0]);
        ccLicenses.put(mockLicense1.getLicenseId(), mockLicense1);
        ccLicenses.put(mockLicense2.getLicenseId(), mockLicense2);
        ccLicenses.put(mockLicense3.getLicenseId(), mockLicense3);
        return ccLicenses;
    }

    private CCLicense createMockLicense(int count, int[] amountOfFieldsAndEnums) {
        String licenseId = "license" + count;
        String licenseName = "License " + count + " - Name";
        List<CCLicenseField> mockLicenseFields = this.createMockLicenseFields(count, amountOfFieldsAndEnums);
        return new CCLicense(licenseId, licenseName, mockLicenseFields);
    }

    private List<CCLicenseField> createMockLicenseFields(int count, int[] amountOfFieldsAndEnums) {
        ArrayList<CCLicenseField> ccLicenseFields = new ArrayList<CCLicenseField>(amountOfFieldsAndEnums.length);
        for (int index = 0; index < amountOfFieldsAndEnums.length; ++index) {
            String licenseFieldId = "license" + count + "-field" + index;
            String licenseFieldLabel = "License " + count + " - Field " + index + " - Label";
            String licenseFieldDescription = "License " + count + " - Field " + index + " - Description";
            List<CCLicenseFieldEnum> mockLicenseFields = this.createMockLicenseFields(count, index, amountOfFieldsAndEnums[index]);
            ccLicenseFields.add(new CCLicenseField(licenseFieldId, licenseFieldLabel, licenseFieldDescription, mockLicenseFields));
        }
        return ccLicenseFields;
    }

    private List<CCLicenseFieldEnum> createMockLicenseFields(int count, int index, int amountOfEnums) {
        ArrayList<CCLicenseFieldEnum> ccLicenseFieldEnumList = new ArrayList<CCLicenseFieldEnum>(amountOfEnums);
        for (int i = 0; i < amountOfEnums; ++i) {
            String enumId = "license" + count + "-field" + index + "-enum" + i;
            String enumLabel = "License " + count + " - Field " + index + " - Enum " + i + " - Label";
            String enumDescription = "License " + count + " - Field " + index + " - Enum " + i + " - Description";
            ccLicenseFieldEnumList.add(new CCLicenseFieldEnum(enumId, enumLabel, enumDescription));
        }
        return ccLicenseFieldEnumList;
    }

    public String retrieveRightsByQuestion(String licenseId, String language, Map<String, String> answerMap) {
        return "mock-license-uri";
    }

    public Document retrieveLicenseRDFDoc(String licenseURI) throws IOException {
        if (!StringUtils.contains((CharSequence)licenseURI, (CharSequence)"invalid")) {
            try (InputStream cclicense = null;){
                Document doc;
                cclicense = ((Object)((Object)this)).getClass().getResourceAsStream("cc-license-rdf.xml");
                Document document = doc = this.parser.build(cclicense);
                return document;
            }
        }
        return null;
    }
}

