/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matcher;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class DateMatcher
extends BaseMatcher<String> {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private final Date matchDate;

    public DateMatcher(Date matchDate) {
        this.matchDate = matchDate;
    }

    public boolean matches(Object testDate) {
        Date testDateDecoded;
        if (null == this.matchDate && null == testDate) {
            return true;
        }
        if (null == this.matchDate) {
            return false;
        }
        if (!(testDate instanceof String)) {
            throw new IllegalArgumentException("Argument not a String");
        }
        try {
            testDateDecoded = dateFormat.parse((String)testDate);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Argument '" + testDate + "' is not an ISO 8601 zoned date", ex);
        }
        return this.matchDate.equals(testDateDecoded);
    }

    public void describeTo(Description description) {
        description.appendText("is the same date as ");
        description.appendText(dateFormat.format(this.matchDate));
    }

    public static DateMatcher dateMatcher(Date matchDate) {
        return new DateMatcher(matchDate);
    }
}

