/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.process;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.Process;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.service.ProcessService;
import org.junit.Assert;
import org.junit.Test;

public class ProcessIT
extends AbstractIntegrationTestWithDatabase {
    protected ProcessService processService = ScriptServiceFactory.getInstance().getProcessService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    @Test
    public void checkProcessGroupsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupA = GroupBuilder.createGroup(this.context).withName("Group A").addMember(this.admin).build();
        HashSet<Group> groupSet = new HashSet<Group>();
        groupSet.add(groupA);
        Process processA = ProcessBuilder.createProcess(this.context, this.admin, "mock-script", new LinkedList<DSpaceCommandLineParameter>(), groupSet).build();
        this.context.restoreAuthSystemState();
        Process process = this.processService.find(this.context, processA.getID().intValue());
        List groups = process.getGroups();
        boolean isPresent = groups.stream().anyMatch(g -> g.getID().equals(groupA.getID()));
        Assert.assertTrue((boolean)isPresent);
    }

    @Test
    public void removeOneGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group groupA = GroupBuilder.createGroup(this.context).withName("Group A").addMember(this.admin).build();
        HashSet<Group> groupSet = new HashSet<Group>();
        groupSet.add(groupA);
        UUID groupUuid = groupA.getID();
        Process processA = ProcessBuilder.createProcess(this.context, this.admin, "mock-script", new LinkedList<DSpaceCommandLineParameter>(), groupSet).build();
        this.context.restoreAuthSystemState();
        this.groupService.delete(this.context, (DSpaceObject)groupA);
        this.context.commit();
        this.context.reloadEntity((ReloadableEntity)groupA);
        processA = (Process)this.context.reloadEntity((ReloadableEntity)processA);
        Process process = this.processService.find(this.context, processA.getID().intValue());
        List groups = process.getGroups();
        boolean isPresent = groups.stream().anyMatch(g -> g.getID().equals(groupUuid));
        Assert.assertFalse((boolean)isPresent);
    }

    @Test
    public void addProcessWithNullEPersonTest() throws Exception {
        try {
            ProcessBuilder.createProcess(this.context, null, "mock-script", new LinkedList<DSpaceCommandLineParameter>(), new HashSet<Group>()).build();
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Should not have thrown NullPointerException");
        }
    }
}

