/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.statistics.SolrStatisticsCore;
import org.dspace.utils.DSpace;
import org.junit.Assert;
import org.junit.Test;

public class AnonymizeStatisticsIT
extends AbstractIntegrationTestWithDatabase {
    SolrStatisticsCore solrStatisticsCore = (SolrStatisticsCore)new DSpace().getSingletonService(SolrStatisticsCore.class);

    @Test
    public void testAnonymizeStatistics() throws Exception {
        String ip1 = "75.133.248.54";
        String ip2 = "195.11.13.244";
        String ip3 = "16f4:0586:3148:3a8a:f307:e13e:2614:21a2";
        String ip4 = "5b02:f3ed:635f:98b1:d2c5:f292:90d9:3982";
        String ip5 = "75.133.248.54";
        String ip5Anonymized = "75.133.248.255";
        String ip6 = "195.11.13.244";
        String ip6Anonymized = "195.11.13.255";
        String ip7 = "16f4:0586:3148:3a8a:f307:e13e:2614:21a2";
        String ip7Anonymized = "16f4:0586:3148:3a8a:f307:e13e:FFFF:FFFF";
        String ip8 = "5b02:f3ed:635f:98b1:d2c5:f292:90d9:3982";
        String ip8Anonymized = "5b02:f3ed:635f:98b1:d2c5:f292:FFFF:FFFF";
        this.addSolrDocument(Arrays.asList(Pair.of((Object)"id", (Object)"bitstream_view_recent"), Pair.of((Object)"type", (Object)0), Pair.of((Object)"ip", (Object)ip1), Pair.of((Object)"dns", (Object)"dns_1"), Pair.of((Object)"time", (Object)this.getTimeNDaysAgo(5))));
        this.addSolrDocument(Arrays.asList(Pair.of((Object)"id", (Object)"item_view_recent"), Pair.of((Object)"type", (Object)2), Pair.of((Object)"ip", (Object)ip2), Pair.of((Object)"dns", (Object)"dns_2"), Pair.of((Object)"time", (Object)this.getTimeNDaysAgo(20))));
        this.addSolrDocument(Arrays.asList(Pair.of((Object)"id", (Object)"collection_view_recent"), Pair.of((Object)"type", (Object)3), Pair.of((Object)"ip", (Object)ip3), Pair.of((Object)"dns", (Object)"dns_3"), Pair.of((Object)"time", (Object)this.getTimeNDaysAgo(50))));
        this.addSolrDocument(Arrays.asList(Pair.of((Object)"id", (Object)"community_view_recent"), Pair.of((Object)"type", (Object)4), Pair.of((Object)"ip", (Object)ip4), Pair.of((Object)"dns", (Object)"dns_4"), Pair.of((Object)"time", (Object)this.getTimeNDaysAgo(89))));
        this.addSolrDocument(Arrays.asList(Pair.of((Object)"id", (Object)"bitstream_view_old"), Pair.of((Object)"type", (Object)0), Pair.of((Object)"ip", (Object)ip5), Pair.of((Object)"dns", (Object)"dns_1"), Pair.of((Object)"time", (Object)this.getTimeNDaysAgo(90))));
        this.addSolrDocument(Arrays.asList(Pair.of((Object)"id", (Object)"item_view_old"), Pair.of((Object)"type", (Object)2), Pair.of((Object)"ip", (Object)ip6), Pair.of((Object)"dns", (Object)"dns_2"), Pair.of((Object)"time", (Object)this.getTimeNDaysAgo(130))));
        this.addSolrDocument(Arrays.asList(Pair.of((Object)"id", (Object)"collection_view_old"), Pair.of((Object)"type", (Object)3), Pair.of((Object)"ip", (Object)ip7), Pair.of((Object)"dns", (Object)"dns_3"), Pair.of((Object)"time", (Object)this.getTimeNDaysAgo(200))));
        this.addSolrDocument(Arrays.asList(Pair.of((Object)"id", (Object)"community_view_old"), Pair.of((Object)"type", (Object)4), Pair.of((Object)"ip", (Object)ip8), Pair.of((Object)"dns", (Object)"dns_4"), Pair.of((Object)"time", (Object)this.getTimeNDaysAgo(500))));
        this.solrStatisticsCore.getSolr().commit();
        this.runDSpaceScript("anonymize-statistics");
        Assert.assertEquals((Object)ip1, (Object)this.getSolrDocumentById("bitstream_view_recent").getFieldValue("ip"));
        Assert.assertEquals((Object)"dns_1", (Object)this.getSolrDocumentById("bitstream_view_recent").getFieldValue("dns"));
        Assert.assertEquals((Object)ip2, (Object)this.getSolrDocumentById("item_view_recent").getFieldValue("ip"));
        Assert.assertEquals((Object)"dns_2", (Object)this.getSolrDocumentById("item_view_recent").getFieldValue("dns"));
        Assert.assertEquals((Object)ip3, (Object)this.getSolrDocumentById("collection_view_recent").getFieldValue("ip"));
        Assert.assertEquals((Object)"dns_3", (Object)this.getSolrDocumentById("collection_view_recent").getFieldValue("dns"));
        Assert.assertEquals((Object)ip4, (Object)this.getSolrDocumentById("community_view_recent").getFieldValue("ip"));
        Assert.assertEquals((Object)"dns_4", (Object)this.getSolrDocumentById("community_view_recent").getFieldValue("dns"));
        Assert.assertEquals((Object)ip5Anonymized, (Object)this.getSolrDocumentById("bitstream_view_old").getFieldValue("ip"));
        Assert.assertEquals((Object)"anonymized", (Object)this.getSolrDocumentById("bitstream_view_old").getFieldValue("dns"));
        Assert.assertEquals((Object)ip6Anonymized, (Object)this.getSolrDocumentById("item_view_old").getFieldValue("ip"));
        Assert.assertEquals((Object)"anonymized", (Object)this.getSolrDocumentById("item_view_old").getFieldValue("dns"));
        Assert.assertEquals((Object)ip7Anonymized, (Object)this.getSolrDocumentById("collection_view_old").getFieldValue("ip"));
        Assert.assertEquals((Object)"anonymized", (Object)this.getSolrDocumentById("collection_view_old").getFieldValue("dns"));
        Assert.assertEquals((Object)ip8Anonymized, (Object)this.getSolrDocumentById("community_view_old").getFieldValue("ip"));
        Assert.assertEquals((Object)"anonymized", (Object)this.getSolrDocumentById("community_view_old").getFieldValue("dns"));
    }

    private void addSolrDocument(List<Pair<String, Object>> fields) throws IOException, SolrServerException {
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        for (Pair<String, Object> field : fields) {
            document.addField((String)field.getKey(), field.getValue());
        }
        this.solrStatisticsCore.getSolr().add(document);
    }

    private SolrDocument getSolrDocumentById(String id) throws IOException, SolrServerException {
        SolrDocumentList results = this.solrStatisticsCore.getSolr().query((SolrParams)new SolrQuery("id:" + id)).getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (SolrDocument)results.get(0);
    }

    private String getTimeNDaysAgo(int daysAgo) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -daysAgo);
        return DateFormatUtils.format((Calendar)calendar, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }
}

