/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.dspace.util.RawJsonDeserializer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RawJsonDeserializerTest {
    private String json = "{    \"attribute\": {         \"firstField\":\"value\",         \"secondField\": 1    }}";

    @Test
    public void testDeserialization() throws JsonMappingException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        DeserializationTestClass object = (DeserializationTestClass)mapper.readValue(this.json, DeserializationTestClass.class);
        MatcherAssert.assertThat((Object)object, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)object.getAttribute(), (Matcher)Matchers.is((Object)"{\"firstField\":\"value\",\"secondField\":1}"));
    }

    private static class DeserializationTestClass {
        @JsonDeserialize(using=RawJsonDeserializer.class)
        private String attribute;

        private DeserializationTestClass() {
        }

        public String getAttribute() {
            return this.attribute;
        }
    }
}

