/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.ClaimedTaskBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.IndexingService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.processingaction.SelectReviewerAction;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class XmlWorkflowServiceIT
extends AbstractIntegrationTestWithDatabase {
    protected XmlWorkflowService xmlWorkflowService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService();
    protected IndexingService indexer = (IndexingService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @After
    public void cleanup() throws SQLException, AuthorizeException, IOException {
        Group reviewManagers = this.groupService.findByName(this.context, "ReviewManagers");
        if (reviewManagers != null) {
            this.groupService.delete(this.context, (DSpaceObject)reviewManagers);
        }
    }

    @Test
    public void workflowUserRejectsItemTheySubmitted_ItemShouldBeEditable() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson(this.context).withEmail("submitter@example.org").build();
        this.context.setCurrentUser(submitter);
        Community community = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection colWithWorkflow = CollectionBuilder.createCollection(this.context, community).withName("Collection WITH workflow").withWorkflowGroup(1, submitter).build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(colWithWorkflow);
        ClaimedTask taskToReject = ClaimedTaskBuilder.createClaimedTask(this.context, colWithWorkflow, submitter).withTitle("Test workflow item to reject").build();
        this.context.restoreAuthSystemState();
        Assert.assertTrue((boolean)this.containsRPForUser(taskToReject.getWorkflowItem().getItem(), submitter, 1));
        MockHttpServletRequest httpRejectRequest = new MockHttpServletRequest();
        httpRejectRequest.setParameter("submit_reject", "submit_reject");
        httpRejectRequest.setParameter("reason", "test");
        this.executeWorkflowAction((HttpServletRequest)httpRejectRequest, workflow, taskToReject);
        Assert.assertTrue((boolean)this.containsRPForUser(taskToReject.getWorkflowItem().getItem(), submitter, 1));
    }

    @Test
    public void workflowUserSingleSelectedReviewer_ItemShouldBeEditable() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson(this.context).withEmail("submitter@example.org").build();
        this.context.setCurrentUser(submitter);
        EPerson reviewManager = EPersonBuilder.createEPerson(this.context).withEmail("reviewmanager-test@example.org").build();
        Community community = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection colWithWorkflow = CollectionBuilder.createCollection(this.context, community, "123456789/workflow-test-1").withName("Collection WITH workflow").withWorkflowGroup("reviewmanagers", reviewManager).build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(colWithWorkflow);
        ClaimedTask task = ClaimedTaskBuilder.createClaimedTask(this.context, colWithWorkflow, reviewManager).withTitle("Test workflow item to reject").build();
        SelectReviewerAction.resetGroup();
        this.configurationService.setProperty("action.selectrevieweraction.group", (Object)"Reviewers");
        Group reviewerGroup = GroupBuilder.createGroup(this.context).withName("Reviewers").build();
        EPerson reviewer = EPersonBuilder.createEPerson(this.context).withEmail("reviewer@example.org").build();
        this.groupService.addMember(this.context, reviewerGroup, reviewer);
        this.context.restoreAuthSystemState();
        Assert.assertTrue((boolean)this.containsRPForUser(task.getWorkflowItem().getItem(), reviewManager, 1));
        MockHttpServletRequest httpSelectReviewerRequest = new MockHttpServletRequest();
        httpSelectReviewerRequest.setParameter("submit_select_reviewer", "true");
        httpSelectReviewerRequest.setParameter("eperson", reviewer.getID().toString());
        this.executeWorkflowAction((HttpServletRequest)httpSelectReviewerRequest, workflow, task);
        Assert.assertTrue((boolean)this.containsRPForUser(task.getWorkflowItem().getItem(), reviewer, 1));
    }

    @Test
    public void workflowUserMultipleSelectedReviewer_ItemShouldBeEditable() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson(this.context).withEmail("submitter@example.org").build();
        this.context.setCurrentUser(submitter);
        EPerson reviewManager = EPersonBuilder.createEPerson(this.context).withEmail("reviewmanager-test@example.org").build();
        Community community = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection colWithWorkflow = CollectionBuilder.createCollection(this.context, community, "123456789/workflow-test-1").withName("Collection WITH workflow").withWorkflowGroup("reviewmanagers", reviewManager).build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(colWithWorkflow);
        ClaimedTask task = ClaimedTaskBuilder.createClaimedTask(this.context, colWithWorkflow, reviewManager).withTitle("Test workflow item to reject").build();
        SelectReviewerAction.resetGroup();
        this.configurationService.setProperty("action.selectrevieweraction.group", (Object)"Reviewers");
        Group reviewerGroup = GroupBuilder.createGroup(this.context).withName("Reviewers").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson(this.context).withEmail("reviewer1@example.org").build();
        EPerson reviewer2 = EPersonBuilder.createEPerson(this.context).withEmail("reviewer2@example.org").build();
        this.groupService.addMember(this.context, reviewerGroup, reviewer1);
        this.groupService.addMember(this.context, reviewerGroup, reviewer2);
        this.context.restoreAuthSystemState();
        Assert.assertTrue((boolean)this.containsRPForUser(task.getWorkflowItem().getItem(), reviewManager, 1));
        MockHttpServletRequest httpSelectMultipleReviewers = new MockHttpServletRequest();
        httpSelectMultipleReviewers.setParameter("submit_select_reviewer", "true");
        httpSelectMultipleReviewers.setParameter("eperson", new String[]{reviewer1.getID().toString(), reviewer2.getID().toString()});
        this.executeWorkflowAction((HttpServletRequest)httpSelectMultipleReviewers, workflow, task);
        Assert.assertTrue((boolean)this.containsRPForUser(task.getWorkflowItem().getItem(), reviewer1, 1));
        Assert.assertTrue((boolean)this.containsRPForUser(task.getWorkflowItem().getItem(), reviewer2, 1));
    }

    private boolean containsRPForUser(Item item, EPerson user, int action) throws SQLException {
        List rps = this.authorizeService.getPolicies(this.context, (DSpaceObject)item);
        for (ResourcePolicy rp : rps) {
            if (!rp.getEPerson().getID().equals(user.getID()) || rp.getAction() != action) continue;
            return true;
        }
        return false;
    }

    private void executeWorkflowAction(HttpServletRequest httpServletRequest, Workflow workflow, ClaimedTask task) throws Exception {
        EPerson previousUser = this.context.getCurrentUser();
        task = (ClaimedTask)this.context.reloadEntity((ReloadableEntity)task);
        this.context.setCurrentUser(task.getOwner());
        this.xmlWorkflowService.doState(this.context, task.getOwner(), httpServletRequest, task.getWorkflowItem().getID().intValue(), workflow, workflow.getStep(task.getStepID()).getActionConfig(task.getActionID()));
        this.context.commit();
        this.indexer.commit();
        this.context.setCurrentUser(previousUser);
    }
}

