/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.alerts;

import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dspace.alerts.AllowSessionsEnum;
import org.dspace.core.ReloadableEntity;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, include="non-lazy")
@Table(name="systemwidealert")
public class SystemWideAlert
implements ReloadableEntity<Integer> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="alert_id_seq")
    @SequenceGenerator(name="alert_id_seq", sequenceName="alert_id_seq", allocationSize=1)
    @Column(name="alert_id", unique=true, nullable=false)
    private Integer alertId;
    @Column(name="message", nullable=false)
    private String message;
    @Column(name="allow_sessions")
    private String allowSessions;
    @Column(name="countdown_to")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date countdownTo;
    @Column(name="active")
    private boolean active;

    protected SystemWideAlert() {
    }

    @Override
    public Integer getID() {
        return this.alertId;
    }

    public void setID(Integer alertID) {
        this.alertId = alertID;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public AllowSessionsEnum getAllowSessions() {
        return AllowSessionsEnum.fromString(this.allowSessions);
    }

    public void setAllowSessions(AllowSessionsEnum allowSessions) {
        this.allowSessions = allowSessions.getValue();
    }

    public Date getCountdownTo() {
        return this.countdownTo;
    }

    public void setCountdownTo(Date countdownTo) {
        this.countdownTo = countdownTo;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean equals(Object other) {
        return other instanceof SystemWideAlert && new EqualsBuilder().append((Object)this.getID(), (Object)((SystemWideAlert)other).getID()).append((Object)this.getMessage(), (Object)((SystemWideAlert)other).getMessage()).append((Object)this.getAllowSessions(), (Object)((SystemWideAlert)other).getAllowSessions()).append((Object)this.getCountdownTo(), (Object)((SystemWideAlert)other).getCountdownTo()).append(this.isActive(), ((SystemWideAlert)other).isActive()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getID()).append((Object)this.getMessage()).append((Object)this.getAllowSessions()).append((Object)this.getCountdownTo()).append(this.isActive()).toHashCode();
    }
}

