/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.indexer;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.indexer.AuthorityIndexerInterface;
import org.dspace.authority.service.AuthorityValueService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DSpaceAuthorityIndexer
implements AuthorityIndexerInterface,
InitializingBean {
    private static final Logger log = LogManager.getLogger(DSpaceAuthorityIndexer.class);
    protected List<String> metadataFields;
    @Autowired(required=true)
    protected AuthorityValueService authorityValueService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;

    public void afterPropertiesSet() throws Exception {
        String field;
        int counter = 1;
        this.metadataFields = new ArrayList<String>();
        while ((field = this.configurationService.getProperty("authority.author.indexer.field." + counter)) != null) {
            this.metadataFields.add(field);
            ++counter;
        }
    }

    @Override
    public List<AuthorityValue> getAuthorityValues(Context context, Item item) throws SQLException, AuthorizeException {
        return this.getAuthorityValues(context, item, null);
    }

    @Override
    public List<AuthorityValue> getAuthorityValues(Context context, Item item, Map<String, AuthorityValue> cache) throws SQLException, AuthorizeException {
        ArrayList<AuthorityValue> values = new ArrayList<AuthorityValue>();
        for (String metadataField : this.metadataFields) {
            String[] fieldParts = metadataField.split("\\.");
            String schema = fieldParts.length > 0 ? fieldParts[0] : null;
            String element = fieldParts.length > 1 ? fieldParts[1] : null;
            String qualifier = fieldParts.length > 2 ? fieldParts[2] : null;
            List<MetadataValue> metadataValues = this.itemService.getMetadata(item, schema, element, qualifier, "*", false);
            for (MetadataValue metadataValue : metadataValues) {
                String content = metadataValue.getValue();
                String authorityKey = metadataValue.getAuthority();
                boolean requiresItemUpdate = StringUtils.isBlank((CharSequence)authorityKey) || StringUtils.startsWith((CharSequence)authorityKey, (CharSequence)"will be generated::");
                AuthorityValue value = null;
                if (StringUtils.isBlank((CharSequence)authorityKey) && cache != null) {
                    value = cache.get(content);
                }
                if (value == null) {
                    value = this.getAuthorityValue(context, metadataField, content, authorityKey);
                }
                if (value != null) {
                    if (requiresItemUpdate) {
                        value.updateItem(context, item, metadataValue);
                        try {
                            this.itemService.update(context, item);
                        }
                        catch (Exception e) {
                            log.error("Error creating a metadatavalue's authority", (Throwable)e);
                        }
                    }
                    if (cache != null) {
                        cache.put(content, value);
                    }
                    values.add(value);
                    continue;
                }
                log.error("Error getting an authority value for the metadata value \"" + content + "\" in the field \"" + metadataField + "\" of the item " + item.getHandle());
            }
        }
        return values;
    }

    private AuthorityValue getAuthorityValue(Context context, String metadataField, String metadataContent, String metadataAuthorityKey) {
        AuthorityValue value;
        if (StringUtils.isNotBlank((CharSequence)metadataAuthorityKey) && !metadataAuthorityKey.startsWith("will be generated::") && (value = this.authorityValueService.findByUID(context, metadataAuthorityKey)) != null) {
            return value;
        }
        return this.authorityValueService.generate(context, metadataAuthorityKey, metadataContent, metadataField.replaceAll("\\.", "_"));
    }

    @Override
    public boolean isConfiguredProperly() {
        boolean isConfiguredProperly = true;
        if (CollectionUtils.isEmpty(this.metadataFields)) {
            log.warn("Authority indexer not properly configured, no metadata fields configured for indexing. Check the \"authority.author.indexer.field\" properties.");
            isConfiguredProperly = false;
        }
        return isConfiguredProperly;
    }
}

