/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.logic;

import java.util.HashMap;
import java.util.Map;
import org.dspace.content.logic.Filter;
import org.dspace.content.logic.TrueFilter;
import org.dspace.identifier.DOI;
import org.dspace.identifier.Handle;
import org.dspace.identifier.Identifier;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FilterUtils {
    @Autowired(required=true)
    ConfigurationService configurationService;

    public static Filter getFilterFromConfiguration(String property) {
        String filterName = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty(property);
        if (filterName != null) {
            return (Filter)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(filterName, Filter.class);
        }
        return null;
    }

    public static Filter getFilterFromConfiguration(String property, Filter defaultFilter) {
        Filter filter = FilterUtils.getFilterFromConfiguration(property);
        if (filter != null) {
            return filter;
        }
        return defaultFilter;
    }

    public static Map<Class<? extends Identifier>, Filter> getIdentifierFilters(boolean inProgress) {
        String configurationSuffix = "install";
        if (inProgress) {
            configurationSuffix = "workspace";
        }
        HashMap<Class<? extends Identifier>, Filter> filters = new HashMap<Class<? extends Identifier>, Filter>();
        Filter filter = FilterUtils.getFilterFromConfiguration("identifiers.submission.filter." + configurationSuffix);
        filters.put(DOI.class, filter);
        filters.put(Handle.class, (Filter)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("always_true_filter", TrueFilter.class));
        return filters;
    }
}

