/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.contentreport;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.contentreport.Filter;
import org.dspace.contentreport.FilteredCollection;
import org.dspace.contentreport.FilteredItems;
import org.dspace.contentreport.FilteredItemsQuery;
import org.dspace.contentreport.QueryPredicate;
import org.dspace.contentreport.service.ContentReportService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class ContentReportServiceImpl
implements ContentReportService {
    private static final Logger log = LogManager.getLogger(ContentReportServiceImpl.class);
    @Autowired
    protected ConfigurationService configurationService;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private MetadataFieldService metadataFieldService;

    @Override
    public boolean getEnabled() {
        return this.configurationService.getBooleanProperty("contentreport.enable");
    }

    @Override
    public List<FilteredCollection> findFilteredCollections(Context context, java.util.Collection<Filter> filters) {
        ArrayList<FilteredCollection> colls = new ArrayList<FilteredCollection>();
        try {
            List<Collection> collections = this.collectionService.findAll(context);
            for (Collection collection : collections) {
                FilteredCollection coll = new FilteredCollection();
                coll.setHandle(collection.getHandle());
                coll.setLabel(collection.getName());
                Community community = collection.getCommunities().stream().findFirst().orElse(null);
                if (community != null) {
                    coll.setCommunityLabel(community.getName());
                    coll.setCommunityHandle(community.getHandle());
                }
                colls.add(coll);
                Iterator<Item> items = this.itemService.findAllByCollection(context, collection);
                int nbTotalItems = 0;
                while (items.hasNext()) {
                    Item item = items.next();
                    ++nbTotalItems;
                    boolean matchesAllFilters = true;
                    for (Filter filter : filters) {
                        if (filter.testItem(context, item)) {
                            coll.addValue(filter, 1);
                            continue;
                        }
                        coll.addValue(filter, 0);
                        matchesAllFilters = false;
                    }
                    if (!matchesAllFilters) continue;
                    coll.addAllFiltersValue(1);
                }
                coll.setTotalItems(nbTotalItems);
                coll.seal();
            }
        }
        catch (SQLException e) {
            log.error("SQLException trying to receive filtered collections statistics", (Throwable)e);
        }
        return colls;
    }

    @Override
    public FilteredItems findFilteredItems(Context context, FilteredItemsQuery query) {
        FilteredItems report = new FilteredItems();
        List<QueryPredicate> predicates = query.getQueryPredicates();
        List<UUID> collectionUuids = ContentReportServiceImpl.getUuidsFromStrings(query.getCollections());
        Set<Filter> filters = query.getFilters();
        try {
            List<Item> items = this.itemService.findByMetadataQuery(context, predicates, collectionUuids, query.getOffset(), query.getPageLimit());
            items.stream().filter(item -> filters.stream().allMatch(f -> f.testItem(context, (Item)item))).forEach(report::addItem);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            long count = this.itemService.countForMetadataQuery(context, predicates, collectionUuids);
            report.setItemCount(count);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return report;
    }

    @Override
    public List<MetadataField> getMetadataFields(Context context, String metadataField) throws SQLException {
        ArrayList<MetadataField> fields = new ArrayList<MetadataField>();
        if ("*".equals(metadataField)) {
            return fields;
        }
        String schema = "";
        String element = "";
        String qualifier = null;
        String[] parts = metadataField.split("\\.");
        if (parts.length > 0) {
            schema = parts[0];
        }
        if (parts.length > 1) {
            element = parts[1];
        }
        if (parts.length > 2) {
            qualifier = parts[2];
        }
        if ("*".equals(qualifier)) {
            fields.addAll(this.metadataFieldService.findFieldsByElementNameUnqualified(context, schema, element));
        } else {
            MetadataField mf = this.metadataFieldService.findByElement(context, schema, element, qualifier);
            if (mf != null) {
                fields.add(mf);
            }
        }
        return fields;
    }

    private static List<UUID> getUuidsFromStrings(List<String> collSel) {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (String s : collSel) {
            try {
                uuids.add(UUID.fromString(s));
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid collection UUID: " + s);
            }
        }
        return uuids;
    }
}

