/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.client.DSpaceHttpClientFactory;
import org.dspace.google.GoogleAnalyticsEvent;
import org.dspace.google.client.GoogleAnalyticsClient;
import org.dspace.google.client.GoogleAnalyticsClientException;
import org.dspace.google.client.GoogleAnalyticsClientRequestBuilder;

public class GoogleAnalyticsClientImpl
implements GoogleAnalyticsClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String keyPrefix;
    private final GoogleAnalyticsClientRequestBuilder requestBuilder;
    private final CloseableHttpClient httpclient;

    public GoogleAnalyticsClientImpl(String keyPrefix, GoogleAnalyticsClientRequestBuilder requestBuilder) {
        this.keyPrefix = keyPrefix;
        this.requestBuilder = requestBuilder;
        this.httpclient = DSpaceHttpClientFactory.getInstance().build();
    }

    @Override
    public boolean isAnalyticsKeySupported(String analyticsKey) {
        return StringUtils.startsWith((String)analyticsKey, (String)this.keyPrefix);
    }

    @Override
    public void sendEvents(String analyticsKey, List<GoogleAnalyticsEvent> events) {
        if (!this.isAnalyticsKeySupported(analyticsKey)) {
            throw new IllegalArgumentException("The given analytics key " + analyticsKey + " is not supported. A key with prefix " + this.keyPrefix + " is required");
        }
        String endpointUrl = this.requestBuilder.getEndpointUrl(analyticsKey);
        this.requestBuilder.composeRequestsBody(analyticsKey, events).forEach(requestBody -> this.sendRequest(endpointUrl, (String)requestBody));
    }

    private void sendRequest(String endpointUrl, String requestBody) {
        try {
            HttpPost httpPost = new HttpPost(endpointUrl);
            httpPost.setEntity((HttpEntity)new StringEntity(requestBody));
            try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpPost);){
                if (this.isNotSuccessfull((HttpResponse)response)) {
                    throw new GoogleAnalyticsClientException(this.formatErrorMessage((HttpResponse)response));
                }
            }
        }
        catch (GoogleAnalyticsClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GoogleAnalyticsClientException("An error occurs sending events to " + endpointUrl, ex);
        }
    }

    private boolean isNotSuccessfull(HttpResponse response) {
        int statusCode = this.getStatusCode(response);
        return statusCode < 200 || statusCode > 299;
    }

    private int getStatusCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private String formatErrorMessage(HttpResponse response) {
        return "Status " + this.getStatusCode(response) + ". Content: " + this.getResponseContent(response);
    }

    private String getResponseContent(HttpResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
        }
        catch (IOException | UnsupportedOperationException e) {
            LOGGER.error("An error occurs getting the response content", (Throwable)e);
            return "Generic error";
        }
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public GoogleAnalyticsClientRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }
}

