/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.SimpleXpathMetadatumContributor;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class SimpleXpathDateFormatMetadataContributor
extends SimpleXpathMetadatumContributor {
    private DateFormat dateFormatFrom;
    private DateFormat dateFormatTo;

    public void setDateFormatFrom(String dateFormatFrom) {
        this.dateFormatFrom = new SimpleDateFormat(dateFormatFrom);
    }

    public void setDateFormatTo(String dateFormatTo) {
        this.dateFormatTo = new SimpleDateFormat(dateFormatTo);
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(Element element) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (String ns : this.prefixToNamespaceMapping.keySet()) {
            namespaces.add(Namespace.getNamespace((String)((String)this.prefixToNamespaceMapping.get(ns)), (String)ns));
        }
        XPathExpression xpath = XPathFactory.instance().compile(this.query, Filters.fpassthrough(), null, namespaces);
        List nodes = xpath.evaluate((Object)element);
        for (Object el : nodes) {
            if (el instanceof Element) {
                values.add(this.getMetadatum(this.field, ((Element)el).getText()));
                continue;
            }
            if (el instanceof Attribute) {
                values.add(this.getMetadatum(this.field, ((Attribute)el).getValue()));
                continue;
            }
            if (el instanceof String) {
                values.add(this.getMetadatum(this.field, (String)el));
                continue;
            }
            if (el instanceof Text) {
                values.add(this.metadataFieldMapping.toDCValue(this.field, ((Text)el).getText()));
                continue;
            }
            System.err.println("node of type: " + el.getClass());
        }
        return values;
    }

    private MetadatumDTO getMetadatum(MetadataFieldConfig field, String value) {
        MetadatumDTO dcValue = new MetadatumDTO();
        if (field == null) {
            return null;
        }
        try {
            dcValue.setValue(this.dateFormatTo.format(this.dateFormatFrom.parse(value)));
        }
        catch (ParseException e) {
            dcValue.setValue(value);
        }
        dcValue.setElement(field.getElement());
        dcValue.setQualifier(field.getQualifier());
        dcValue.setSchema(field.getSchema());
        return dcValue;
    }
}

