/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.usage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.core.Constants;
import org.dspace.services.ConfigurationService;
import org.dspace.services.model.Event;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

public class TabFileUsageEventListener
extends AbstractUsageEventListener {
    private static final Logger errorLog = LogManager.getLogger();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
    private PrintWriter eventLog;
    private boolean initialized = false;

    private void init() {
        ConfigurationService configurationService = new DSpace().getConfigurationService();
        String logPath = (String)configurationService.getPropertyAsType("usageEvent.tabFileLogger.file", (Object)"usage-events.tsv");
        String logDir = null;
        if (!new File(logPath).isAbsolute()) {
            logDir = configurationService.getProperty("log.report.dir");
        }
        File logFile = new File(logDir, logPath);
        try {
            this.eventLog = new PrintWriter(new OutputStreamWriter(new FileOutputStream(logFile, true)));
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = logFile::getAbsolutePath;
            errorLog.debug("Writing to {}", supplierArray);
        }
        catch (FileNotFoundException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = TabFileUsageEventListener.class::getName;
            supplierArray[1] = e::getMessage;
            errorLog.error("{} cannot open file, will not log events:  {}", supplierArray);
            throw new IllegalArgumentException("Cannot open event log file", e);
        }
        if (logFile.length() <= 0L) {
            this.eventLog.println("date\tevent\tobjectType\tobjectId\tsessionId\tsourceAddress\teperson");
        }
        this.initialized = true;
    }

    public synchronized void receiveEvent(Event event) {
        if (!this.initialized) {
            this.init();
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((Event)event).toString();
        errorLog.debug("got: {}", supplierArray);
        if (!(event instanceof UsageEvent)) {
            return;
        }
        if (null == this.eventLog) {
            return;
        }
        UsageEvent ue = (UsageEvent)event;
        this.eventLog.append(dateFormat.format(new Date())).append('\t').append(ue.getName()).append('\t').append(Constants.typeText[ue.getObject().getType()]).append('\t').append(ue.getObject().getID().toString()).append('\t').append(ue.getRequest().getSession().getId()).append('\t').append(ue.getRequest().getRemoteAddr());
        String epersonName = null == ue.getContext().getCurrentUser() ? "anonymous" : ue.getContext().getCurrentUser().getEmail();
        this.eventLog.append('\t').append(epersonName);
        this.eventLog.println();
        this.eventLog.flush();
    }
}

