/*
 * Decompiled with CFR 0.152.
 */
package org.dspace;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@Ignore
@RunWith(value=MockitoJUnitRunner.class)
public class AbstractDSpaceTest {
    private static final Logger log = LogManager.getLogger(AbstractDSpaceTest.class);
    protected static Properties testProps;
    protected static DSpaceKernelImpl kernelImpl;
    @Rule
    public TestName testName = new TestName();

    protected AbstractDSpaceTest() {
    }

    @BeforeClass
    public static void initKernel() {
        try {
            TimeZone.setDefault(TimeZone.getTimeZone(ZoneOffset.UTC));
            testProps = new Properties();
            URL properties = AbstractDSpaceTest.class.getClassLoader().getResource("test-config.properties");
            testProps.load(properties.openStream());
            kernelImpl = DSpaceKernelInit.getKernel(null);
            if (!kernelImpl.isRunning()) {
                kernelImpl.start(AbstractDSpaceTest.getDspaceDir());
            }
        }
        catch (IOException ex) {
            log.error("Error initializing tests", (Throwable)ex);
            Assert.fail((String)("Error initializing tests: " + ex.getMessage()));
        }
    }

    @Before
    public void printTestMethodBefore() {
        log.info("---");
        log.info("Starting execution of test method: {}()", (Object)this.testName.getMethodName());
        log.info("---");
    }

    @After
    public void printTestMethodAfter() {
        log.info("Finished execution of test method: {}()", (Object)this.testName.getMethodName());
    }

    @AfterClass
    public static void destroyKernel() throws SQLException {
        testProps.clear();
        testProps = null;
        if (kernelImpl != null) {
            kernelImpl.destroy();
        }
        kernelImpl = null;
    }

    public static String getDspaceDir() {
        return System.getProperty("dspace.dir");
    }
}

