/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.DCInputAuthority;
import org.dspace.content.authority.factory.ContentAuthorityServiceFactory;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.PluginService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ScriptService;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MetadataEditControlledVocabularyIT
extends AbstractIntegrationTestWithDatabase {
    ConfigurationService configurationService = new DSpace().getConfigurationService();
    PluginService pluginService = CoreServiceFactory.getInstance().getPluginService();
    MetadataAuthorityService mas = ContentAuthorityServiceFactory.getInstance().getMetadataAuthorityService();
    ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private Collection collection;
    private TestDSpaceRunnableHandler handler;
    private File file;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("vocabulary.plugin.srsc.hierarchy.store", (Object)true);
        this.configurationService.setProperty("vocabulary.plugin.srsc.hierarchy.suggest", (Object)true);
        this.configurationService.setProperty("vocabulary.plugin.srsc.delimiter", (Object)"::");
        this.configurationService.setProperty("authority.controlled.dc.subject", (Object)"true");
        this.configurationService.setProperty("choices.plugin.dc.subject", (Object)"DSpaceControlledVocabulary");
        this.configurationService.setProperty("plugin.named.org.dspace.content.authority.ChoiceAuthority", (Object)new String[]{"org.dspace.content.authority.SolrAuthority = SolrAuthorAuthority", "org.dspace.content.authority.SolrAuthority = SolrEditorAuthority", "org.dspace.content.authority.SolrAuthority = SolrSubjectAuthority", "org.dspace.content.authority.DSpaceControlledVocabulary = DCV"});
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.mas.clearCache();
        this.handler = new TestDSpaceRunnableHandler();
        this.file = File.createTempFile("edit", ".csv");
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        this.collection = CollectionBuilder.createCollection(this.context, community).build();
        this.context.restoreAuthSystemState();
    }

    @Override
    @After
    public void destroy() throws Exception {
        super.destroy();
        this.configurationService.reloadConfig();
        DCInputAuthority.reset();
        this.pluginService.clearNamedPluginClasses();
        this.mas.clearCache();
    }

    @Test
    public void testEditVocabularySubject() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Test Export").withSubject("Church studies", "VR110103", 600).withSubject("History of religion", "VR110102", 600).build();
        this.context.restoreAuthSystemState();
        this.runExport(item);
        TestCase.assertNull((String)"Export should succeed", (Object)this.handler.getException());
        String exportedContent = this.readFile();
        MatcherAssert.assertThat((Object)exportedContent, (Matcher)CoreMatchers.containsString((String)"Church studies::VR110103::600"));
        MatcherAssert.assertThat((Object)exportedContent, (Matcher)CoreMatchers.containsString((String)"History of religion::VR110102::600"));
        this.writeFile(exportedContent.replace("History of religion::VR110102::600", "Missionary studies::VR110104::600"));
        this.runImport();
        TestCase.assertNull((String)"Re-import should succeed", (Object)this.handler.getException());
        item = (Item)this.itemService.find(this.context, item.getID());
        List subjects = this.itemService.getMetadata((DSpaceObject)item, "dc", "subject", null, "*");
        TestCase.assertEquals((int)2, (int)subjects.size());
        List values = subjects.stream().map(MetadataValue::getValue).collect(Collectors.toList());
        List authorities = subjects.stream().map(MetadataValue::getAuthority).collect(Collectors.toList());
        MatcherAssert.assertThat(values, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Church studies", "Missionary studies"}));
        MatcherAssert.assertThat(authorities, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"VR110103", "VR110104"}));
    }

    @Test
    public void testEditVocabularySubjectHierarchy() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.collection).withTitle("Test Export").withSubject("HUMANITIES and RELIGION::Religion/Theology::Psychology of religion", "VR110109", 600).withSubject("HUMANITIES and RELIGION::Religion/Theology::Philosophy of religion", "VR110110", 600).build();
        this.context.restoreAuthSystemState();
        this.runExport(item);
        TestCase.assertNull((String)"Export should succeed", (Object)this.handler.getException());
        String exportedContent = this.readFile();
        MatcherAssert.assertThat((Object)exportedContent, (Matcher)CoreMatchers.containsString((String)"HUMANITIES and RELIGION::Religion/Theology::Psychology of religion::VR110109::600"));
        MatcherAssert.assertThat((Object)exportedContent, (Matcher)CoreMatchers.containsString((String)"HUMANITIES and RELIGION::Religion/Theology::Philosophy of religion::VR110110::600"));
        this.writeFile(exportedContent.replace("HUMANITIES and RELIGION::Religion/Theology::Psychology of religion::VR110109::600", "HUMANITIES and RELIGION::Religion/Theology::New Testament exegesis::VR110111::600"));
        this.runImport();
        TestCase.assertNull((String)"Re-import should succeed", (Object)this.handler.getException());
        item = (Item)this.itemService.find(this.context, item.getID());
        List subjects = this.itemService.getMetadata((DSpaceObject)item, "dc", "subject", null, "*");
        TestCase.assertEquals((int)2, (int)subjects.size());
        List values = subjects.stream().map(MetadataValue::getValue).collect(Collectors.toList());
        List authorities = subjects.stream().map(MetadataValue::getAuthority).collect(Collectors.toList());
        MatcherAssert.assertThat(values, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"HUMANITIES and RELIGION::Religion/Theology::Philosophy of religion", "HUMANITIES and RELIGION::Religion/Theology::New Testament exegesis"}));
        MatcherAssert.assertThat(authorities, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"VR110110", "VR110111"}));
    }

    private void runExport(Item item) throws Exception {
        this.runScript(new String[]{"metadata-export", "-i", String.valueOf(item.getHandle()), "-f", this.file.getAbsolutePath()});
    }

    private void runImport() throws Exception {
        this.runScript(new String[]{"metadata-import", "-s", "-e", this.eperson.getEmail(), "-f", this.file.getAbsolutePath()});
    }

    private void runScript(String[] args) throws Exception {
        ScriptService scriptService = ScriptServiceFactory.getInstance().getScriptService();
        ScriptConfiguration scriptConfiguration = scriptService.getScriptConfiguration(args[0]);
        DSpaceRunnable script = null;
        if (scriptConfiguration != null) {
            script = scriptService.createDSpaceRunnableForScriptConfiguration(scriptConfiguration);
        }
        if (script != null) {
            script.initialize(args, (DSpaceRunnableHandler)this.handler, null);
            script.run();
        }
    }

    private String readFile() throws Exception {
        return IOUtils.toString((InputStream)new FileInputStream(this.file), (Charset)StandardCharsets.UTF_8);
    }

    private void writeFile(String content) throws Exception {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8));){
            out.write(content);
            out.flush();
        }
    }
}

