/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import com.google.common.io.Files;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.log4j.Logger;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataExportFilteredItemsReportIT
extends AbstractIntegrationTestWithDatabase {
    private Map<ItemKey, List<Item>> items = new HashMap<ItemKey, List<Item>>();
    private Map<String, UUID> collUuids = new HashMap<String, UUID>();
    private String[] collNames = new String[]{"coll1", "coll2"};
    private String[] subjects = new String[]{"subject1", "subject2"};
    private String[] authors = new String[]{"author1", "author2"};
    private int[][] itemCountPerSubjectThenPerAuthor = new int[][]{{12, 15}, {9, 4}};
    private String filename;
    private Logger logger = Logger.getLogger(MetadataExportFilteredItemsReportIT.class);
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        this.filename = this.configurationService.getProperty("dspace.dir") + testProps.get("test.exportcsv").toString();
        TriFunction dateFunction = (i, j, k) -> "%04d-%02d-%02d".formatted(2022 + i, 4 + j, k);
        for (int c = 0; c < this.collNames.length; ++c) {
            String collName = this.collNames[c];
            org.dspace.content.Collection collection = CollectionBuilder.createCollection(this.context, community).withName(collName).build();
            this.collUuids.put(collName, collection.getID());
            for (int s = 0; s < this.subjects.length; ++s) {
                String subject = this.subjects[s];
                for (int a = 0; a < this.authors.length; ++a) {
                    String author = this.authors[a];
                    for (int k2 = 0; k2 < this.itemCountPerSubjectThenPerAuthor[s][a]; ++k2) {
                        ItemKey key = new ItemKey(collName, subject, author);
                        Item item = ItemBuilder.createItem(this.context, collection).withTitle(String.format("%s item %d", subject, k2)).withSubject(subject).withAuthor(author).withIssueDate((String)dateFunction.apply((Object)s, (Object)a, (Object)k2)).build();
                        this.items.computeIfAbsent(key, aKey -> new ArrayList()).add(item);
                    }
                }
            }
        }
        this.context.restoreAuthSystemState();
    }

    private void checkItemsPresentInFile(String filename, Item ... items) throws IOException, CsvException {
        File file = new File(filename);
        BufferedReader reader = Files.newReader((File)file, (Charset)Charset.defaultCharset());
        try (CSVReader csvReader = new CSVReader((Reader)reader);){
            List lines = csvReader.readAll();
            Assert.assertEquals((long)(items.length + 1), (long)lines.size());
            this.logger.debug((Object)"checking content of lines");
            List ids = lines.stream().skip(1L).peek(line -> this.logger.debug((Object)String.join((CharSequence)", ", line))).map(line -> line[0]).collect(Collectors.toList());
            for (Item item : items) {
                Assert.assertTrue((boolean)ids.contains(item.getID().toString()));
            }
        }
    }

    private Item[] allItems() {
        return (Item[])this.items.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).toArray(Item[]::new);
    }

    private Item[] itemsForSubject(String subject) {
        return (Item[])this.items.entrySet().stream().filter(e -> Objects.equals(subject, ((ItemKey)e.getKey()).subject())).map(Map.Entry::getValue).flatMap(Collection::stream).toArray(Item[]::new);
    }

    private Item[] itemsForCollection(String coll) {
        return (Item[])this.items.entrySet().stream().filter(e -> Objects.equals(coll, ((ItemKey)e.getKey()).coll())).map(Map.Entry::getValue).flatMap(Collection::stream).toArray(Item[]::new);
    }

    @Test
    public void metadataExportFindAllTest() throws Exception {
        int result = this.runDSpaceScript("metadata-export-filtered-items-report", "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, this.allItems());
    }

    @Test
    public void metadataExportPerSubjectTest() throws Exception {
        int result = this.runDSpaceScript("metadata-export-filtered-items-report", "-qp", "dc.subject:equals:" + this.subjects[0], "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, this.itemsForSubject(this.subjects[0]));
        result = this.runDSpaceScript("metadata-export-filtered-items-report", "-qp", "dc.subject:equals:" + this.subjects[1], "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, this.itemsForSubject(this.subjects[1]));
    }

    @Test
    public void metadataExportFilteredTest() throws Exception {
        int result = this.runDSpaceScript("metadata-export-filtered-items-report", "-f", "is_item", "-f", "is_discoverable", "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, this.allItems());
        result = this.runDSpaceScript("metadata-export-filtered-items-report", "-f", "has_one_original", "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, new Item[0]);
    }

    @Test
    public void metadataExportPerCollectionTest() throws Exception {
        UUID uuid = this.collUuids.get(this.collNames[0]);
        int result = this.runDSpaceScript("metadata-export-filtered-items-report", "-c", uuid.toString(), "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, this.itemsForCollection(this.collNames[0]));
        uuid = this.collUuids.get(this.collNames[1]);
        result = this.runDSpaceScript("metadata-export-filtered-items-report", "-c", uuid.toString(), "-n", this.filename);
        Assert.assertEquals((long)0L, (long)result);
        this.checkItemsPresentInFile(this.filename, this.itemsForCollection(this.collNames[1]));
    }

    private record ItemKey(String coll, String subject, String author) {
    }
}

