/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.suggestion.SolrSuggestionProvider;
import org.dspace.app.suggestion.Suggestion;
import org.dspace.app.suggestion.SuggestionService;
import org.dspace.app.suggestion.SuggestionUtils;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.external.factory.ExternalServiceFactory;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.ExternalDataProvider;
import org.dspace.external.provider.impl.OrcidPublicationDataProvider;
import org.dspace.external.service.ExternalDataService;
import org.dspace.kernel.ServiceManager;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.client.OrcidConfiguration;
import org.dspace.orcid.factory.OrcidServiceFactory;
import org.dspace.orcid.model.OrcidProfileSectionType;
import org.dspace.orcid.model.OrcidTokenResponseDTO;
import org.dspace.orcid.service.OrcidProfileSectionFactoryService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.orcid.jaxb.model.v3.release.record.Work;
import org.orcid.jaxb.model.v3.release.record.WorkBulk;
import org.orcid.jaxb.model.v3.release.record.summary.Works;
import org.springframework.beans.factory.annotation.Autowired;

public class SuggestionUtilsIT
extends AbstractIntegrationTestWithDatabase {
    private static ConfigurationService cfg;
    private static final String ORCID = "0000-1111-2222-3333";
    private static final String ACCESS_TOKEN = "32c83ccb-c6d5-4981-b6ea-6a34a36de8ab";
    private static final String BASE_XML_DIR_PATH = "org/dspace/app/orcid-works/";
    private OrcidPublicationDataProvider dataProvider;
    private SolrSuggestionProvider solrSuggestionProvider;
    private OrcidProfileSectionFactoryService profileSectionFactoryService;
    private ItemService itemService;
    private org.dspace.content.Collection collection;
    private ExternalDataProvider primaryProvider;
    private org.dspace.content.Collection persons;
    private OrcidConfiguration orcidConfiguration;
    private OrcidClient orcidClientMock;
    private OrcidClient orcidClient;
    private String originalClientId;
    @Autowired
    private SuggestionService suggestionService;

    @Before
    public void setup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.persons = CollectionBuilder.createCollection(this.context, this.parentCommunity).withEntityType("Person").withName("Profiles").build();
        this.profileSectionFactoryService = OrcidServiceFactory.getInstance().getOrcidProfileSectionFactoryService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.context.restoreAuthSystemState();
        cfg = DSpaceServicesFactory.getInstance().getConfigurationService();
        ServiceManager serviceManager = DSpaceServicesFactory.getInstance().getServiceManager();
        HashMap providers = (HashMap)serviceManager.getServiceByName("suggestionProviders", HashMap.class);
        this.solrSuggestionProvider = (SolrSuggestionProvider)providers.get("scopus");
        this.dataProvider = (OrcidPublicationDataProvider)new DSpace().getServiceManager().getServiceByName("orcidPublicationDataProvider", OrcidPublicationDataProvider.class);
        ExternalDataService externalDataService = ExternalServiceFactory.getInstance().getExternalDataService();
        this.primaryProvider = externalDataService.getExternalDataProvider("openaireFunding");
        this.orcidConfiguration = (OrcidConfiguration)new DSpace().getServiceManager().getServiceByName("org.dspace.orcid.client.OrcidConfiguration", OrcidConfiguration.class);
        this.orcidClientMock = (OrcidClient)Mockito.mock(OrcidClient.class);
        this.orcidClient = this.dataProvider.getOrcidClient();
        this.dataProvider.setReadPublicAccessToken(null);
        this.dataProvider.setOrcidClient(this.orcidClientMock);
        this.originalClientId = this.orcidConfiguration.getClientId();
        this.orcidConfiguration.setClientId("DSPACE-CLIENT-ID");
        this.orcidConfiguration.setClientSecret("DSPACE-CLIENT-SECRET");
        Mockito.when((Object)this.orcidClientMock.getReadPublicAccessToken()).thenReturn((Object)this.buildTokenResponse(ACCESS_TOKEN));
        Mockito.when((Object)this.orcidClientMock.getWorks((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)ORCID))).thenReturn((Object)this.unmarshall("works.xml", Works.class));
        Mockito.when((Object)this.orcidClientMock.getWorks((String)ArgumentMatchers.eq((Object)ORCID))).thenReturn((Object)this.unmarshall("works.xml", Works.class));
        Mockito.when((Object)this.orcidClientMock.getObject((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)ORCID), (String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(Work.class))).then(invocation -> Optional.of(this.unmarshall("work-" + invocation.getArgument(2) + ".xml", Work.class)));
        Mockito.when((Object)this.orcidClientMock.getObject((String)ArgumentMatchers.eq((Object)ORCID), (String)ArgumentMatchers.any(), (Class)ArgumentMatchers.eq(Work.class))).then(invocation -> Optional.of(this.unmarshall("work-" + invocation.getArgument(1) + ".xml", Work.class)));
        Mockito.when((Object)this.orcidClientMock.getWorkBulk((String)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)ORCID), (List)ArgumentMatchers.any())).then(invocation -> this.unmarshallWorkBulk((List)invocation.getArgument(2)));
        Mockito.when((Object)this.orcidClientMock.getWorkBulk((String)ArgumentMatchers.eq((Object)ORCID), (List)ArgumentMatchers.any())).then(invocation -> this.unmarshallWorkBulk((List)invocation.getArgument(1)));
    }

    @After
    public void after() {
        this.dataProvider.setOrcidClient(this.orcidClient);
        this.orcidConfiguration.setClientId(this.originalClientId);
    }

    @Test
    public void testGetAllEntriesByMetadatum() {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.persons).withTitle("Test profile").withScopusAuthorIdentifier("SCOPUS-123456").withResearcherIdentifier("R-ID-01").build();
        this.context.restoreAuthSystemState();
        List<MetadataValue> values = List.of(this.getMetadata(item, "person.identifier.scopus-author-id", 0));
        Object firstOrcidObject = this.profileSectionFactoryService.createOrcidObject(this.context, values, OrcidProfileSectionType.EXTERNAL_IDS);
        Optional optional = this.dataProvider.getExternalDataObject("0000-1111-2222-3333::277902");
        ExternalDataObject externalDataObject = (ExternalDataObject)optional.get();
        String openAireId = externalDataObject.getId();
        Suggestion suggestion = new Suggestion(this.solrSuggestionProvider.getSourceName(), item, openAireId);
        suggestion.getMetadata().add(new MetadataValueDTO("dc", "title", null, null, "dcTitle"));
        suggestion.setDisplay(SuggestionUtils.getFirstEntryByMetadatum((ExternalDataObject)externalDataObject, (String)"dc", (String)"title", null));
        suggestion.getMetadata().add(new MetadataValueDTO("dc", "date", "issued", null, Instant.now().toString()));
        suggestion.getMetadata().add(new MetadataValueDTO("dc", "description", "abstract", null, "description"));
        suggestion.setExternalSourceUri(cfg.getProperty("dspace.server.url") + "/api/integration/externalsources/" + this.primaryProvider.getSourceIdentifier() + "/entryValues/" + openAireId);
        List result = SuggestionUtils.getAllEntriesByMetadatum((ExternalDataObject)externalDataObject, (String)"dc", (String)"title", null);
        Assert.assertTrue((result != null && !result.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)SuggestionUtils.getAllEntriesByMetadatum((ExternalDataObject)externalDataObject, (String)"dc.title"), (Collection)result));
        String firstResult = SuggestionUtils.getFirstEntryByMetadatum((ExternalDataObject)externalDataObject, (String)"dc", (String)"title", null);
        Assert.assertTrue((boolean)"Another cautionary tale.".equalsIgnoreCase(firstResult));
        firstResult = SuggestionUtils.getFirstEntryByMetadatum((ExternalDataObject)externalDataObject, (String)"dc.title");
        Assert.assertTrue((boolean)"Another cautionary tale.".equalsIgnoreCase(firstResult));
    }

    private MetadataValue getMetadata(Item item, String metadataField, int place) {
        List values = this.itemService.getMetadataByMetadataString((DSpaceObject)item, metadataField);
        MatcherAssert.assertThat((Object)values.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(place)));
        return (MetadataValue)values.get(place);
    }

    private OrcidTokenResponseDTO buildTokenResponse(String accessToken) {
        OrcidTokenResponseDTO response = new OrcidTokenResponseDTO();
        response.setAccessToken(accessToken);
        return response;
    }

    private WorkBulk unmarshallWorkBulk(List<String> putCodes) throws Exception {
        return this.unmarshall("workBulk-" + String.join((CharSequence)"-", putCodes) + ".xml", WorkBulk.class);
    }

    private <T> T unmarshall(String fileName, Class<T> clazz) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        URL resource = this.getClass().getClassLoader().getResource(BASE_XML_DIR_PATH + fileName);
        if (resource == null) {
            throw new IllegalStateException("No resource found named org/dspace/app/orcid-works/" + fileName);
        }
        return (T)unmarshaller.unmarshal(new File(resource.getFile()));
    }
}

