/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion.scorer;

import java.util.List;
import org.dspace.app.suggestion.SuggestionEvidence;
import org.dspace.app.suggestion.scorer.AuthorNamesScorer;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.content.service.ItemService;
import org.dspace.external.model.ExternalDataObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.test.util.ReflectionTestUtils;

public class AuthorNamesScorerTest {
    @Mock
    private ItemService itemService;
    private AuthorNamesScorer authorNamesScorer;
    private Item researcher;
    private ExternalDataObject importRecord;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.authorNamesScorer = new AuthorNamesScorer();
        this.authorNamesScorer.setContributorMetadata(List.of("dc.contributor.author"));
        this.authorNamesScorer.setNames(List.of("dc.title"));
        this.researcher = (Item)Mockito.mock(Item.class);
        this.importRecord = (ExternalDataObject)Mockito.mock(ExternalDataObject.class);
        ReflectionTestUtils.setField((Object)this.authorNamesScorer, (String)"itemService", (Object)this.itemService);
    }

    @Test
    public void testComputeEvidence_DiacriticStrings() {
        List<TestMetadataValue> metadataValues = List.of(new TestMetadataValue("\u00f9\u00fa\u00ec\u00ed\u00f2\u00f3\u00e8\u00e9\u00e0\u00e1"));
        Mockito.when((Object)this.itemService.getMetadataByMetadataString((DSpaceObject)this.researcher, "dc.title")).thenReturn(metadataValues);
        Mockito.when((Object)this.importRecord.getMetadata()).thenReturn(List.of(new MetadataValueDTO("dc", "contributor", "author", null, "uuiiooeeaa")));
        SuggestionEvidence evidence = this.authorNamesScorer.computeEvidence(this.researcher, this.importRecord);
        Assert.assertNotNull((Object)evidence);
        Assert.assertTrue((evidence.getScore() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testComputeEvidence_MatchingAuthor() {
        List<TestMetadataValue> metadataValues = List.of(new TestMetadataValue("Jose Marquez"));
        Mockito.when((Object)this.itemService.getMetadataByMetadataString((DSpaceObject)this.researcher, "dc.title")).thenReturn(metadataValues);
        Mockito.when((Object)this.importRecord.getMetadata()).thenReturn(List.of(new MetadataValueDTO("dc", "contributor", "author", null, "Jos\u00e9 M\u00e1rquez")));
        SuggestionEvidence evidence = this.authorNamesScorer.computeEvidence(this.researcher, this.importRecord);
        Assert.assertNotNull((Object)evidence);
        Assert.assertEquals((double)100.0, (double)evidence.getScore(), (double)0.0);
    }

    @Test
    public void testComputeEvidence_NoMatchingAuthor() {
        List<TestMetadataValue> metadataValues = List.of(new TestMetadataValue("Jose Marquez"));
        Mockito.when((Object)this.itemService.getMetadataByMetadataString((DSpaceObject)this.researcher, "dc.title")).thenReturn(metadataValues);
        Mockito.when((Object)this.importRecord.getMetadata()).thenReturn(List.of(new MetadataValueDTO("dc", "contributor", "author", null, "John Doe")));
        SuggestionEvidence evidence = this.authorNamesScorer.computeEvidence(this.researcher, this.importRecord);
        Assert.assertNull((Object)evidence);
    }

    @Test
    public void testComputeEvidence_PartialMatchWithNormalization() {
        List<TestMetadataValue> metadataValues = List.of(new TestMetadataValue("Miguel de Cervantes Saavedra"), new TestMetadataValue("Miguel de Cervantes S."), new TestMetadataValue("Miguel de Cervantes"));
        Mockito.when((Object)this.itemService.getMetadataByMetadataString((DSpaceObject)this.researcher, "dc.title")).thenReturn(metadataValues);
        Mockito.when((Object)this.importRecord.getMetadata()).thenReturn(List.of(new MetadataValueDTO("dc", "contributor", "author", null, "Miguel de Cervantes")));
        SuggestionEvidence evidence = this.authorNamesScorer.computeEvidence(this.researcher, this.importRecord);
        Assert.assertNotNull((Object)evidence);
        Assert.assertEquals((double)68.0, (double)evidence.getScore(), (double)0.0);
    }

    @Test
    public void testComputeEvidence_NonLetterCharacters_Matching() {
        List<TestMetadataValue> metadataValues = List.of(new TestMetadataValue("Smith, Anna"));
        Mockito.when((Object)this.itemService.getMetadataByMetadataString((DSpaceObject)this.researcher, "dc.title")).thenReturn(metadataValues);
        Mockito.when((Object)this.importRecord.getMetadata()).thenReturn(List.of(new MetadataValueDTO("dc", "contributor", "author", null, "Anna Smith")));
        SuggestionEvidence evidence = this.authorNamesScorer.computeEvidence(this.researcher, this.importRecord);
        Assert.assertNotNull((Object)evidence);
        Assert.assertTrue((evidence.getScore() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testComputeEvidence_NoMetadataInItem() {
        Mockito.when((Object)this.itemService.getMetadataByMetadataString((DSpaceObject)this.researcher, "dc.title")).thenReturn(List.of());
        Mockito.when((Object)this.importRecord.getMetadata()).thenReturn(List.of(new MetadataValueDTO("dc", "contributor", "author", null, "Jos\u00e9 M\u00e1rquez")));
        SuggestionEvidence evidence = this.authorNamesScorer.computeEvidence(this.researcher, this.importRecord);
        Assert.assertNull((Object)evidence);
    }

    @Test
    public void testComputeEvidence_EmptyNamesInImportRecord() {
        List<TestMetadataValue> metadataValues = List.of(new TestMetadataValue("Jose Marquez"));
        Mockito.when((Object)this.itemService.getMetadataByMetadataString((DSpaceObject)this.researcher, "dc.title")).thenReturn(metadataValues);
        Mockito.when((Object)this.importRecord.getMetadata()).thenReturn(List.of());
        SuggestionEvidence evidence = this.authorNamesScorer.computeEvidence(this.researcher, this.importRecord);
        Assert.assertNull((Object)evidence);
    }

    private static class TestMetadataValue
    extends MetadataValue {
        public TestMetadataValue(String value) {
            this.setValue(value);
        }
    }
}

