/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.submit.factory.SubmissionServiceFactory;
import org.dspace.submit.service.SubmissionConfigService;
import org.junit.Assert;
import org.junit.Test;

public class SubmissionConfigIT
extends AbstractIntegrationTestWithDatabase {
    @Test
    public void testSubmissionMapByCommunityHandleSubmissionConfig() throws SubmissionConfigReaderException {
        this.context.turnOffAuthorisationSystem();
        Community topcom = CommunityBuilder.createCommunity(this.context, "123456789/topcommunity-test").withName("Parent Community").build();
        Community subcom1 = CommunityBuilder.createSubCommunity(this.context, topcom, "123456789/subcommunity-test").withName("Subcommunity 1").build();
        Community subcom2 = CommunityBuilder.createSubCommunity(this.context, topcom, "123456789/not-mapped3").withName("Subcommunity 2").build();
        Collection col1 = CollectionBuilder.createCollection(this.context, subcom1, "123456789/not-mapped1").withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection(this.context, subcom2, "123456789/not-mapped2").withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection(this.context, subcom1, "123456789/collection-test").withName("Collection 3").withEntityType("CustomEntityType").build();
        Collection col4 = CollectionBuilder.createCollection(this.context, subcom1, "123456789/not-mapped4").withName("Collection 4").withEntityType("CustomEntityType").build();
        this.context.restoreAuthSystemState();
        SubmissionConfigService submissionConfigService = SubmissionServiceFactory.getInstance().getSubmissionConfigService();
        SubmissionConfig submissionConfig1 = submissionConfigService.getSubmissionConfigByCollection(col1);
        Assert.assertEquals((Object)"subcommunitytest", (Object)submissionConfig1.getSubmissionName());
        SubmissionConfig submissionConfig2 = submissionConfigService.getSubmissionConfigByCollection(col2);
        Assert.assertEquals((Object)"topcommunitytest", (Object)submissionConfig2.getSubmissionName());
        SubmissionConfig submissionConfig3 = submissionConfigService.getSubmissionConfigByCollection(col3);
        Assert.assertEquals((Object)"collectiontest", (Object)submissionConfig3.getSubmissionName());
        SubmissionConfig submissionConfig4 = submissionConfigService.getSubmissionConfigByCollection(col4);
        Assert.assertEquals((Object)"entitytypetest", (Object)submissionConfig4.getSubmissionName());
    }
}

