/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.dspace.authority.AuthorityValue;
import org.junit.Assert;
import org.junit.Test;

public class AuthorityValueTest {
    @Test
    public void testStringToDate() {
        Instant actual = AuthorityValue.stringToDate((String)"not a date");
        Assert.assertNull((String)"Unparsable date should return null", (Object)actual);
        Instant expected = LocalDateTime.of(1957, 1, 27, 1, 23, 45).atZone(ZoneId.systemDefault()).toInstant();
        actual = AuthorityValue.stringToDate((String)"1957-01-27T01:23:45");
        Assert.assertEquals((String)"Local date-time should convert", (Object)expected, (Object)actual);
        expected = LocalDateTime.of(1957, 1, 27, 1, 23, 45, 678000000).atZone(ZoneOffset.of("-05")).toInstant();
        actual = AuthorityValue.stringToDate((String)"1957-01-27T01:23:45.678-05");
        Assert.assertEquals((String)"Zoned date-time with milliseconds should convert", (Object)expected, (Object)actual);
    }
}

