/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker.dao.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.dspace.AbstractUnitTest;
import org.dspace.checker.ChecksumResultCode;
import org.dspace.checker.dao.impl.ChecksumHistoryDAOImpl;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.CoreHelpers;
import org.dspace.core.HibernateDBConnection;
import org.hibernate.query.NativeQuery;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ChecksumHistoryDAOImplTest
extends AbstractUnitTest {
    @BeforeClass
    public static void setUpClass() throws SQLException, ClassNotFoundException {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws SQLException {
    }

    @Test
    public void testDeleteByDateAndCode() throws Exception {
        Instant retentionDate = Instant.now();
        ChecksumResultCode resultCode = ChecksumResultCode.CHECKSUM_MATCH;
        HibernateDBConnection dbc = (HibernateDBConnection)CoreHelpers.getDBConnection(this.context);
        NativeQuery qry = dbc.getSession().createNativeQuery("INSERT INTO checksum_history(check_id, process_end_date, result, bitstream_id) VALUES (:id, :date, :result, :bitstream)");
        BitstreamService bss = ContentServiceFactory.getInstance().getBitstreamService();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        Bitstream bs = bss.create(this.context, (InputStream)is);
        this.context.turnOffAuthorisationSystem();
        bss.update(this.context, (DSpaceObject)bs);
        this.context.restoreAuthSystemState();
        Instant matchDate = retentionDate.minus(1L, ChronoUnit.DAYS);
        int matchId = 0;
        qry.setParameter("id", (Object)matchId);
        qry.setParameter("date", (Object)matchDate);
        qry.setParameter("result", (Object)ChecksumResultCode.CHECKSUM_MATCH.name());
        qry.setParameter("bitstream", (Object)bs.getID());
        qry.executeUpdate();
        Instant noMatchDate = retentionDate.minus(2L, ChronoUnit.DAYS);
        int noMatchId = 1;
        qry.setParameter("id", (Object)noMatchId);
        qry.setParameter("date", (Object)noMatchDate);
        qry.setParameter("result", (Object)ChecksumResultCode.CHECKSUM_NO_MATCH.name());
        qry.setParameter("bitstream", (Object)bs.getID());
        qry.executeUpdate();
        Instant futureDate = retentionDate.plus(3L, ChronoUnit.DAYS);
        int futureMatchId = 2;
        qry.setParameter("id", (Object)futureMatchId);
        qry.setParameter("date", (Object)futureDate);
        qry.setParameter("result", (Object)ChecksumResultCode.CHECKSUM_MATCH.name());
        qry.setParameter("bitstream", (Object)bs.getID());
        qry.executeUpdate();
        ChecksumHistoryDAOImpl instance = new ChecksumHistoryDAOImpl();
        int expResult = 1;
        int result = instance.deleteByDateAndCode(this.context, retentionDate, resultCode);
        Assert.assertEquals((long)expResult, (long)result);
        qry = dbc.getSession().createQuery("SELECT COUNT(*) FROM ChecksumHistory WHERE id = :id");
        qry.setParameter("id", (Object)matchId);
        long count = (Long)qry.getSingleResult();
        Assert.assertEquals((String)"Should find no row at matchDate", (long)0L, (long)count);
        qry.setParameter("id", (Object)noMatchId);
        count = (Long)qry.getSingleResult();
        Assert.assertEquals((String)"Should find one row at noMatchDate", (long)1L, (long)count);
        qry.setParameter("id", (Object)futureMatchId);
        count = (Long)qry.getSingleResult();
        Assert.assertEquals((String)"Should find one row at futureDate", (long)1L, (long)count);
    }
}

