/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

public class ItemTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = LogManager.getLogger(ItemTest.class);
    private Item it;
    private MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    private BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private Collection collection;
    private Community owningCommunity;
    private AuthorizeService authorizeServiceSpy;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, true);
            this.it = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
            this.dspaceObject = this.it;
            this.context.restoreAuthSystemState();
            this.authorizeServiceSpy = (AuthorizeService)Mockito.spy((Object)this.authorizeService);
            ReflectionTestUtils.setField((Object)this.collectionService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
            ReflectionTestUtils.setField((Object)this.itemService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
            ReflectionTestUtils.setField((Object)this.workspaceItemService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
            ReflectionTestUtils.setField((Object)this.bundleService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
            ReflectionTestUtils.setField((Object)this.bitstreamService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
            ReflectionTestUtils.setField((Object)AuthorizeServiceFactory.getInstance(), (String)"authorizeService", (Object)this.authorizeServiceSpy);
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            this.itemService.delete(this.context, (DSpaceObject)this.it);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.collectionService.delete(this.context, (DSpaceObject)this.collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.restoreAuthSystemState();
        this.it = null;
        this.collection = null;
        this.owningCommunity = null;
        try {
            super.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testItemFind() throws Exception {
        UUID id = this.it.getID();
        Item found = (Item)this.itemService.find(this.context, id);
        MatcherAssert.assertThat((String)"testItemFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testItemFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
        MatcherAssert.assertThat((String)"testItemFind 2", (Object)found.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCreate() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.collection, 3);
        Item created = this.createItem();
        MatcherAssert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testCreate 1", (Object)created.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testFindAll() throws Exception {
        Iterator all = this.itemService.findAll(this.context);
        MatcherAssert.assertThat((String)"testFindAll 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        boolean added = false;
        while (all.hasNext()) {
            Item tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 1", (boolean)added);
    }

    @Test
    public void testFindBySubmitter() throws Exception {
        Iterator all = this.itemService.findBySubmitter(this.context, this.context.getCurrentUser());
        MatcherAssert.assertThat((String)"testFindBySubmitter 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        boolean added = false;
        while (all.hasNext()) {
            Item tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindBySubmitter 1", (boolean)added);
        this.context.turnOffAuthorisationSystem();
        all = this.itemService.findBySubmitter(this.context, this.ePersonService.create(this.context));
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testFindBySubmitter 2", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testFindBySubmitter 3", (boolean)all.hasNext());
    }

    @Test
    public void testFindInArchiveOrWithdrawnDiscoverableModifiedSince() throws Exception {
        Item tmp;
        this.it.setWithdrawn(true);
        this.it.setArchived(false);
        this.it.setDiscoverable(true);
        Iterator all = this.itemService.findInArchiveOrWithdrawnDiscoverableModifiedSince(this.context, this.it.getLastModified().plus(1L, ChronoUnit.DAYS));
        MatcherAssert.assertThat((String)"Returned list should not be null", (Object)all, (Matcher)CoreMatchers.notNullValue());
        boolean added = false;
        while (all.hasNext()) {
            tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertFalse((String)"List should not contain item when passing a date newer than item last-modified date", (boolean)added);
        all = this.itemService.findInArchiveOrWithdrawnDiscoverableModifiedSince(this.context, this.it.getLastModified().minus(1L, ChronoUnit.DAYS));
        MatcherAssert.assertThat((String)"Returned list should not be null", (Object)all, (Matcher)CoreMatchers.notNullValue());
        added = false;
        while (all.hasNext()) {
            tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertTrue((String)"List should contain item when passing a date older than item last-modified date", (boolean)added);
        this.it.setWithdrawn(false);
        this.it.setArchived(true);
        all = this.itemService.findInArchiveOrWithdrawnDiscoverableModifiedSince(this.context, this.it.getLastModified().minus(1L, ChronoUnit.DAYS));
        MatcherAssert.assertThat((String)"Returned list should not be null", (Object)all, (Matcher)CoreMatchers.notNullValue());
        added = false;
        while (all.hasNext()) {
            tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertTrue((String)"List should contain item when passing a date older than item last-modified date", (boolean)added);
        this.it.setDiscoverable(false);
        all = this.itemService.findInArchiveOrWithdrawnDiscoverableModifiedSince(this.context, this.it.getLastModified().minus(1L, ChronoUnit.DAYS));
        MatcherAssert.assertThat((String)"Returned list should not be null", (Object)all, (Matcher)CoreMatchers.notNullValue());
        added = false;
        while (all.hasNext()) {
            tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertFalse((String)"List should not contain non-discoverable items", (boolean)added);
    }

    @Test
    public void testFindInArchiveOrWithdrawnNonDiscoverableModifiedSince() throws Exception {
        Item tmp;
        this.it.setWithdrawn(true);
        this.it.setArchived(false);
        this.it.setDiscoverable(false);
        Iterator all = this.itemService.findInArchiveOrWithdrawnNonDiscoverableModifiedSince(this.context, this.it.getLastModified().plus(1L, ChronoUnit.DAYS));
        MatcherAssert.assertThat((String)"Returned list should not be null", (Object)all, (Matcher)CoreMatchers.notNullValue());
        boolean added = false;
        while (all.hasNext()) {
            tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertFalse((String)"List should not contain item when passing a date newer than item last-modified date", (boolean)added);
        all = this.itemService.findInArchiveOrWithdrawnNonDiscoverableModifiedSince(this.context, this.it.getLastModified().minus(1L, ChronoUnit.DAYS));
        MatcherAssert.assertThat((String)"Returned list should not be null", (Object)all, (Matcher)CoreMatchers.notNullValue());
        added = false;
        while (all.hasNext()) {
            tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertTrue((String)"List should contain item when passing a date older than item last-modified date", (boolean)added);
        this.it.setDiscoverable(true);
        all = this.itemService.findInArchiveOrWithdrawnNonDiscoverableModifiedSince(this.context, this.it.getLastModified().minus(1L, ChronoUnit.DAYS));
        MatcherAssert.assertThat((String)"Returned list should not be null", (Object)all, (Matcher)CoreMatchers.notNullValue());
        added = false;
        while (all.hasNext()) {
            tmp = (Item)all.next();
            if (!tmp.equals((Object)this.it)) continue;
            added = true;
        }
        Assert.assertFalse((String)"List should not contain discoverable items", (boolean)added);
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.it.getID() != null ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetHandle() {
        MatcherAssert.assertThat((String)"testGetHandle 0", (Object)this.it.getHandle(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testIsArchived() throws SQLException, AuthorizeException, IOException, IllegalAccessException {
        Assert.assertTrue((String)"testIsArchived 0", (boolean)this.it.isArchived());
        this.context.turnOffAuthorisationSystem();
        Item tmp = this.createItem();
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testIsArchived 1", (boolean)tmp.isArchived());
    }

    @Test
    public void testIsWithdrawn() {
        Assert.assertFalse((String)"testIsWithdrawn 0", (boolean)this.it.isWithdrawn());
    }

    @Test
    public void testGetLastModified() {
        MatcherAssert.assertThat((String)"testGetLastModified 0", (Object)this.it.getLastModified(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((String)"testGetLastModified is same day", (Object)this.it.getLastModified().atZone(ZoneOffset.UTC).toLocalDate(), (Object)LocalDate.now(ZoneOffset.UTC));
    }

    @Test
    public void testSetArchived() {
        this.it.setArchived(true);
        Assert.assertTrue((String)"testSetArchived 0", (boolean)this.it.isArchived());
    }

    @Test
    public void testSetOwningCollection() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.context.restoreAuthSystemState();
        this.it.setOwningCollection(c);
        MatcherAssert.assertThat((String)"testSetOwningCollection 0", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetOwningCollection 1", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.equalTo((Object)c));
    }

    @Test
    public void testGetOwningCollection() throws Exception {
        MatcherAssert.assertThat((String)"testGetOwningCollection 0", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((String)"testGetOwningCollection 1", (Object)this.it.getOwningCollection(), (Object)this.collection);
    }

    @Test
    public void testGetMetadata_4args() {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = "*";
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, lang);
        MatcherAssert.assertThat((String)"testGetMetadata_4args 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_4args 1", (dc.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMetadata_String() {
        String mdString = "dc.contributor.author";
        List dc = this.itemService.getMetadataByMetadataString((DSpaceObject)this.it, mdString);
        MatcherAssert.assertThat((String)"testGetMetadata_String 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_String 1", (dc.size() == 0 ? 1 : 0) != 0);
        mdString = "dc.contributor.*";
        dc = this.itemService.getMetadataByMetadataString((DSpaceObject)this.it, mdString);
        MatcherAssert.assertThat((String)"testGetMetadata_String 2", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_String 3", (dc.size() == 0 ? 1 : 0) != 0);
        mdString = "dc.contributor";
        dc = this.itemService.getMetadataByMetadataString((DSpaceObject)this.it, mdString);
        MatcherAssert.assertThat((String)"testGetMetadata_String 4", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetMetadata_String 5", (dc.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDS806() throws SQLException, AuthorizeException, NonUniqueMetadataException {
        this.context.turnOffAuthorisationSystem();
        MetadataSchema metadataSchema = this.metadataSchemaService.create(this.context, "test", "test");
        MetadataField metadataField = this.metadataFieldService.create(this.context, metadataSchema, "type", null, null);
        this.context.restoreAuthSystemState();
        String dcType = "DC-TYPE";
        String testType = "TEST-TYPE";
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, "dc", "type", null, null, dcType);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, "test", "type", null, null, testType);
        List values = this.itemService.getMetadata((DSpaceObject)this.it, "dc", "type", null, null);
        Assert.assertTrue((String)"Return results", (values.size() == 1 ? 1 : 0) != 0);
        this.context.turnOffAuthorisationSystem();
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.it, "test", "type", null, "*");
        this.metadataFieldService.delete(this.context, metadataField);
        this.metadataSchemaService.delete(this.context, metadataSchema);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testAddMetadata_5args_1() throws SQLException {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = null;
        String[] values = new String[]{"value0", "value1"};
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, Arrays.asList(values));
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, "*");
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_5args_1 1", (dc.size() == 2 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo(lang));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values[0]));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 7", (Object)((MetadataValue)dc.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 8", (Object)((MetadataValue)dc.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 9", (Object)((MetadataValue)dc.get(1)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 10", (Object)((MetadataValue)dc.get(1)).getLanguage(), (Matcher)CoreMatchers.equalTo(lang));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_1 11", (Object)((MetadataValue)dc.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values[1]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddMetadata_5args_no_values() throws Exception {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = null;
        String[] values = new String[]{};
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, Arrays.asList(values));
        Assert.fail((String)"IllegalArgumentException expected");
    }

    @Test
    public void testAddMetadata_7args_1_authority() throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException, SQLException {
        String schema = "dc";
        String element = "language";
        String qualifier = "iso";
        String lang = null;
        List<String> values = Arrays.asList("en_US", "en");
        List<String> authorities = Arrays.asList("accepted", "uncertain");
        List<Integer> confidences = Arrays.asList(0, 0);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, "*");
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_1 1", (dc.size() == 2 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo(lang));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values.get(0)));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 7", (Object)((MetadataValue)dc.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)authorities.get(0)));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 8", (Object)((MetadataValue)dc.get(0)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)confidences.get(0)));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 9", (Object)((MetadataValue)dc.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 10", (Object)((MetadataValue)dc.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 11", (Object)((MetadataValue)dc.get(1)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 12", (Object)((MetadataValue)dc.get(1)).getLanguage(), (Matcher)CoreMatchers.equalTo(lang));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 13", (Object)((MetadataValue)dc.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values.get(1)));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 14", (Object)((MetadataValue)dc.get(1)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)authorities.get(1)));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 15", (Object)((MetadataValue)dc.get(1)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)confidences.get(1)));
    }

    @Test
    public void testAddMetadata_7args_1_noauthority() throws SQLException {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = null;
        List<String> values = Arrays.asList("value0", "value1");
        List<String> authorities = Arrays.asList("auth0", "auth2");
        List<Integer> confidences = Arrays.asList(0, 0);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, "*");
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_1 1", (dc.size() == 2 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo(lang));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values.get(0)));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 7", (Object)((MetadataValue)dc.get(0)).getAuthority(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 8", (Object)((MetadataValue)dc.get(0)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)-1));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 9", (Object)((MetadataValue)dc.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 10", (Object)((MetadataValue)dc.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 11", (Object)((MetadataValue)dc.get(1)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 12", (Object)((MetadataValue)dc.get(1)).getLanguage(), (Matcher)CoreMatchers.equalTo(lang));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 13", (Object)((MetadataValue)dc.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values.get(1)));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 14", (Object)((MetadataValue)dc.get(1)).getAuthority(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"testAddMetadata_7args_1 15", (Object)((MetadataValue)dc.get(1)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddMetadata_7args_no_values() throws Exception {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = null;
        ArrayList values = new ArrayList();
        ArrayList authorities = new ArrayList();
        ArrayList confidences = new ArrayList();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        Assert.fail((String)"IllegalArgumentException expected");
    }

    @Test
    public void testAddMetadata_list_with_virtual_metadata() throws Exception {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = null;
        ArrayList<String> values = new ArrayList<String>(Arrays.asList("uuid-1", "uuid-2"));
        ArrayList<String> authorities = new ArrayList<String>(Arrays.asList("virtual::relationship-1", "virtual::relationship-2"));
        ArrayList<Integer> confidences = new ArrayList<Integer>(Arrays.asList(-1, -1));
        List valuesAdded = this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        Assert.assertNotNull((Object)valuesAdded);
        Assert.assertTrue((boolean)valuesAdded.isEmpty());
        String newValue = "new-metadata-value";
        String newAuthority = "auth0";
        Integer newConfidence = 0;
        values.add(newValue);
        authorities.add(newAuthority);
        confidences.add(newConfidence);
        valuesAdded = this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        Assert.assertNotNull((Object)valuesAdded);
        Assert.assertEquals((long)1L, (long)valuesAdded.size());
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, "*");
        Assert.assertNotNull((Object)dc);
        Assert.assertEquals((long)1L, (long)dc.size());
        Assert.assertEquals((Object)schema, (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName());
        Assert.assertEquals((Object)element, (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement());
        Assert.assertEquals((Object)qualifier, (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier());
        Assert.assertEquals((Object)newValue, (Object)((MetadataValue)dc.get(0)).getValue());
        Assert.assertNull((Object)((MetadataValue)dc.get(0)).getAuthority());
        Assert.assertEquals((long)-1L, (long)((MetadataValue)dc.get(0)).getConfidence());
    }

    @Test
    public void testAddMetadata_5args_2() throws SQLException {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = null;
        String value = "value0";
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, value);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, "*");
        MatcherAssert.assertThat((String)"testAddMetadata_5args_2 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_5args_2 1", (dc.size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testAddMetadata_5args_2 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_2 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_2 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_2 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo(lang));
        MatcherAssert.assertThat((String)"testAddMetadata_5args_2 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
    }

    @Test
    public void testAddMetadata_7args_2_authority() throws SQLException {
        String schema = "dc";
        String element = "language";
        String qualifier = "iso";
        String lang = null;
        String values = "en";
        String authorities = "accepted";
        int confidences = 0;
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, "*");
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_2 1", (dc.size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo(lang));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 7", (Object)((MetadataValue)dc.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)authorities));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 8", (Object)((MetadataValue)dc.get(0)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)confidences));
    }

    @Test
    public void testAddMetadata_7args_2_noauthority() throws SQLException {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "editor";
        String lang = null;
        String values = "value0";
        String authorities = "auth0";
        int confidences = 0;
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values, authorities, confidences);
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, "*");
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddMetadata_7args_2 1", (dc.size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 2", (Object)((MetadataValue)dc.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)schema));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 3", (Object)((MetadataValue)dc.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)element));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 4", (Object)((MetadataValue)dc.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qualifier));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 5", (Object)((MetadataValue)dc.get(0)).getLanguage(), (Matcher)CoreMatchers.equalTo(lang));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 6", (Object)((MetadataValue)dc.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)values));
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 7", (Object)((MetadataValue)dc.get(0)).getAuthority(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"testAddMetadata_7args_2 8", (Object)((MetadataValue)dc.get(0)).getConfidence(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testAddMetadata_single_virtual_metadata() throws Exception {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = null;
        String value = "uuid-1";
        String authority = "virtual::relationship-1";
        Integer confidence = -1;
        MetadataValue valuesAdded = this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, value, authority, confidence.intValue());
        Assert.assertNull((Object)valuesAdded);
        List mv = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, "*");
        Assert.assertNotNull((Object)mv);
        Assert.assertTrue((boolean)mv.isEmpty());
        MetadataField metadataField = this.metadataFieldService.findByElement(this.context, schema, element, qualifier);
        valuesAdded = this.itemService.addMetadata(this.context, (DSpaceObject)this.it, metadataField, lang, value, authority, confidence.intValue());
        Assert.assertNull((Object)valuesAdded);
        mv = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, "*");
        Assert.assertNotNull((Object)mv);
        Assert.assertTrue((boolean)mv.isEmpty());
    }

    @Test
    public void testClearMetadata() throws SQLException {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String lang = null;
        String values = "value0";
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, lang, values);
        this.itemService.clearMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, "*");
        List dc = this.itemService.getMetadata((DSpaceObject)this.it, schema, element, qualifier, "*");
        MatcherAssert.assertThat((String)"testClearMetadata 0", (Object)dc, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testClearMetadata 1", (dc.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSubmitter() throws Exception {
        MatcherAssert.assertThat((String)"testGetSubmitter 0", (Object)this.it.getSubmitter(), (Matcher)CoreMatchers.notNullValue());
        this.context.turnOffAuthorisationSystem();
        Item tmp = this.createItem();
        this.context.restoreAuthSystemState();
        Assert.assertEquals((String)"testGetSubmitter 1", (Object)tmp.getSubmitter(), (Object)this.context.getCurrentUser());
    }

    @Test
    public void testSetSubmitter() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        EPerson sub = this.ePersonService.create(this.context);
        this.context.restoreAuthSystemState();
        this.it.setSubmitter(sub);
        MatcherAssert.assertThat((String)"testSetSubmitter 0", (Object)this.it.getSubmitter(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetSubmitter 1", (Object)this.it.getSubmitter().getID(), (Matcher)CoreMatchers.equalTo((Object)sub.getID()));
    }

    @Test
    public void testGetCollections() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection collection = this.collectionService.create(this.context, this.owningCommunity);
        this.collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection, MetadataSchemaEnum.DC.getName(), "title", null, null, "collection B");
        this.it.addCollection(collection);
        collection = this.collectionService.create(this.context, this.owningCommunity);
        this.collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection, MetadataSchemaEnum.DC.getName(), "title", null, null, "collection A");
        this.it.addCollection(collection);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testGetCollections 0", (Object)this.it.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCollections 1", (this.it.getCollections().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testGetCollections 2", (boolean)((Collection)this.it.getCollections().get(1)).getName().equals("collection A"));
        Assert.assertTrue((String)"testGetCollections 3", (boolean)((Collection)this.it.getCollections().get(2)).getName().equals("collection B"));
    }

    @Test
    public void testGetCommunities() throws Exception {
        MatcherAssert.assertThat((String)"testGetCommunities 0", (Object)this.itemService.getCommunities(this.context, this.it), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCommunities 1", (this.itemService.getCommunities(this.context, this.it).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetBundles_0args() throws Exception {
        MatcherAssert.assertThat((String)"testGetBundles_0args 0", (Object)this.it.getBundles(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetBundles_0args 1", (this.it.getBundles().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetBundles_String() throws Exception {
        String name = "name";
        MatcherAssert.assertThat((String)"testGetBundles_String 0", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetBundles_String 1", (this.itemService.getBundles(this.it, name).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateBundleAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 3);
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        MatcherAssert.assertThat((String)"testCreateBundleAuth 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testCreateBundleAuth 1", (Object)created.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        MatcherAssert.assertThat((String)"testCreateBundleAuth 2", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreateBundleAuth 3", (this.itemService.getBundles(this.it, name).size() == 1 ? 1 : 0) != 0);
    }

    @Test(expected=SQLException.class)
    public void testCreateBundleNoName() throws Exception {
        this.bundleService.create(this.context, this.it, "");
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=SQLException.class)
    public void testCreateBundleNullName() throws Exception {
        this.bundleService.create(this.context, this.it, null);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateBundleNoAuth() throws Exception {
        String name = "bundle";
        this.bundleService.create(this.context, this.it, name);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddBundleAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 3);
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.itemService.addBundle(this.context, this.it, created);
        MatcherAssert.assertThat((String)"testAddBundleAuth 0", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddBundleAuth 1", (this.itemService.getBundles(this.it, name).size() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"testAddBundleAuth 2", (Object)((Bundle)this.itemService.getBundles(this.it, name).get(0)), (Matcher)CoreMatchers.equalTo((Object)created));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddBundleNoAuth() throws Exception {
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.itemService.addBundle(this.context, this.it, created);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveBundleAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.itemService.addBundle(this.context, this.it, created);
        this.context.restoreAuthSystemState();
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 4);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)created, 2);
        this.itemService.removeBundle(this.context, this.it, created);
        MatcherAssert.assertThat((String)"testRemoveBundleAuth 0", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveBundleAuth 1", (this.itemService.getBundles(this.it, name).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveBundleNoAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String name = "bundle";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.itemService.addBundle(this.context, this.it, created);
        this.context.restoreAuthSystemState();
        this.itemService.removeBundle(this.context, this.it, created);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateSingleBitstream_InputStream_StringAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 3);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 1, true);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Bundle.class), ArgumentMatchers.eq((int)3));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Bitstream.class), ArgumentMatchers.eq((int)1));
        String name = "new bundle";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, name);
        MatcherAssert.assertThat((String)"testCreateSingleBitstream_InputStream_StringAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSingleBitstream_InputStream_StringNoAuth() throws Exception {
        String name = "new bundle";
        File f = new File(testProps.get("test.bitstream").toString());
        this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, name);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateSingleBitstream_InputStreamAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 3);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 1, true);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Bundle.class), ArgumentMatchers.eq((int)3));
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Bitstream.class), ArgumentMatchers.eq((int)1));
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it);
        MatcherAssert.assertThat((String)"testCreateSingleBitstream_InputStreamAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSingleBitstream_InputStreamNoAuth() throws Exception {
        File f = new File(testProps.get("test.bitstream").toString());
        this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it);
        Assert.fail((String)"Expected exception");
    }

    @Test
    public void testGetNonInternalBitstreams() throws Exception {
        MatcherAssert.assertThat((String)"testGetNonInternalBitstreams 0", (Object)this.itemService.getNonInternalBitstreams(this.context, this.it), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetNonInternalBitstreams 1", (this.itemService.getNonInternalBitstreams(this.context, this.it).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveDSpaceLicenseAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.context.restoreAuthSystemState();
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 4);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)created, 2);
        this.itemService.removeDSpaceLicense(this.context, this.it);
        MatcherAssert.assertThat((String)"testRemoveDSpaceLicenseAuth 0", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveDSpaceLicenseAuth 1", (this.itemService.getBundles(this.it, name).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveDSpaceLicenseNoAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        this.context.restoreAuthSystemState();
        this.itemService.removeDSpaceLicense(this.context, this.it);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveLicensesAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, bsname);
        this.bitstreamService.setFormat(this.context, result, this.bitstreamFormatService.findByShortDescription(this.context, bsname));
        this.bundleService.addBitstream(this.context, created, result);
        this.context.restoreAuthSystemState();
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 4);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 1);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)created, 4);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)created, 2);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)result, 2);
        this.itemService.removeLicenses(this.context, this.it);
        MatcherAssert.assertThat((String)"testRemoveLicensesAuth 0", (Object)this.itemService.getBundles(this.it, name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveLicensesAuth 1", (this.itemService.getBundles(this.it, name).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveLicensesNoAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, bsname);
        this.bitstreamService.setFormat(this.context, result, this.bitstreamFormatService.findByShortDescription(this.context, bsname));
        this.bundleService.addBitstream(this.context, created, result);
        this.context.restoreAuthSystemState();
        this.itemService.removeLicenses(this.context, this.it);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testUpdateAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 1);
        this.itemService.update(this.context, (DSpaceObject)this.it);
    }

    @Test
    public void testUpdateAuth2() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)c, 1, false);
        this.itemService.update(this.context, (DSpaceObject)this.it);
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        this.itemService.update(this.context, (DSpaceObject)this.it);
    }

    @Test
    public void testWithdrawAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 1);
        Mockito.when((Object)this.authorizeServiceSpy.authorizeActionBoolean(this.context, (DSpaceObject)this.collection, 11)).thenReturn((Object)true);
        this.itemService.withdraw(this.context, this.it);
        Assert.assertTrue((String)"testWithdrawAuth 0", (boolean)this.it.isWithdrawn());
    }

    @Test(expected=AuthorizeException.class)
    public void testWithdrawNoAuth() throws Exception {
        this.itemService.withdraw(this.context, this.it);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testReinstateAuth() throws Exception {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 1);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.collection, 3);
        this.context.turnOffAuthorisationSystem();
        this.itemService.withdraw(this.context, this.it);
        this.context.restoreAuthSystemState();
        this.itemService.reinstate(this.context, this.it);
        Assert.assertFalse((String)"testReinstate 0", (boolean)this.it.isWithdrawn());
    }

    @Test(expected=AuthorizeException.class)
    public void testReinstateNoAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.withdraw(this.context, this.it);
        this.context.restoreAuthSystemState();
        this.itemService.reinstate(this.context, this.it);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testDeleteAuth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = this.createItem();
        this.context.restoreAuthSystemState();
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)item, 4, true);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)item, 2);
        UUID id = item.getID();
        this.itemService.delete(this.context, (DSpaceObject)item);
        Item found = (Item)this.itemService.find(this.context, id);
        MatcherAssert.assertThat((String)"testDeleteAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        this.itemService.delete(this.context, (DSpaceObject)this.it);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testEquals() throws SQLException, AuthorizeException, IOException, IllegalAccessException {
        Assert.assertFalse((String)"testEquals 0", (boolean)this.it.equals(null));
        this.context.turnOffAuthorisationSystem();
        Item item = this.createItem();
        this.context.restoreAuthSystemState();
        try {
            Assert.assertFalse((String)"testEquals 1", (boolean)this.it.equals((Object)item));
            Assert.assertTrue((String)"testEquals 2", (boolean)this.it.equals((Object)this.it));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.itemService.delete(this.context, (DSpaceObject)item);
            this.context.restoreAuthSystemState();
        }
    }

    @Test
    public void testIsOwningCollection() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.context.restoreAuthSystemState();
        boolean result = this.itemService.isOwningCollection(this.it, c);
        Assert.assertFalse((String)"testIsOwningCollection 0", (boolean)result);
    }

    @Override
    @Test
    public void testGetType() {
        MatcherAssert.assertThat((String)"testGetType 0", (Object)this.it.getType(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testReplaceAllItemPolicies() throws Exception {
        ArrayList<ResourcePolicy> newpolicies = new ArrayList<ResourcePolicy>();
        ResourcePolicy pol1 = this.resourcePolicyService.create(this.context, this.eperson, null);
        newpolicies.add(pol1);
        this.itemService.replaceAllItemPolicies(this.context, this.it, newpolicies);
        List retrieved = this.authorizeService.getPolicies(this.context, (DSpaceObject)this.it);
        MatcherAssert.assertThat((String)"testReplaceAllItemPolicies 0", (Object)retrieved, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testReplaceAllItemPolicies 1", (Object)retrieved.size(), (Matcher)CoreMatchers.equalTo((Object)newpolicies.size()));
    }

    @Test
    public void testReplaceAllBitstreamPolicies() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, bsname);
        this.bitstreamService.setFormat(this.context, result, this.bitstreamFormatService.findByShortDescription(this.context, bsname));
        this.bundleService.addBitstream(this.context, created, result);
        ArrayList<ResourcePolicy> newpolicies = new ArrayList<ResourcePolicy>();
        newpolicies.add(this.resourcePolicyService.create(this.context, this.eperson, null));
        newpolicies.add(this.resourcePolicyService.create(this.context, this.eperson, null));
        newpolicies.add(this.resourcePolicyService.create(this.context, this.eperson, null));
        this.context.restoreAuthSystemState();
        this.itemService.replaceAllBitstreamPolicies(this.context, this.it, newpolicies);
        ArrayList retrieved = new ArrayList();
        List bundles = this.it.getBundles();
        for (Bundle b : bundles) {
            retrieved.addAll(this.authorizeService.getPolicies(this.context, (DSpaceObject)b));
            retrieved.addAll(this.bundleService.getBitstreamPolicies(this.context, b));
        }
        Assert.assertFalse((String)"testReplaceAllBitstreamPolicies 0", (boolean)retrieved.isEmpty());
        boolean equals = true;
        for (int i = 0; i < newpolicies.size() && equals; ++i) {
            if (newpolicies.contains(retrieved.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testReplaceAllBitstreamPolicies 1", (boolean)equals);
    }

    @Test
    public void testRemoveGroupPolicies() throws Exception {
        this.context.turnOffAuthorisationSystem();
        ArrayList<ResourcePolicy> newpolicies = new ArrayList<ResourcePolicy>();
        Group g = this.groupService.create(this.context);
        ResourcePolicy pol1 = this.resourcePolicyService.create(this.context, null, g);
        newpolicies.add(pol1);
        this.itemService.replaceAllItemPolicies(this.context, this.it, newpolicies);
        this.itemService.removeGroupPolicies(this.context, this.it, g);
        this.context.restoreAuthSystemState();
        List retrieved = this.authorizeService.getPolicies(this.context, (DSpaceObject)this.it);
        MatcherAssert.assertThat((String)"testRemoveGroupPolicies 0", (Object)retrieved, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveGroupPolicies 1", (boolean)retrieved.isEmpty());
    }

    @Test
    public void testInheritCollectionDefaultPolicies() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        List defaultCollectionPolicies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)c, 9);
        ArrayList<ResourcePolicy> newPolicies = new ArrayList<ResourcePolicy>();
        for (ResourcePolicy collRp : defaultCollectionPolicies) {
            ResourcePolicy rp = this.resourcePolicyService.clone(this.context, collRp);
            rp.setAction(0);
            rp.setRpType(ResourcePolicy.TYPE_INHERITED);
            newPolicies.add(rp);
        }
        String name = "LICENSE";
        Bundle created = this.bundleService.create(this.context, this.it, name);
        created.setName(this.context, name);
        String bsname = "License";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream result = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), this.it, bsname);
        this.bitstreamService.setFormat(this.context, result, this.bitstreamFormatService.findByShortDescription(this.context, bsname));
        this.bundleService.addBitstream(this.context, created, result);
        this.context.restoreAuthSystemState();
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.it, 1, true);
        this.itemService.inheritCollectionDefaultPolicies(this.context, this.it, c);
        ArrayList retrieved = this.authorizeService.getPolicies(this.context, (DSpaceObject)this.it);
        boolean equals = true;
        for (int i = 0; i < retrieved.size() && equals; ++i) {
            if (newPolicies.contains(retrieved.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 0", (boolean)equals);
        retrieved = new ArrayList();
        List bundles = this.it.getBundles();
        for (Bundle b : bundles) {
            retrieved.addAll(this.authorizeService.getPolicies(this.context, (DSpaceObject)b));
            retrieved.addAll(this.bundleService.getBitstreamPolicies(this.context, b));
        }
        Assert.assertFalse((String)"testInheritCollectionDefaultPolicies 1", (boolean)retrieved.isEmpty());
        equals = true;
        for (int i = 0; i < newPolicies.size() && equals; ++i) {
            if (newPolicies.contains(retrieved.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 2", (boolean)equals);
    }

    @Test
    public void testInheritCollectionDefaultPolicies_custom_default_groups() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        Group item_read_role = this.collectionService.createDefaultReadGroup(this.context, c, "ITEM", 10);
        Group bitstream_read_role = this.collectionService.createDefaultReadGroup(this.context, c, "BITSTREAM", 9);
        this.context.restoreAuthSystemState();
        List defaultItemReadPolicies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)c, 10);
        Assert.assertEquals((String)"One DEFAULT_ITEM_READ policy", (long)1L, (long)defaultItemReadPolicies.size());
        Assert.assertEquals((String)"DEFAULT_ITEM_READ group", (Object)item_read_role.getName(), (Object)((ResourcePolicy)defaultItemReadPolicies.get(0)).getGroup().getName());
        List defaultBitstreamReadPolicies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)c, 9);
        Assert.assertEquals((String)"One DEFAULT_BITSTREAM_READ policy on Collection", (long)1L, (long)defaultBitstreamReadPolicies.size());
        Assert.assertEquals((String)"DEFAULT_BITSTREAM_READ group", (Object)bitstream_read_role.getName(), (Object)((ResourcePolicy)defaultBitstreamReadPolicies.get(0)).getGroup().getName());
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, c, false);
        Item item = workspaceItem.getItem();
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bitstream = this.itemService.createSingleBitstream(this.context, (InputStream)new FileInputStream(f), item);
        this.context.restoreAuthSystemState();
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)item, 1, true);
        this.itemService.inheritCollectionDefaultPolicies(this.context, item, c);
        List itemReadPolicies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)item, 0);
        Assert.assertEquals((String)"One READ policy on Item", (long)1L, (long)itemReadPolicies.size());
        Assert.assertEquals((String)"Item's READ group", (Object)item_read_role.getName(), (Object)((ResourcePolicy)itemReadPolicies.get(0)).getGroup().getName());
        List bitstreamReadPolicies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)bitstream, 0);
        Assert.assertEquals((String)"One READ policy on Bitstream", (long)1L, (long)bitstreamReadPolicies.size());
        Assert.assertEquals((String)"Bitstream's READ group", (Object)bitstream_read_role.getName(), (Object)((ResourcePolicy)bitstreamReadPolicies.get(0)).getGroup().getName());
        List bundles = item.getBundles("ORIGINAL");
        Bundle originalBundle = (Bundle)bundles.get(0);
        List bundleReadPolicies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)originalBundle, 0);
        Assert.assertEquals((String)"One READ policy on Bundle", (long)1L, (long)bundleReadPolicies.size());
        Assert.assertEquals((String)"Bundles's READ group", (Object)item_read_role.getName(), (Object)((ResourcePolicy)bundleReadPolicies.get(0)).getGroup().getName());
        this.context.turnOffAuthorisationSystem();
        this.collectionService.delete(this.context, (DSpaceObject)c);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testMove() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection from = this.createCollection();
        Collection to = this.createCollection();
        this.it.addCollection(from);
        this.it.setOwningCollection(from);
        this.itemService.move(this.context, this.it, from, to);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testMove 0", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testMove 1", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.equalTo((Object)to));
    }

    @Test
    public void testMoveSameCollection() throws Exception {
        this.context.turnOffAuthorisationSystem();
        while (this.it.getCollections().size() > 1) {
            this.it.removeCollection((Collection)this.it.getCollections().get(0));
        }
        Collection collection = (Collection)this.it.getCollections().get(0);
        this.it.setOwningCollection(collection);
        ItemService itemServiceSpy = (ItemService)Mockito.spy((Object)this.itemService);
        this.itemService.move(this.context, this.it, collection, collection);
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat((String)"testMoveSameCollection 0", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testMoveSameCollection 1", (Object)this.it.getOwningCollection(), (Matcher)CoreMatchers.equalTo((Object)collection));
        ((ItemService)Mockito.verify((Object)itemServiceSpy, (VerificationMode)Mockito.times((int)0))).delete(this.context, (DSpaceObject)this.it);
    }

    @Test
    public void testHasUploadedFiles() throws Exception {
        Assert.assertFalse((String)"testHasUploadedFiles 0", (boolean)this.itemService.hasUploadedFiles(this.it));
    }

    @Test
    public void testGetCollectionsNotLinked() throws Exception {
        List result = this.itemService.getCollectionsNotLinked(this.context, this.it);
        boolean isin = false;
        for (Collection c : result) {
            Iterator iit = this.itemService.findByCollection(this.context, c);
            while (iit.hasNext()) {
                if (!((Item)iit.next()).getID().equals(this.it.getID())) continue;
                isin = true;
            }
        }
        Assert.assertFalse((String)"testGetCollectionsNotLinked 0", (boolean)isin);
    }

    @Test
    public void testCanEditBooleanAuth() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.authorizeActionBoolean(this.context, (DSpaceObject)this.it, 1)).thenReturn((Object)true);
        Assert.assertTrue((String)"testCanEditBooleanAuth 0", (boolean)this.itemService.canEdit(this.context, this.it));
    }

    @Test
    public void testCanEditBooleanAuth2() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.authorizeActionBoolean(this.context, (DSpaceObject)this.owningCommunity, 1, false)).thenReturn((Object)true);
        Assert.assertTrue((String)"testCanEditBooleanAuth2 0", (boolean)this.itemService.canEdit(this.context, this.it));
    }

    @Test
    public void testCanEditBooleanAuth3() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.it.setOwningCollection(c);
        this.context.restoreAuthSystemState();
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)c, 1, false);
        Assert.assertTrue((String)"testCanEditBooleanAuth3 0", (boolean)this.itemService.canEdit(this.context, this.it));
    }

    @Test
    public void testCanEditBooleanNoAuth() throws Exception {
        Assert.assertFalse((String)"testCanEditBooleanNoAuth 0", (boolean)this.itemService.canEdit(this.context, this.it));
    }

    @Test
    public void testCanEditBooleanNoAuth2() throws Exception {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wi = this.workspaceItemService.create(this.context, this.collection, true);
        this.context.restoreAuthSystemState();
        Item item = wi.getItem();
        Mockito.when((Object)this.authorizeServiceSpy.authorizeActionBoolean(this.context, (DSpaceObject)item, 1)).thenReturn((Object)false);
        Assert.assertFalse((String)"testCanEditBooleanNoAuth2 0", (boolean)this.itemService.canEdit(this.context, item));
    }

    @Test
    public void testIsInProgressSubmission() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        WorkspaceItem wi = this.workspaceItemService.create(this.context, c, true);
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"testIsInProgressSubmission 0", (boolean)this.itemService.isInProgressSubmission(this.context, wi.getItem()));
    }

    @Test
    public void testIsInProgressSubmissionFalse() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        WorkspaceItem wi = this.workspaceItemService.create(this.context, c, true);
        Item item = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
        this.context.restoreAuthSystemState();
        Assert.assertFalse((String)"testIsInProgressSubmissionFalse 0", (boolean)this.itemService.isInProgressSubmission(this.context, item));
    }

    @Test
    public void testIsInProgressSubmissionFalse2() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        Collection c = this.createCollection();
        this.collectionService.createTemplateItem(this.context, c);
        this.collectionService.update(this.context, (DSpaceObject)c);
        Item item = c.getTemplateItem();
        this.context.restoreAuthSystemState();
        Assert.assertFalse((String)"testIsInProgressSubmissionFalse2 0", (boolean)this.itemService.isInProgressSubmission(this.context, item));
    }

    @Override
    @Test
    public void testGetName() {
        MatcherAssert.assertThat((String)"testGetName 0", (Object)this.it.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testFindByMetadataField() throws Exception {
        String schema = "dc";
        String element = "contributor";
        String qualifier = "author";
        String value = "value";
        Iterator result = this.itemService.findByMetadataField(this.context, schema, element, qualifier, value);
        MatcherAssert.assertThat((String)"testFindByMetadataField 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testFindByMetadataField 1", (boolean)result.hasNext());
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, null, value);
        this.itemService.update(this.context, (DSpaceObject)this.it);
        this.context.restoreAuthSystemState();
        result = this.itemService.findByMetadataField(this.context, schema, element, qualifier, value);
        MatcherAssert.assertThat((String)"testFindByMetadataField 3", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByMetadataField 4", (boolean)result.hasNext());
        Assert.assertTrue((String)"testFindByMetadataField 5", (boolean)((Item)result.next()).equals((Object)this.it));
    }

    @Override
    @Test
    public void testGetAdminObject() throws SQLException {
        MatcherAssert.assertThat((String)"testGetAdminObject 0", (Object)((Item)this.itemService.getAdminObject(this.context, (DSpaceObject)this.it, 4)), (Matcher)CoreMatchers.equalTo((Object)this.it));
        MatcherAssert.assertThat((String)"testGetAdminObject 1", (Object)((Item)this.itemService.getAdminObject(this.context, (DSpaceObject)this.it, 3)), (Matcher)CoreMatchers.equalTo((Object)this.it));
        MatcherAssert.assertThat((String)"testGetAdminObject 2", (Object)((Item)this.itemService.getAdminObject(this.context, (DSpaceObject)this.it, 2)), (Matcher)CoreMatchers.equalTo((Object)this.it));
        MatcherAssert.assertThat((String)"testGetAdminObject 3", (Object)((Item)this.itemService.getAdminObject(this.context, (DSpaceObject)this.it, 11)), (Matcher)CoreMatchers.equalTo((Object)this.it));
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        try {
            MatcherAssert.assertThat((String)"testGetParentObject 0", (Object)this.itemService.getParentObject(this.context, (DSpaceObject)this.it), (Matcher)CoreMatchers.notNullValue());
            this.context.turnOffAuthorisationSystem();
            Collection parent = this.createCollection();
            this.it.setOwningCollection(parent);
            this.context.restoreAuthSystemState();
            MatcherAssert.assertThat((String)"testGetParentObject 1", (Object)this.itemService.getParentObject(this.context, (DSpaceObject)this.it), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((String)"testGetParentObject 2", (Object)((Collection)this.itemService.getParentObject(this.context, (DSpaceObject)this.it)), (Matcher)CoreMatchers.equalTo((Object)parent));
        }
        catch (AuthorizeException ex) {
            throw new AssertionError("Authorize Exception occurred", ex);
        }
    }

    @Test
    public void testFindByAuthorityValue() throws Exception {
        String schema = "dc";
        String element = "language";
        String qualifier = "iso";
        String value = "en";
        String authority = "accepted";
        int confidence = 0;
        Iterator result = this.itemService.findByAuthorityValue(this.context, schema, element, qualifier, value);
        MatcherAssert.assertThat((String)"testFindByAuthorityValue 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testFindByAuthorityValue 1", (boolean)result.hasNext());
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.it, schema, element, qualifier, null, value, authority, confidence);
        this.itemService.update(this.context, (DSpaceObject)this.it);
        this.context.restoreAuthSystemState();
        result = this.itemService.findByAuthorityValue(this.context, schema, element, qualifier, authority);
        MatcherAssert.assertThat((String)"testFindByAuthorityValue 3", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByAuthorityValue 4", (boolean)result.hasNext());
        MatcherAssert.assertThat((String)"testFindByAuthorityValue 5", (Object)((Item)result.next()), (Matcher)CoreMatchers.equalTo((Object)this.it));
    }

    @Test
    public void testFindByCollectionMapping() throws Exception {
        int limit = 5;
        int offset = 0;
        this.context.turnOffAuthorisationSystem();
        Collection colToMapTo = this.createCollection();
        Item item1 = this.createItem();
        Iterator result = this.itemService.findByCollectionMapping(this.context, colToMapTo, Integer.valueOf(limit), Integer.valueOf(offset));
        MatcherAssert.assertThat((String)"testFindByCollectionMapping 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testFindByCollectionMapping 1", (boolean)result.hasNext());
        this.collectionService.addItem(this.context, colToMapTo, item1);
        this.collectionService.update(this.context, (DSpaceObject)colToMapTo);
        this.context.restoreAuthSystemState();
        result = this.itemService.findByCollectionMapping(this.context, colToMapTo, Integer.valueOf(limit), Integer.valueOf(offset));
        MatcherAssert.assertThat((String)"testFindByCollectionMapping 3", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByCollectionMapping 4", (boolean)result.hasNext());
        MatcherAssert.assertThat((String)"testFindByCollectionMapping 5", (Object)((Item)result.next()), (Matcher)CoreMatchers.equalTo((Object)item1));
        this.context.turnOffAuthorisationSystem();
        Item item2 = this.createItem();
        this.collectionService.addItem(this.context, colToMapTo, item2);
        this.context.restoreAuthSystemState();
        limit = 5;
        offset = 1;
        result = this.itemService.findByCollectionMapping(this.context, colToMapTo, Integer.valueOf(limit), Integer.valueOf(offset));
        Item secondItemMapped = (Item)result.next();
        Assert.assertTrue((String)"testFindByCollectionMapping 7", (secondItemMapped.equals((Object)item1) || secondItemMapped.equals((Object)item2) ? 1 : 0) != 0);
        Assert.assertFalse((String)"testFindByCollectionMapping 8", (boolean)result.hasNext());
        limit = 1;
        offset = 0;
        result = this.itemService.findByCollectionMapping(this.context, colToMapTo, Integer.valueOf(limit), Integer.valueOf(offset));
        Item onlyItemFound = (Item)result.next();
        Assert.assertTrue((String)"testFindByCollectionMapping 9", (onlyItemFound.equals((Object)item1) || onlyItemFound.equals((Object)item2) ? 1 : 0) != 0);
        Assert.assertFalse((String)"testFindByCollectionMapping 10", (boolean)result.hasNext());
        limit = 5;
        offset = 3;
        result = this.itemService.findByCollectionMapping(this.context, colToMapTo, Integer.valueOf(limit), Integer.valueOf(offset));
        Assert.assertFalse((String)"testFindByCollectionMapping 11", (boolean)result.hasNext());
    }

    @Test
    public void testCountByCollectionMapping() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection colToMapTo = this.createCollection();
        Item item1 = this.createItem();
        Item item2 = this.createItem();
        int result = this.itemService.countByCollectionMapping(this.context, colToMapTo);
        MatcherAssert.assertThat((String)"testFindByCollectionMapping 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByCollectionMapping 1", (result == 0 ? 1 : 0) != 0);
        this.collectionService.addItem(this.context, colToMapTo, item1);
        this.collectionService.addItem(this.context, colToMapTo, item2);
        this.collectionService.update(this.context, (DSpaceObject)colToMapTo);
        this.context.restoreAuthSystemState();
        result = this.itemService.countByCollectionMapping(this.context, colToMapTo);
        MatcherAssert.assertThat((String)"testFindByCollectionMapping 3", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByCollectionMapping 1", (result == 2 ? 1 : 0) != 0);
    }

    protected Collection createCollection() throws SQLException, AuthorizeException {
        return this.collectionService.create(this.context, this.owningCommunity);
    }

    protected Item createItem() throws SQLException, IOException, AuthorizeException, IllegalAccessException {
        WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
        return this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
    }
}

